/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.component.PackagedAutoDataComponents;

public class MarkerItem
extends Item {
    public MarkerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (!level.isClientSide && !player.isShiftKeyDown()) {
            if (stack.has(PackagedAutoDataComponents.MARKER_POS)) {
                return super.onItemUseFirst(stack, context);
            }
            DirectionalGlobalPos pos = new DirectionalGlobalPos((ResourceKey<Level>)level.dimension(), context.getClickedPos(), context.getClickedFace());
            DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.MARKER_POS.get(), (Object)pos).build();
            if (stack.getCount() > 1) {
                ItemStack stack1 = stack.split(1);
                stack1.applyComponents(patch);
                if (!player.getInventory().add(stack1)) {
                    ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), stack1);
                    item.setThrower((Entity)player);
                    level.addFreshEntity((Entity)item);
                }
            } else {
                stack.applyComponents(patch);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && player.isShiftKeyDown() && player.getItemInHand(hand).has(PackagedAutoDataComponents.MARKER_POS)) {
            ItemStack stack = player.getItemInHand(hand).copy();
            DataComponentPatch patch = DataComponentPatch.builder().remove((DataComponentType)PackagedAutoDataComponents.MARKER_POS.get()).build();
            stack.applyComponents(patch);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (stack.has(PackagedAutoDataComponents.MARKER_POS)) {
            DirectionalGlobalPos pos = (DirectionalGlobalPos)stack.get(PackagedAutoDataComponents.MARKER_POS);
            MutableComponent dimComponent = Component.literal((String)pos.dimension().location().toString());
            tooltip.add((Component)Component.translatable((String)"misc.packagedauto.dimension", (Object[])new Object[]{dimComponent}));
            MutableComponent posComponent = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{pos.x(), pos.y(), pos.z()}));
            tooltip.add((Component)Component.translatable((String)"misc.packagedauto.position", (Object[])new Object[]{posComponent}));
            MutableComponent dirComponent = Component.translatable((String)("misc.packagedauto." + pos.direction().getName()));
            tooltip.add((Component)Component.translatable((String)"misc.packagedauto.direction", (Object[])new Object[]{dirComponent}));
        }
        super.appendHoverText(stack, context, tooltip, isAdvanced);
    }
}

