/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.item.PackagedAutoItems;
import thelm.packagedauto.util.MiscHelper;

public class PackageItem
extends Item {
    protected PackageItem() {
        super(new Item.Properties());
    }

    public static ItemStack makePackage(IPackageRecipeInfo recipeInfo, int index) {
        ItemStack stack = PackagedAutoItems.PACKAGE.toStack();
        if (recipeInfo != null) {
            DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.PACKAGE_INDEX.get(), (Object)index).set((DataComponentType)PackagedAutoDataComponents.RECIPE.get(), (Object)recipeInfo).build();
            stack.applyComponents(patch);
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && player.isShiftKeyDown()) {
            int index;
            IPackageRecipeInfo recipe;
            ItemStack stack = player.getItemInHand(hand).copy();
            ItemStack stack1 = stack.split(1);
            if (MiscHelper.INSTANCE.isPackage(stack1) && (recipe = (IPackageRecipeInfo)stack1.get(PackagedAutoDataComponents.RECIPE)).validPatternIndex(index = ((Integer)stack1.get(PackagedAutoDataComponents.PACKAGE_INDEX)).intValue())) {
                IPackagePattern pattern = recipe.getPatterns().get(index);
                List<ItemStack> inputs = pattern.getInputs();
                for (int i = 0; i < inputs.size(); ++i) {
                    ItemStack input = inputs.get(i).copy();
                    if (player.getInventory().add(input)) continue;
                    ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), input);
                    item.setThrower((Entity)player);
                    level.addFreshEntity((Entity)item);
                }
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        int index;
        IPackageRecipeInfo recipe;
        if (MiscHelper.INSTANCE.isPackage(stack) && (recipe = (IPackageRecipeInfo)stack.get(PackagedAutoDataComponents.RECIPE)).validPatternIndex(index = ((Integer)stack.get(PackagedAutoDataComponents.PACKAGE_INDEX)).intValue())) {
            tooltip.add((Component)recipe.getRecipeType().getDisplayName().append(": "));
            for (ItemStack is : recipe.getOutputs()) {
                if (is.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)) {
                    IVolumeStackWrapper vs = (IVolumeStackWrapper)is.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK);
                    tooltip.add((Component)Component.literal((String)(is.getCount() + "x")).append(vs.getAmountDesc()).append(" ").append((Component)ComponentUtils.wrapInSquareBrackets((Component)vs.getDisplayName())));
                    continue;
                }
                tooltip.add((Component)Component.literal((String)(is.getCount() + " ")).append(is.copy().getDisplayName()));
            }
            tooltip.add((Component)Component.translatable((String)"item.packagedauto.package.index", (Object[])new Object[]{index}));
            tooltip.add((Component)Component.translatable((String)"item.packagedauto.package.items"));
            List<ItemStack> recipeInputs = recipe.getInputs();
            List<ItemStack> packageItems = recipeInputs.subList(9 * index, Math.min(9 * index + 9, recipeInputs.size()));
            for (ItemStack is : packageItems) {
                if (is.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)) {
                    IVolumeStackWrapper vs = (IVolumeStackWrapper)is.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK);
                    tooltip.add((Component)Component.literal((String)(is.getCount() + "x")).append(vs.getAmountDesc()).append(" ").append((Component)ComponentUtils.wrapInSquareBrackets((Component)vs.getDisplayName())));
                    continue;
                }
                tooltip.add((Component)Component.literal((String)(is.getCount() + " ")).append(is.copy().getDisplayName()));
            }
        }
        super.appendHoverText(stack, context, tooltip, isAdvanced);
    }
}

