/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.component.PackagedAutoDataComponents;

public class RecipeHolderItem
extends Item {
    protected RecipeHolderItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && player.isShiftKeyDown() && player.getItemInHand(hand).has(PackagedAutoDataComponents.RECIPE_LIST)) {
            ItemStack stack = player.getItemInHand(hand).copy();
            DataComponentPatch patch = DataComponentPatch.builder().remove((DataComponentType)PackagedAutoDataComponents.RECIPE_LIST.get()).build();
            stack.applyComponents(patch);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (stack.has(PackagedAutoDataComponents.RECIPE_LIST)) {
            List recipeList = (List)stack.get(PackagedAutoDataComponents.RECIPE_LIST);
            tooltip.add((Component)Component.translatable((String)"item.packagedauto.recipe_holder.recipes"));
            for (IPackageRecipeInfo recipe : recipeList) {
                MutableComponent component = recipe.getRecipeType().getDisplayName().append(": ");
                for (int i = 0; i < recipe.getOutputs().size(); ++i) {
                    ItemStack is;
                    if (i != 0) {
                        component.append(", ");
                    }
                    if ((is = recipe.getOutputs().get(i)).has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)) {
                        IVolumeStackWrapper vs = (IVolumeStackWrapper)is.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK);
                        component.append(is.getCount() + "x").append(vs.getAmountDesc()).append(" ").append((Component)ComponentUtils.wrapInSquareBrackets((Component)vs.getDisplayName()));
                        continue;
                    }
                    component.append(is.getCount() + " ").append(is.copy().getDisplayName());
                }
                tooltip.add((Component)component);
            }
        }
        super.appendHoverText(stack, context, tooltip, isAdvanced);
    }
}

