/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.SettingsClonerData;
import thelm.packagedauto.component.PackagedAutoDataComponents;

public class SettingsClonerItem
extends Item {
    protected SettingsClonerItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ISettingsCloneable) {
            ISettingsCloneable settable = (ISettingsCloneable)blockEntity;
            String configName = settable.getConfigTypeName();
            if (player.isShiftKeyDown()) {
                if (!level.isClientSide) {
                    CompoundTag dataTag = new CompoundTag();
                    ISettingsCloneable.Result result = settable.saveConfig(dataTag, (HolderLookup.Provider)level.registryAccess(), player);
                    if (result.type() != ISettingsCloneable.ResultType.FAIL) {
                        SettingsClonerData data = new SettingsClonerData(configName, dataTag, (ResourceKey<Level>)level.dimension(), pos);
                        DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.CLONER_DATA.get(), (Object)data).build();
                        stack.applyComponents(patch);
                        player.sendSystemMessage((Component)Component.translatable((String)"item.packagedauto.settings_cloner.saved"));
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"item.packagedauto.settings_cloner.not_saved", (Object[])new Object[]{result.message()}).withStyle(ChatFormatting.RED));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.has(PackagedAutoDataComponents.CLONER_DATA)) {
                if (!level.isClientSide) {
                    SettingsClonerData data = (SettingsClonerData)stack.get(PackagedAutoDataComponents.CLONER_DATA);
                    if (configName.equals(data.type())) {
                        ISettingsCloneable.Result result = settable.loadConfig(data.data(), (HolderLookup.Provider)level.registryAccess(), player);
                        switch (result.type()) {
                            case SUCCESS: {
                                player.sendSystemMessage((Component)Component.translatable((String)"item.packagedauto.settings_cloner.loaded"));
                                break;
                            }
                            case PARTIAL: {
                                player.sendSystemMessage((Component)Component.translatable((String)"item.packagedauto.settings_cloner.partial_loaded", (Object[])new Object[]{result.message()}));
                                break;
                            }
                            case FAIL: {
                                player.sendSystemMessage((Component)Component.translatable((String)"item.packagedauto.settings_cloner.not_loaded", (Object[])new Object[]{result.message()}).withStyle(ChatFormatting.RED));
                            }
                        }
                    } else {
                        MutableComponent errorMessage = Component.translatable((String)"item.packagedauto.settings_cloner.incompatible");
                        player.sendSystemMessage((Component)Component.translatable((String)"item.packagedauto.settings_cloner.not_loaded", (Object[])new Object[]{errorMessage}).withStyle(ChatFormatting.RED));
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && player.isShiftKeyDown() && player.getItemInHand(hand).has(PackagedAutoDataComponents.CLONER_DATA)) {
            ItemStack stack = player.getItemInHand(hand).copy();
            player.sendSystemMessage((Component)Component.translatable((String)"item.packagedauto.settings_cloner.cleared"));
            DataComponentPatch patch = DataComponentPatch.builder().remove((DataComponentType)PackagedAutoDataComponents.CLONER_DATA.get()).build();
            stack.applyComponents(patch);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (stack.has(PackagedAutoDataComponents.CLONER_DATA)) {
            SettingsClonerData data = (SettingsClonerData)stack.get(PackagedAutoDataComponents.CLONER_DATA);
            MutableComponent typeComponent = Component.translatable((String)data.type());
            tooltip.add((Component)Component.translatable((String)"item.packagedauto.settings_cloner.contents", (Object[])new Object[]{typeComponent}));
            MutableComponent dimComponent = Component.literal((String)data.dimension().location().toString());
            tooltip.add((Component)Component.translatable((String)"item.packagedauto.settings_cloner.dimension", (Object[])new Object[]{dimComponent}));
            MutableComponent posComponent = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{data.x(), data.y(), data.z()}));
            tooltip.add((Component)Component.translatable((String)"item.packagedauto.settings_cloner.position", (Object[])new Object[]{posComponent}));
        }
        super.appendHoverText(stack, context, tooltip, isAdvanced);
    }
}

