/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.recipe.CraftingPackageRecipeType;
import thelm.packagedauto.recipe.ICraftingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class CraftingPackageRecipeInfo
implements ICraftingPackageRecipeInfo {
    public static final MapCodec<CraftingPackageRecipeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(CraftingPackageRecipeInfo::getRecipeId), (App)Codec.INT.fieldOf("width").forGetter(CraftingPackageRecipeInfo::getMatrixWidth), (App)Codec.INT.fieldOf("height").forGetter(CraftingPackageRecipeInfo::getMatrixHeight), (App)ItemStack.OPTIONAL_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(9).fieldOf("input").forGetter(CraftingPackageRecipeInfo::getMatrixAsList)).apply((Applicative)instance, CraftingPackageRecipeInfo::new));
    public static final Codec<CraftingPackageRecipeInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftingPackageRecipeInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CraftingPackageRecipeInfo::getRecipeId, (StreamCodec)ByteBufCodecs.INT, CraftingPackageRecipeInfo::getMatrixWidth, (StreamCodec)ByteBufCodecs.INT, CraftingPackageRecipeInfo::getMatrixHeight, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, CraftingPackageRecipeInfo::getMatrixAsList, CraftingPackageRecipeInfo::new);
    private final ResourceLocation id;
    private final CraftingRecipe recipe;
    private final List<ItemStack> input;
    private final CraftingInput matrix;
    private final ItemStack output;
    private final List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public CraftingPackageRecipeInfo(ResourceLocation id, int width, int height, List<ItemStack> matrixSer) {
        this.id = id;
        this.matrix = CraftingInput.of((int)width, (int)height, matrixSer);
        this.input = MiscHelper.INSTANCE.condenseStacks(this.matrix.items());
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i));
            ++i;
        }
        Recipe recipeSer = MiscHelper.INSTANCE.getRecipeManager().byKey(id).map(RecipeHolder::value).orElse(null);
        if (recipeSer instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe;
            this.recipe = craftingRecipe = (CraftingRecipe)recipeSer;
            this.output = this.recipe.assemble((RecipeInput)this.matrix, (HolderLookup.Provider)MiscHelper.INSTANCE.getRegistryAccess()).copy();
        } else {
            this.recipe = null;
            this.output = ItemStack.EMPTY;
        }
    }

    public CraftingPackageRecipeInfo(List<ItemStack> inputs, Level level) {
        NonNullList matrixList = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        int[] slotArray = CraftingPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            ItemStack toSet = inputs.get(slotArray[i]);
            toSet.setCount(1);
            matrixList.set(i, (Object)toSet.copy());
        }
        this.matrix = CraftingInput.of((int)3, (int)3, (List)matrixList);
        RecipeHolder recipeHolder = MiscHelper.INSTANCE.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.matrix, level).orElse(null);
        if (recipeHolder != null) {
            this.id = recipeHolder.id();
            this.recipe = (CraftingRecipe)recipeHolder.value();
            this.output = this.recipe.assemble((RecipeInput)this.matrix, (HolderLookup.Provider)level.registryAccess()).copy();
        } else {
            this.id = null;
            this.recipe = null;
            this.output = null;
        }
        this.input = MiscHelper.INSTANCE.condenseStacks(this.matrix.items());
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i));
            ++i;
        }
    }

    @Override
    public IPackageRecipeType getRecipeType() {
        return CraftingPackageRecipeType.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.id != null && this.recipe != null;
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.copy();
    }

    @Override
    public CraftingRecipe getRecipe() {
        return this.recipe;
    }

    public ResourceLocation getRecipeId() {
        return this.id;
    }

    @Override
    public CraftingInput getMatrix() {
        return this.matrix;
    }

    public List<ItemStack> getMatrixAsList() {
        return Collections.unmodifiableList(this.matrix.items());
    }

    public int getMatrixWidth() {
        return this.matrix.width();
    }

    public int getMatrixHeight() {
        return this.matrix.height();
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return this.recipe.getRemainingItems((RecipeInput)this.matrix);
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        int[] slotArray = CraftingPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < this.matrix.height(); ++i) {
            for (int j = 0; j < this.matrix.width(); ++j) {
                map.put(slotArray[i * 3 + j], (Object)this.matrix.getItem(i * this.matrix.width() + j));
            }
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CraftingPackageRecipeInfo) {
            CraftingPackageRecipeInfo other = (CraftingPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals(this, this.recipe, other, other.recipe);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode(this, this.recipe);
    }
}

