/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.recipe.PositionedProcessingPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class PositionedProcessingPackageRecipeInfo
implements IPositionedProcessingPackageRecipeInfo {
    public static final MapCodec<PositionedProcessingPackageRecipeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(81).fieldOf("input").forGetter(PositionedProcessingPackageRecipeInfo::getMatrixAsList), (App)MiscHelper.LARGE_ITEM_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(9).fieldOf("output").forGetter(IPackageRecipeInfo::getOutputs)).apply((Applicative)instance, PositionedProcessingPackageRecipeInfo::new));
    public static final Codec<PositionedProcessingPackageRecipeInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, PositionedProcessingPackageRecipeInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, PositionedProcessingPackageRecipeInfo::getMatrixAsList, (StreamCodec)ItemStack.LIST_STREAM_CODEC, IPackageRecipeInfo::getOutputs, PositionedProcessingPackageRecipeInfo::new);
    private final List<ItemStack> input = new ArrayList<ItemStack>();
    private final Int2ObjectMap<ItemStack> matrix = new Int2ObjectArrayMap(81);
    private final List<ItemStack> output;
    private final List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public PositionedProcessingPackageRecipeInfo(List<ItemStack> inputs, List<ItemStack> outputs) {
        int i;
        for (i = 0; i < 81; ++i) {
            ItemStack stack = inputs.get(i).copy();
            if (stack.isEmpty()) continue;
            this.matrix.put(i, (Object)stack);
            this.input.add(stack);
        }
        this.output = MiscHelper.INSTANCE.condenseStacks(outputs, true);
        i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i, true));
            ++i;
        }
    }

    @Override
    public IPackageRecipeType getRecipeType() {
        return PositionedProcessingPackageRecipeType.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return !this.input.isEmpty();
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.unmodifiableList(this.output);
    }

    @Override
    public Int2ObjectMap<ItemStack> getMatrix() {
        return this.matrix;
    }

    public List<ItemStack> getMatrixAsList() {
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        for (int i = 0; i < 81; ++i) {
            matrixList.add((ItemStack)this.matrix.getOrDefault(i, (Object)ItemStack.EMPTY));
        }
        return matrixList;
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        map.putAll(this.matrix);
        for (int i = 0; i < this.output.size(); ++i) {
            map.put(i + 81, (Object)this.output.get(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PositionedProcessingPackageRecipeInfo) {
            PositionedProcessingPackageRecipeInfo other = (PositionedProcessingPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals(this, null, other, null);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode(this, null);
    }
}

