/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.util.DataComponentUtil;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.packagedauto.api.IMiscHelper;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.item.VolumePackageItem;
import thelm.packagedauto.util.PackagePattern;

public class MiscHelper
implements IMiscHelper {
    public static final MiscHelper INSTANCE = new MiscHelper();
    private static final Cache<CompoundTag, IPackageRecipeInfo> RECIPE_CACHE = CacheBuilder.newBuilder().maximumSize(500L).build();
    private static final Logger LOGGER = LogManager.getLogger();
    private static MinecraftServer server;
    public static final Codec<ItemStack> LARGE_ITEM_CODEC;

    private MiscHelper() {
    }

    @Override
    public List<ItemStack> condenseStacks(Container container) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(container.getContainerSize());
        for (int i = 0; i < container.getContainerSize(); ++i) {
            stacks.add(container.getItem(i));
        }
        return this.condenseStacks((List<ItemStack>)stacks);
    }

    @Override
    public List<ItemStack> condenseStacks(IItemHandler itemHandler) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(itemHandler.getSlots());
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            stacks.add(itemHandler.getStackInSlot(i));
        }
        return this.condenseStacks((List<ItemStack>)stacks);
    }

    @Override
    public List<ItemStack> condenseStacks(ItemStack ... stacks) {
        return this.condenseStacks(List.of(stacks));
    }

    @Override
    public List<ItemStack> condenseStacks(Stream<ItemStack> stacks) {
        return this.condenseStacks(stacks.toList());
    }

    @Override
    public List<ItemStack> condenseStacks(Iterable<ItemStack> stacks) {
        return this.condenseStacks(stacks instanceof List ? (List)stacks : Lists.newArrayList(stacks));
    }

    @Override
    public List<ItemStack> condenseStacks(List<ItemStack> stacks) {
        return this.condenseStacks(stacks, false);
    }

    @Override
    public List<ItemStack> condenseStacks(List<ItemStack> stacks, boolean ignoreStackSize) {
        Object2IntLinkedOpenHashMap map = new Object2IntLinkedOpenHashMap();
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            Pair pair = Pair.of((Object)stack.getItem(), (Object)stack.getComponentsPatch());
            if (!map.containsKey((Object)pair)) {
                map.put((Object)pair, 0);
            }
            map.addTo((Object)pair, stack.getCount());
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            int limit;
            Pair pair = (Pair)entry.getKey();
            Item item = (Item)pair.getLeft();
            DataComponentPatch patch = (DataComponentPatch)pair.getRight();
            for (int count = entry.getIntValue(); count > 0; count -= limit) {
                ItemStack toAdd = new ItemStack((ItemLike)item, 1);
                toAdd.applyComponents(patch);
                limit = ignoreStackSize ? 1000000000 : Math.min(item.getMaxStackSize(toAdd), 1000000000);
                toAdd.setCount(Math.min(count, limit));
                list.add(toAdd);
            }
        }
        map.clear();
        return list;
    }

    @Override
    public ListTag saveAllItems(ListTag tagList, List<ItemStack> list, HolderLookup.Provider registries) {
        return this.saveAllItems(tagList, list, "Index", registries);
    }

    @Override
    public ListTag saveAllItems(ListTag tagList, List<ItemStack> list, String indexKey, HolderLookup.Provider registries) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = list.get(i);
            boolean empty = stack.isEmpty();
            if (empty && i != list.size() - 1) continue;
            if (empty) {
                stack = ItemStack.EMPTY;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.putByte(indexKey, (byte)i);
            this.saveItemWithLargeCount(nbt, stack, registries);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    @Override
    public void loadAllItems(ListTag tagList, List<ItemStack> list, HolderLookup.Provider registries) {
        this.loadAllItems(tagList, list, "Index", registries);
    }

    @Override
    public void loadAllItems(ListTag tagList, List<ItemStack> list, String indexKey, HolderLookup.Provider registries) {
        list.clear();
        try {
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag nbt = tagList.getCompound(i);
                int j = nbt.getByte(indexKey) & 0xFF;
                while (j >= list.size()) {
                    list.add(ItemStack.EMPTY);
                }
                if (j < 0) continue;
                ItemStack stack = this.loadItemWithLargeCount(nbt, registries);
                list.set(j, stack.isEmpty() ? ItemStack.EMPTY : stack);
            }
        }
        catch (IndexOutOfBoundsException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public CompoundTag saveItemWithLargeCount(CompoundTag nbt, ItemStack stack, HolderLookup.Provider registries) {
        if (!stack.isEmpty()) {
            nbt.merge((CompoundTag)DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)stack, LARGE_ITEM_CODEC, (HolderLookup.Provider)registries));
        }
        return nbt;
    }

    @Override
    public ItemStack loadItemWithLargeCount(CompoundTag nbt, HolderLookup.Provider registries) {
        return LARGE_ITEM_CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).result().orElse(ItemStack.EMPTY);
    }

    @Override
    public IPackagePattern getPattern(IPackageRecipeInfo recipeInfo, int index) {
        return new PackagePattern(recipeInfo, index);
    }

    @Override
    public List<ItemStack> getRemainingItems(Container container) {
        return this.getRemainingItems(IntStream.range(0, container.getContainerSize()).mapToObj(arg_0 -> ((Container)container).getItem(arg_0)).toList());
    }

    @Override
    public List<ItemStack> getRemainingItems(Container container, int minInclusive, int maxExclusive) {
        return this.getRemainingItems(IntStream.range(minInclusive, maxExclusive).mapToObj(arg_0 -> ((Container)container).getItem(arg_0)).toList());
    }

    @Override
    public List<ItemStack> getRemainingItems(ItemStack ... stacks) {
        return this.getRemainingItems(List.of(stacks));
    }

    @Override
    public List<ItemStack> getRemainingItems(List<ItemStack> stacks) {
        NonNullList ret = NonNullList.withSize((int)stacks.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, (Object)this.getContainerItem(stacks.get(i)));
        }
        return ret;
    }

    @Override
    public ItemStack getContainerItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (stack.getItem().hasCraftingRemainingItem(stack)) {
            if (!(stack = stack.getItem().getCraftingRemainingItem(stack)).isEmpty() && stack.isDamageableItem() && stack.getDamageValue() > stack.getMaxDamage()) {
                return ItemStack.EMPTY;
            }
            return stack;
        }
        if (stack.getCount() > 1) {
            stack = stack.copy();
            stack.setCount(stack.getCount() - 1);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack retStack = stack.copy();
        retStack.setCount(stackSize);
        return retStack;
    }

    @Override
    public boolean isPackage(ItemStack stack) {
        return stack.has(PackagedAutoDataComponents.RECIPE) && stack.has(PackagedAutoDataComponents.PACKAGE_INDEX);
    }

    @Override
    public boolean isEmpty(IItemHandler itemHandler) {
        if (itemHandler == null || itemHandler.getSlots() == 0) {
            return false;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack makeVolumePackage(IVolumeStackWrapper volumeStack) {
        return VolumePackageItem.makeVolumePackage(volumeStack);
    }

    @Override
    public ItemStack tryMakeVolumePackage(Object volumeStack) {
        return VolumePackageItem.tryMakeVolumePackage(volumeStack);
    }

    @Override
    public CompoundTag saveRecipe(CompoundTag nbt, IPackageRecipeInfo recipe, HolderLookup.Provider registries) {
        return nbt.merge(IPackageRecipeInfo.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)recipe).result().orElse(new CompoundTag()));
    }

    @Override
    public IPackageRecipeInfo loadRecipe(CompoundTag nbt, HolderLookup.Provider registries) {
        IPackageRecipeInfo recipe = (IPackageRecipeInfo)RECIPE_CACHE.getIfPresent((Object)nbt);
        if (recipe != null) {
            return recipe;
        }
        recipe = IPackageRecipeInfo.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).result().orElse(null);
        if (recipe != null) {
            RECIPE_CACHE.put((Object)nbt, (Object)recipe);
        }
        return recipe;
    }

    @Override
    public ListTag saveRecipeList(ListTag tagList, List<IPackageRecipeInfo> recipes, HolderLookup.Provider registries) {
        for (IPackageRecipeInfo recipe : recipes) {
            tagList.add((Object)this.saveRecipe(new CompoundTag(), recipe, registries));
        }
        return tagList;
    }

    @Override
    public List<IPackageRecipeInfo> loadRecipeList(ListTag tagList, HolderLookup.Provider registries) {
        ArrayList<IPackageRecipeInfo> recipes = new ArrayList<IPackageRecipeInfo>(tagList.size());
        for (int i = 0; i < tagList.size(); ++i) {
            IPackageRecipeInfo recipe = this.loadRecipe(tagList.getCompound(i), registries);
            if (recipe == null) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    @Override
    public boolean recipeEquals(IPackageRecipeInfo recipeA, Object recipeInternalA, IPackageRecipeInfo recipeB, Object recipeInternalB) {
        int i;
        if (!Objects.equals(recipeInternalA, recipeInternalB)) {
            return false;
        }
        List<ItemStack> inputsA = recipeA.getInputs();
        List<ItemStack> inputsB = recipeB.getInputs();
        if (inputsA.size() != inputsB.size()) {
            return false;
        }
        List<ItemStack> outputsA = recipeA.getOutputs();
        List<ItemStack> outputsB = recipeB.getOutputs();
        if (outputsA.size() != outputsB.size()) {
            return false;
        }
        for (i = 0; i < inputsA.size(); ++i) {
            if (ItemStack.matches((ItemStack)inputsA.get(i), (ItemStack)inputsB.get(i))) continue;
            return false;
        }
        for (i = 0; i < outputsA.size(); ++i) {
            if (ItemStack.matches((ItemStack)outputsA.get(i), (ItemStack)outputsB.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int recipeHashCode(IPackageRecipeInfo recipe, Object recipeInternal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean removeExactSet(List<ItemStack> offered, List<ItemStack> required, boolean simulate) {
        List<ItemStack> condensedRequired = this.condenseStacks(required, true);
        List<ItemStack> condensedOffered = this.condenseStacks(offered, true);
        block0: for (ItemStack req : condensedRequired) {
            for (ItemStack offer : condensedOffered) {
                if (req.getCount() > offer.getCount() || !req.is(offer.getItem()) || !req.isComponentsPatchEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)req, (ItemStack)offer)) continue;
                continue block0;
            }
            return false;
        }
        if (simulate) {
            return true;
        }
        for (ItemStack req : condensedRequired) {
            int count = req.getCount();
            for (ItemStack offer : offered) {
                if (offer.isEmpty() || !req.is(offer.getItem()) || !req.isComponentsPatchEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)req, (ItemStack)offer)) continue;
                int toRemove = Math.min(count, offer.getCount());
                offer.shrink(toRemove);
                if ((count -= toRemove) != 0) continue;
            }
        }
        return true;
    }

    @Override
    public boolean arePatternsDisjoint(List<IPackagePattern> patternList) {
        ObjectRBTreeSet set = new ObjectRBTreeSet(Comparator.comparing(pair -> Pair.of((Object)BuiltInRegistries.ITEM.getKey((Object)((Item)pair.getLeft())), (Object)String.valueOf(pair.getRight()))));
        for (IPackagePattern pattern : patternList) {
            List<ItemStack> condensedInputs = this.condenseStacks(pattern.getInputs(), true);
            for (ItemStack stack : condensedInputs) {
                Pair toAdd = Pair.of((Object)stack.getItem(), (Object)stack.getComponentsPatch());
                if (set.contains((Object)toAdd)) {
                    return false;
                }
                set.add((Object)toAdd);
            }
        }
        set.clear();
        return true;
    }

    @Override
    public ItemStack insertItem(IItemHandler itemHandler, ItemStack stack, boolean requireEmptySlot, boolean simulate) {
        if (itemHandler == null || stack.isEmpty()) {
            return stack;
        }
        if (!requireEmptySlot) {
            return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemHandler.getStackInSlot(slot).isEmpty() || !(stack = itemHandler.insertItem(slot, stack, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @Override
    public ItemStack fillVolume(Level level, BlockPos pos, Direction direction, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(level, pos, direction)) {
            int simulateFilled;
            stack = stack.copy();
            IVolumeStackWrapper vStack = (IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK);
            IVolumeType vType = vStack.getVolumeType();
            while (!stack.isEmpty() && (simulateFilled = vType.fill(level, pos, direction, vStack, true)) == vStack.getAmount()) {
                if (!simulate) {
                    vType.fill(level, pos, direction, vStack, false);
                }
                stack.shrink(1);
                if (!stack.isEmpty()) continue;
                return ItemStack.EMPTY;
            }
        }
        return stack;
    }

    @Override
    public Runnable conditionalRunnable(BooleanSupplier conditionSupplier, Supplier<Runnable> trueRunnable, Supplier<Runnable> falseRunnable) {
        return () -> ((Runnable)(conditionSupplier.getAsBoolean() ? trueRunnable : falseRunnable).get()).run();
    }

    @Override
    public <T> Supplier<T> conditionalSupplier(BooleanSupplier conditionSupplier, Supplier<Supplier<T>> trueSupplier, Supplier<Supplier<T>> falseSupplier) {
        return () -> ((Supplier)(conditionSupplier.getAsBoolean() ? trueSupplier : falseSupplier).get()).get();
    }

    public void setServer(MinecraftServer server) {
        MiscHelper.server = server;
    }

    @Override
    public RecipeManager getRecipeManager() {
        return server != null ? server.getRecipeManager() : (RecipeManager)this.conditionalSupplier(() -> ((Dist)FMLEnvironment.dist).isClient(), () -> () -> Minecraft.getInstance().level.getRecipeManager(), () -> () -> null).get();
    }

    @Override
    public RegistryAccess getRegistryAccess() {
        return server != null ? server.registryAccess() : (RegistryAccess)this.conditionalSupplier(() -> ((Dist)FMLEnvironment.dist).isClient(), () -> () -> Minecraft.getInstance().level.registryAccess(), () -> () -> null).get();
    }

    static {
        LARGE_ITEM_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("item").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.POSITIVE_INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new));
    }
}

