/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.api.adapter.recipe.smithing;

import me.myogoo.extendedterminal.adapter.recipe.smithing.SmithingTransformRecipeAdapter;
import me.myogoo.extendedterminal.adapter.recipe.smithing.SmithingTrimRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.IRecipeAdapter;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;

public interface ISmithingRecipeAdapter
extends IRecipeAdapter {
    public NonNullList<Ingredient> getIngredients();

    public boolean isTemplateIngredient(ItemStack var1);

    public boolean isBaseIngredient(ItemStack var1);

    public boolean isAdditionIngredient(ItemStack var1);

    public boolean isInComplete();

    public static ISmithingRecipeAdapter of(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
            return new SmithingTransformRecipeAdapter(transformRecipe);
        }
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
            return new SmithingTrimRecipeAdapter(trimRecipe);
        }
        throw new IllegalArgumentException("Unsupported SmithingRecipe type: " + recipe.getClass().getName());
    }
}

