/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.client.screen.extendedterminal;

import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.TabButton;
import java.util.EnumMap;
import java.util.Map;
import me.myogoo.extendedterminal.client.screen.ETTerminalBaseScreen;
import me.myogoo.extendedterminal.client.screen.extendedterminal.gui.ETTerminalModePanel;
import me.myogoo.extendedterminal.client.screen.extendedterminal.gui.panels.AnvilPanel;
import me.myogoo.extendedterminal.client.screen.extendedterminal.gui.panels.CraftingPanel;
import me.myogoo.extendedterminal.client.screen.extendedterminal.gui.panels.SmithingTablePanel;
import me.myogoo.extendedterminal.client.screen.extendedterminal.gui.panels.StoneCutterPanel;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMenu;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMode;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.CraftingRecipe;

public class ETTerminalScreen<T extends ETTerminalMenu>
extends ETTerminalBaseScreen<CraftingRecipe, T> {
    private final Map<ETTerminalMode, ETTerminalModePanel> modePanels = new EnumMap<ETTerminalMode, ETTerminalModePanel>(ETTerminalMode.class);
    private final Map<ETTerminalMode, TabButton> modeTabButtons = new EnumMap<ETTerminalMode, TabButton>(ETTerminalMode.class);

    public ETTerminalScreen(T menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        for (ETTerminalMode mode : ETTerminalMode.values()) {
            ETTerminalModePanel panel = switch (mode) {
                default -> throw new MatchException(null, null);
                case ETTerminalMode.CRAFTING -> new CraftingPanel(this, this.widgets, this.clearBtn, this.clearToPlayerInvBtn);
                case ETTerminalMode.SMITHING -> new SmithingTablePanel(this, this.widgets);
                case ETTerminalMode.STONECUTTING -> new StoneCutterPanel(this, this.widgets);
                case ETTerminalMode.ANVIL -> new AnvilPanel(this, this.widgets);
            };
            TabButton tabButton = new TabButton(panel.getIcon(), panel.getTabTooltip(), btn -> ((ETTerminalMenu)this.getMenu()).setMode(mode));
            tabButton.setStyle(TabButton.Style.HORIZONTAL);
            if (!mode.canLoad()) continue;
            this.widgets.add(panel.getWidgetId(), (ICompositeWidget)panel);
            this.widgets.add(panel.getModeTabButtonId(), (AbstractWidget)tabButton);
            this.modeTabButtons.put(mode, tabButton);
            this.modePanels.put(mode, panel);
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        for (ETTerminalMode mode : ETTerminalMode.loadableValues()) {
            boolean selected = ((ETTerminalMenu)this.menu).getMode() == mode;
            this.modeTabButtons.get((Object)mode).setSelected(selected);
            this.modePanels.get((Object)mode).setVisible(selected);
        }
    }
}

