/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.client.screen.extendedterminal.gui.panels;

import appeng.client.Point;
import appeng.client.gui.Tooltip;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.Scrollbar;
import java.util.List;
import java.util.Objects;
import me.myogoo.extendedterminal.client.screen.extendedterminal.ETTerminalScreen;
import me.myogoo.extendedterminal.client.screen.extendedterminal.gui.ETTerminalModePanel;
import me.myogoo.extendedterminal.menu.ETSlotSemantics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class StoneCutterPanel
extends ETTerminalModePanel {
    private static final Blitter BG = Blitter.texture((String)"guis/et_terminal_panel.png", (int)512, (int)512).src(0, 134, 159, 65);
    private static final Blitter AE_BG = Blitter.texture((String)"guis/pattern_modes.png").src(0, 140, 124, 66);
    private static final Blitter BG_SLOT = AE_BG.copy().src(124, 140, 20, 22);
    private static final Blitter BG_SLOT_SELECTED = AE_BG.copy().src(124, 162, 20, 22);
    private static final Blitter BG_SLOT_HOVER = AE_BG.copy().src(124, 184, 20, 22);
    private final Scrollbar scrollbar;
    private static final int COLS = 4;
    private static final int ROWS = 2;

    public StoneCutterPanel(ETTerminalScreen screen, WidgetContainer widgets) {
        super(screen, widgets);
        this.scrollbar = widgets.addScrollBar("stonecuttingPatternModeScrollbar", Scrollbar.SMALL);
        this.scrollbar.setRange(0, 0, 4);
        this.scrollbar.setCaptureMouseWheel(false);
        this.setVisible(false);
    }

    public void updateBeforeRender() {
        this.menu.updateStonecutterRecipes();
        int totalRows = (this.menu.getStoneCutterRecipes().size() + 4 - 1) / 4;
        this.scrollbar.setRange(0, totalRows - 2, 2);
    }

    @Override
    public ItemStack getIcon() {
        return Blocks.STONECUTTER.asItem().getDefaultInstance();
    }

    public boolean onMouseWheel(Point mousePos, double delta) {
        return this.scrollbar.onMouseWheel(mousePos, delta);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.screen.setSlotsHidden(ETSlotSemantics.STONECUTTING_INPUT, !visible);
        this.screen.setSlotsHidden(ETSlotSemantics.STONECUTTING_RESULT, !visible);
        this.scrollbar.setVisible(visible);
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        BG.dest(bounds.getX() + 8, bounds.getY() + bounds.getHeight() - 165).blit(guiGraphics);
        this.drawRecipes(guiGraphics, bounds, mouse);
    }

    private RegistryAccess getRegistryAccess() {
        return Objects.requireNonNull(Minecraft.getInstance().level).registryAccess();
    }

    private void drawRecipes(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        List<RecipeHolder<StonecutterRecipe>> recipes = this.menu.getStoneCutterRecipes();
        int startIndex = this.scrollbar.getCurrentScroll() * 4;
        int endIndex = startIndex + 8;
        ResourceLocation selectedRecipe = this.menu.getStoneCutterRecipeId();
        for (int i = startIndex; i < endIndex && i < recipes.size(); ++i) {
            Rect2i slotBounds = this.getRecipeBounds(i - startIndex);
            RecipeHolder<StonecutterRecipe> recipe = recipes.get(i);
            boolean selected = selectedRecipe != null && selectedRecipe.equals((Object)recipe.id());
            Blitter blitter = BG_SLOT;
            if (selected) {
                blitter = BG_SLOT_SELECTED;
            } else if (mouse.isIn(slotBounds)) {
                blitter = BG_SLOT_HOVER;
            }
            int renderX = bounds.getX() + slotBounds.getX();
            int renderY = bounds.getY() + slotBounds.getY();
            blitter.dest(renderX, renderY).blit(guiGraphics);
            ItemStack resultItem = ((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.getRegistryAccess());
            if (selected || mouse.isIn(slotBounds)) {
                guiGraphics.renderItem(resultItem, renderX + 2, renderY + 3);
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, resultItem, renderX + 2, renderY + 3);
                continue;
            }
            guiGraphics.renderItem(resultItem, renderX + 2, renderY + 2);
            guiGraphics.renderItemDecorations(Minecraft.getInstance().font, resultItem, renderX + 2, renderY + 2);
        }
    }

    public boolean onMouseDown(Point mousePos, int button) {
        RecipeHolder<StonecutterRecipe> recipe = this.getRecipeAt(mousePos);
        if (recipe != null) {
            this.menu.setStoneCutterRecipeId(recipe.id());
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
            return true;
        }
        return false;
    }

    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        RecipeHolder<StonecutterRecipe> recipe = this.getRecipeAt(new Point(mouseX, mouseY));
        if (recipe != null) {
            List lines = this.screen.getTooltipFromContainerItem(((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.getRegistryAccess()));
            return new Tooltip(lines);
        }
        return null;
    }

    @Nullable
    private RecipeHolder<StonecutterRecipe> getRecipeAt(Point point) {
        List<RecipeHolder<StonecutterRecipe>> recipes = this.menu.getStoneCutterRecipes();
        if (!recipes.isEmpty()) {
            int startIndex = this.scrollbar.getCurrentScroll() * 4;
            int endIndex = startIndex + 8;
            for (int i = startIndex; i < endIndex && i < recipes.size(); ++i) {
                Rect2i slotBounds = this.getRecipeBounds(i - startIndex);
                if (!point.isIn(slotBounds)) continue;
                return recipes.get(i);
            }
        }
        return null;
    }

    private Rect2i getRecipeBounds(int index) {
        int col = index % 4;
        int row = index / 4;
        int slotX = this.x + 26 + col * BG_SLOT.getSrcWidth();
        int slotY = this.y + 12 + row * BG_SLOT.getSrcHeight();
        return new Rect2i(slotX, slotY, BG_SLOT.getSrcWidth(), BG_SLOT.getSrcHeight());
    }
}

