/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import me.myogoo.extendedterminal.ExtendedTerminal;
import me.myogoo.extendedterminal.api.SubscribeLoadEvent;
import me.myogoo.extendedterminal.util.SafeClass;
import me.myogoo.extendedterminal.util.mod.AnnotationScanner;
import me.myogoo.extendedterminal.util.mod.ModIntegrationManager;
import org.objectweb.asm.Type;

public class ItemListModLoadHelper {
    public static <R> void invokeItemListMod(Type markerAnnotation, Class<R> parameterType, R parameter) {
        AnnotationScanner.getModAnnotations().stream().filter(a -> a.annotationType().equals((Object)markerAnnotation)).map(a -> SafeClass.forType(a.clazz())).filter(c -> c.getDeclaredAnnotations().length == 0 || Arrays.stream(c.getDeclaredAnnotations()).anyMatch(a -> ModIntegrationManager.isLoaded(a.annotationType()))).forEach(clazz -> ItemListModLoadHelper.invokeMethod(clazz, parameterType, parameter));
    }

    public static <R> void invokeItemListMod(Class<?> markerAnnotation, Class<R> parameterType, R parameter) {
        ItemListModLoadHelper.invokeItemListMod(Type.getType(markerAnnotation), parameterType, parameter);
    }

    private static <R> void invokeMethod(Class<?> clazz, Class<R> parameterType, R registration) {
        try {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(SubscribeLoadEvent.class)) continue;
                if (!Modifier.isStatic(method.getModifiers())) {
                    ExtendedTerminal.LOGGER.warn("Method {} in class {} is annotated with @SubscribeLoadEvent but is not static.", (Object)method.getName(), (Object)clazz.getName());
                    continue;
                }
                if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == parameterType) {
                    method.setAccessible(true);
                    method.invoke(null, registration);
                    continue;
                }
                ExtendedTerminal.LOGGER.warn("Method {} in class {} is annotated with @SubscribeLoadEvent but does not have the correct parameters.", (Object)method.getName(), (Object)clazz.getName());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            ExtendedTerminal.LOGGER.error("Failed to register ItemListMod for class: {}", (Object)clazz.getName(), (Object)e);
        }
    }
}

