/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.jei.avaritiaRe.handler;

import appeng.core.localization.ItemModText;
import appeng.menu.me.items.CraftingTermMenu;
import committee.nova.mods.avaritia.api.common.crafting.ITierCraftingRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.myogoo.extendedterminal.api.adapter.recipe.table.IShapedTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.table.ITableRecipeAdapter;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.integration.jei.handler.AbstractTableHolderRecipeHandler;
import me.myogoo.extendedterminal.integration.jei.handler.IAbstractRecipeHandler;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.avaritiaRe.AvaritiaTerminalBaseMenu;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class AVJeiRecipeTransferHandler<T extends AvaritiaTerminalBaseMenu>
extends AbstractTableHolderRecipeHandler<T, ITierCraftingRecipe, RecipeHolder<ITierCraftingRecipe>> {
    private final IRecipeTransferHandlerHelper helper;

    public AVJeiRecipeTransferHandler(Class<T> containerClass, MenuType<T> menuType, RecipeType<RecipeHolder<ITierCraftingRecipe>> recipeType, IRecipeTransferHandlerHelper helper) {
        super(containerClass, menuType, recipeType);
        this.helper = helper;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T menu, RecipeHolder<ITierCraftingRecipe> recipeHolder, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        ITierCraftingRecipe recipe = (ITierCraftingRecipe)recipeHolder.value();
        if (recipe.getIngredients().isEmpty()) {
            return IAbstractRecipeHandler.Result.createInCompatibleError(this.helper);
        }
        if (!recipe.canCraftInDimensions(((ETTerminalBaseMenu)((Object)menu)).getCraftingGridWidth(), ((ETTerminalBaseMenu)((Object)menu)).getCraftingGridHeight())) {
            return IAbstractRecipeHandler.Result.createRecipeToLargeError(this.helper);
        }
        boolean craftMissing = AbstractContainerScreen.hasControlDown();
        List inputSlots = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
        ITableRecipeAdapter adapterRecipe = ITableRecipeAdapter.of(recipe);
        Map<Integer, Ingredient> slotToIngredientMap = this.getGuiSlotToIngredientMap((AvaritiaTerminalBaseMenu)((Object)menu), adapterRecipe);
        CraftingTermMenu.MissingIngredientSlots missingSlots = ((ETTerminalBaseMenu)((Object)menu)).findMissingIngredients(slotToIngredientMap);
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            List<IRecipeSlotView> missingSlotViews = missingSlots.missingSlots().stream().map(idx -> idx < inputSlots.size() ? (IRecipeSlotView)inputSlots.get((int)idx) : null).filter(Objects::nonNull).toList();
            return this.helper.createUserErrorForMissingSlots((Component)ItemModText.NO_ITEMS.text(), missingSlotViews);
        }
        if (!doTransfer) {
            if (missingSlots.totalSize() != 0) {
                int color = missingSlots.anyMissing() ? -2130729728 : -2142943745;
                return new IAbstractRecipeHandler.Result.PartiallyCraftable(missingSlots, color, craftMissing);
            }
        } else {
            this.performTransfer(menu, adapterRecipe, craftMissing, recipeHolder.id());
        }
        return IAbstractRecipeHandler.Result.createSuccessful();
    }

    @Override
    public Map<Integer, Ingredient> getGuiSlotToIngredientMap(AvaritiaTerminalBaseMenu menu, ITableRecipeAdapter recipe) {
        NonNullList<Ingredient> ingredients;
        int gridSideLength = menu.getCraftingGridWidth();
        NonNullList<Ingredient> raw = recipe.recipe().getIngredients();
        int width = gridSideLength;
        int height = gridSideLength;
        if (recipe instanceof IShapedTableRecipeAdapter) {
            IShapedTableRecipeAdapter shapedRecipe = (IShapedTableRecipeAdapter)recipe;
            ingredients = ItemListTermCraftingHelper.ensureFittedCraftingGrid(shapedRecipe);
            width = shapedRecipe.width();
            height = shapedRecipe.height();
        } else {
            ingredients = raw;
        }
        int max = gridSideLength * gridSideLength;
        int count = Math.min(ingredients.size(), max);
        HashMap<Integer, Ingredient> result = new HashMap<Integer, Ingredient>(count);
        for (int i = 0; i < count; ++i) {
            int x = i % width;
            int y = i / width;
            int guiSlot = y * width + x;
            Ingredient ing = (Ingredient)ingredients.get(i);
            if (ing.isEmpty()) continue;
            result.put(guiSlot, ing);
        }
        return result;
    }
}

