/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ITerminalHost;
import appeng.helpers.ICraftingGridMenu;
import appeng.menu.SlotSemantic;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.util.inv.PlayerInternalInventory;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.myogoo.extendedterminal.api.config.IETTerminalConfig;
import me.myogoo.extendedterminal.menu.ETMenuType;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public abstract class ETTerminalBaseMenu<R extends Recipe<?>>
extends MEStorageMenu
implements ICraftingGridMenu {
    protected RecipeHolder<R> currentRecipe;
    private final IETTerminalConfig config;
    protected final ETMenuType menuType;
    private static final String ACTION_CLEAR_TO_PLAYER = "clearToPlayer";

    public ETTerminalBaseMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host, ETMenuType etMenuType, IETTerminalConfig config) {
        super(menuType, id, ip, host);
        this.menuType = etMenuType;
        this.config = config;
        this.registerClientAction(ACTION_CLEAR_TO_PLAYER, ResourceLocation.class, this::clearToPlayerInventory);
    }

    public RecipeHolder<R> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public abstract void clearCraftingGrid();

    public SlotSemantic getCraftingGridSlotSemantic() {
        return this.menuType.getSlotSemanticGrid();
    }

    public SlotSemantic getOutputSlotSemantic() {
        return this.menuType.getSlotSemanticResult();
    }

    public int getCraftingGridSize() {
        return this.menuType.getGridSize();
    }

    public int getCraftingGridWidth() {
        return this.menuType.getGridSideLength();
    }

    public int getCraftingGridHeight() {
        return this.menuType.getGridSideLength();
    }

    protected abstract void updateCurrentRecipeAndOutput(boolean var1);

    public ETMenuType getETMenuType() {
        return this.menuType;
    }

    public void slotsChanged(Container container) {
        this.updateCurrentRecipeAndOutput(false);
    }

    public boolean hasIngredient(Ingredient ingredient, Object2IntOpenHashMap<Object> reservedAmounts) {
        for (Slot slot : this.getSlots(this.getCraftingGridSlotSemantic())) {
            ItemStack stackInSlot = slot.getItem();
            if (stackInSlot.isEmpty() || !ingredient.test(stackInSlot)) continue;
            int reservedAmount = reservedAmounts.getOrDefault((Object)slot, 0);
            if (stackInSlot.getCount() <= reservedAmount) continue;
            reservedAmounts.merge((Object)slot, 1, Integer::sum);
            return true;
        }
        return super.hasIngredient(ingredient, reservedAmounts);
    }

    public void startAutoCrafting(List<ICraftingGridMenu.AutoCraftEntry> toCraft) {
        CraftConfirmMenu.openWithCraftingList((IActionHost)this.getActionHost(), (ServerPlayer)((ServerPlayer)this.getPlayer()), (MenuHostLocator)this.getLocator(), toCraft);
    }

    public IEnergySource getEnergySource() {
        return this.energySource;
    }

    protected boolean isCraftable(ItemStack itemStack) {
        IClientRepo clientRepo = this.getClientRepo();
        if (clientRepo != null) {
            for (GridInventoryEntry stack : clientRepo.getAllEntries()) {
                if (!AEItemKey.matches((AEKey)stack.getWhat(), (ItemStack)itemStack) || !stack.isCraftable()) continue;
                return true;
            }
        }
        return false;
    }

    public CraftingTermMenu.MissingIngredientSlots findMissingIngredients(Map<Integer, Ingredient> ingredients) {
        HashSet<Integer> missingSlots = new HashSet<Integer>();
        HashSet<Integer> craftableSlots = new HashSet<Integer>();
        Object2IntOpenHashMap reservedGridAmounts = new Object2IntOpenHashMap();
        NonNullList playerItems = this.getPlayerInventory().items;
        int[] reservedPlayerItems = new int[playerItems.size()];
        for (Map.Entry<Integer, Ingredient> entry : ingredients.entrySet()) {
            Ingredient ingredient = entry.getValue();
            boolean found = false;
            for (int i = 0; i < playerItems.size(); ++i) {
                ItemStack stack;
                if (this.isPlayerInventorySlotLocked(i) || (stack = (ItemStack)playerItems.get(i)).getCount() - reservedPlayerItems[i] <= 0 || !ingredient.test(stack)) continue;
                int n = i;
                reservedPlayerItems[n] = reservedPlayerItems[n] + 1;
                found = true;
                break;
            }
            if (!found && this.hasIngredient(ingredient, (Object2IntOpenHashMap<Object>)reservedGridAmounts)) {
                reservedGridAmounts.merge((Object)ingredient, 1, Integer::sum);
                found = true;
            }
            if (!found) {
                for (ItemStack stack : ingredient.getItems()) {
                    if (!this.isCraftable(stack)) continue;
                    craftableSlots.add(entry.getKey());
                    found = true;
                    break;
                }
            }
            if (found) continue;
            missingSlots.add(entry.getKey());
        }
        return new CraftingTermMenu.MissingIngredientSlots(missingSlots, craftableSlots);
    }

    public void clearToPlayerInventory() {
        this.clearToPlayerInventory(this.getETMenuType().getCraftingInventory());
    }

    public void clearToPlayerInventory(ResourceLocation invId) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CLEAR_TO_PLAYER, invId);
            return;
        }
        PlayerInternalInventory playerInv = new PlayerInternalInventory(this.getPlayerInventory());
        InternalInventory inv = ((ISegmentedInventory)this.getHost()).getSubInventory(invId);
        for (int i = 0; i < inv.size(); ++i) {
            for (int emptyLoop = 0; emptyLoop < 2; ++emptyLoop) {
                boolean allowEmpty = emptyLoop == 1;
                int HOTBAR_SIZE = 9;
                int j = 9;
                while (j-- > 0) {
                    if (playerInv.getStackInSlot(j).isEmpty() != allowEmpty) continue;
                    inv.setItemDirect(i, playerInv.getSlotInv(j).addItems(inv.getStackInSlot(i)));
                }
                for (j = 9; j < 36; ++j) {
                    if (playerInv.getStackInSlot(j).isEmpty() != allowEmpty) continue;
                    inv.setItemDirect(i, playerInv.getSlotInv(j).addItems(inv.getStackInSlot(i)));
                }
            }
        }
    }

    protected boolean checkCraftingOnlyActive() {
        return this.config.enableCraftOnlyPowered() && (this.getGridNode() == null || this.getGridNode() != null && !this.getGridNode().isActive());
    }
}

