/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.extendedterminal;

import appeng.menu.SlotSemantic;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import me.myogoo.extendedterminal.ExtendedTerminal;
import me.myogoo.extendedterminal.config.ExtendedTerminalConfig;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.ETSlotSemantics;
import me.myogoo.extendedterminal.part.extendedterminal.ETTerminalPart;
import me.myogoo.extendedterminal.util.mod.ModIntegrationManager;
import net.minecraft.resources.ResourceLocation;

public enum ETTerminalMode {
    CRAFTING(ExtendedTerminalConfig.INSTANCE.getExtendedTerminalConfig().enableCraftingPanel()),
    STONECUTTING(ExtendedTerminalConfig.INSTANCE.getExtendedTerminalConfig().enableStonecutterPanel()),
    SMITHING(ExtendedTerminalConfig.INSTANCE.getExtendedTerminalConfig().enableSmithingPanel()),
    ANVIL(ExtendedTerminalConfig.INSTANCE.getExtendedTerminalConfig().enableAnvilPanel());

    private final boolean enabled;

    private ETTerminalMode(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean canLoad() {
        try {
            Field field = ETTerminalMode.class.getField(this.name());
            if (field.getDeclaredAnnotations().length == 0) {
                return this.enabled;
            }
            return Arrays.stream(field.getDeclaredAnnotations()).map(Annotation::annotationType).allMatch(ModIntegrationManager::isLoaded) && this.enabled;
        }
        catch (NoSuchFieldException e) {
            ExtendedTerminal.LOGGER.error("Terminal Mode {} is not loaded due to missing field in ETTerminalMode", (Object)this.name());
            return false;
        }
    }

    public ResourceLocation getInventoryId() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ETMenuType.ET_TERMINAL.getCraftingInventory();
            case 1 -> ETTerminalPart.StoneCutterInventory;
            case 2 -> ETTerminalPart.SmithingInventory;
            case 3 -> ETTerminalPart.AnvilInventory;
        };
    }

    public List<SlotSemantic> getSlotSemantics() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> List.of(ETMenuType.ET_TERMINAL.getSlotSemanticGrid());
            case 1 -> List.of(ETSlotSemantics.STONECUTTING_INPUT);
            case 2 -> List.of(ETSlotSemantics.SMITHING_TABLE_BASE, ETSlotSemantics.SMITHING_TABLE_TEMPLATE, ETSlotSemantics.SMITHING_TABLE_ADDITION);
            case 3 -> List.of(ETSlotSemantics.ANVIL_LEFT_INPUT, ETSlotSemantics.ANVIL_RIGHT_INPUT);
        };
    }

    public static List<ETTerminalMode> loadableValues() {
        List<ETTerminalMode> list = Arrays.stream(ETTerminalMode.values()).filter(ETTerminalMode::canLoad).toList();
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No ETTerminalModes are loadable!");
        }
        return list;
    }
}

