/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.part;

import appeng.api.inventories.InternalInventory;
import appeng.api.parts.IPartItem;
import appeng.parts.reporting.AbstractTerminalPart;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import java.util.List;
import me.myogoo.extendedterminal.menu.ETMenuType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class ETTerminalBasePart
extends AbstractTerminalPart {
    public static final ResourceLocation MODEL_OFF = CraftingTerminalPart.MODEL_OFF;
    public static final ResourceLocation MODEL_ON = CraftingTerminalPart.MODEL_ON;
    private final AppEngInternalInventory craftingGrid;
    private final ETMenuType menuType;

    public ETTerminalBasePart(IPartItem<?> partItem, ETMenuType menuType) {
        super(partItem);
        this.menuType = menuType;
        this.craftingGrid = new AppEngInternalInventory((InternalInventoryHost)this, menuType.getGridSize());
    }

    public void clearContent() {
        super.clearContent();
        this.craftingGrid.clear();
    }

    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)this.menuType.getCraftingInventory())) {
            return this.craftingGrid;
        }
        return super.getSubInventory(id);
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.craftingGrid.readFromNBT(data, "craftingGrid", registries);
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        this.craftingGrid.writeToNBT(data, "craftingGrid", registries);
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        for (ItemStack is : this.craftingGrid) {
            if (is.isEmpty()) continue;
            drops.add(is);
        }
    }
}

