/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.claim;

import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public record ClaimBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
    public boolean insideClaim(BlockPos pos) {
        return this.minX <= pos.getX() && this.maxX >= pos.getX() && this.minZ <= pos.getZ() && this.maxZ >= pos.getZ() && this.minY <= pos.getY() && this.maxY >= pos.getY();
    }

    public boolean intersects(ClaimBox other) {
        return this.intersects(other.minX, other.minY, other.minZ, other.maxX, other.maxY, other.maxZ);
    }

    public boolean intersects(AABB other) {
        return this.intersects(other.minX - 1.0, other.minY, other.minZ - 1.0, other.maxX, other.maxY, other.maxZ);
    }

    public boolean intersects(double x, double y, double z, double X, double Y, double Z) {
        return (double)this.minX < X && (double)this.maxX > x && (double)this.minY < Y && (double)this.maxY > y && (double)this.minZ < Z && (double)this.maxZ > z;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        int x1;
        int n;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClaimBox)) return false;
        ClaimBox claimBox = (ClaimBox)obj;
        try {
            x1 = n = claimBox.minX();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        int y1 = n = claimBox.minY();
        int z1 = n = claimBox.minZ();
        int x2 = n = claimBox.maxX();
        int y2 = n = claimBox.maxY();
        int z2 = n = claimBox.maxZ();
        if (this.minX != x1) return false;
        if (this.minY != y1) return false;
        if (this.minZ != z1) return false;
        if (this.maxX != x2) return false;
        if (this.maxY != y2) return false;
        if (this.maxZ != z2) return false;
        return true;
    }

    public boolean contains(ClaimBox other) {
        return this.minX <= other.minX && this.maxX >= other.maxX && this.minY <= other.minY && this.maxY >= other.maxY && this.minZ <= other.minZ && this.maxZ >= other.maxZ;
    }
}

