/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class AddClaimCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.claim.create"))).then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).executes(AddClaimCommand::addClaim)).then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)ResourceLocationArgument.id()).requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.claim.admin.create", true))).suggests((src, build) -> SharedSuggestionProvider.suggest(((CommandSourceStack)src.getSource()).getServer().levelKeys().stream().map(k -> k.location().toString()).toList(), (SuggestionsBuilder)build)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((src, build) -> SharedSuggestionProvider.suggest(Stream.concat(Stream.of("+Admin"), ((CommandSourceStack)src.getSource()).getServer().getPlayerList().getPlayers().stream().map(p -> p.getUUID().toString())).toList(), (SuggestionsBuilder)build)).executes(AddClaimCommand::addClaimAs)))))).then(Commands.literal((String)"all").executes(AddClaimCommand::addClaimAll))).then(Commands.literal((String)"rect").then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> AddClaimCommand.addClaimRect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"z")))))));
    }

    private static int addClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (!ItemInteractEvents.canClaimWorld(((CommandSourceStack)context.getSource()).getLevel(), player)) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(((CommandSourceStack)context.getSource()).getLevel());
        BlockPos from = BlockPosArgument.getLoadedBlockPos(context, (String)"from");
        BlockPos to = BlockPosArgument.getLoadedBlockPos(context, (String)"to");
        storage.createClaim(from, to, player);
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private static int addClaimAs(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        as = StringArgumentType.getString(context, (String)"player");
        levelID = ResourceLocationArgument.getId(context, (String)"dimension");
        level = ((CommandSourceStack)context.getSource()).getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)levelID));
        if (level == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess((Supplier<Component>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addClaimAs$7(net.minecraft.resources.ResourceLocation ), ()Lnet/minecraft/network/chat/Component;)((ResourceLocation)levelID), true);
            return 0;
        }
        uuid = null;
        if (!as.equals("+Admin") && (uuid = (UUID)((CommandSourceStack)context.getSource()).getServer().getProfileCache().get(as).map((Function<GameProfile, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/mojang/authlib/GameProfile;)Ljava/util/UUID;)()).orElse(null)) == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess((Supplier<Component>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addClaimAs$8(java.lang.String ), ()Lnet/minecraft/network/chat/Component;)((String)as), true);
            return 0;
        }
        storage = ClaimStorage.get(level);
        from = BlockPosArgument.getLoadedBlockPos(context, (String)"from");
        to = BlockPosArgument.getLoadedBlockPos(context, (String)"to");
        var10_8 = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(var10_8 instanceof ServerPlayer)) ** GOTO lbl-1000
        player = (ServerPlayer)var10_8;
        if (PlayerClaimData.get((ServerPlayer)player).getClaimMode().is3d) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        claim = storage.createAdminClaim(from, to, level, v0);
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess((Supplier<Component>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addClaimAs$9(), ()Lnet/minecraft/network/chat/Component;)(), true);
            return 0;
        }
        if (uuid != null) {
            storage.transferOwner(claim, uuid);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess((Supplier<Component>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addClaimAs$10(), ()Lnet/minecraft/network/chat/Component;)(), false);
        return 1;
    }

    private static int addClaimAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        int usable = data.getClaimBlocks() + data.getAdditionalClaims() - data.usedClaimBlocks();
        int size = (int)Math.floor(Math.sqrt(usable));
        return AddClaimCommand.addClaimRect(context, size, size);
    }

    private static int addClaimRect(CommandContext<CommandSourceStack> context, int x, int z) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (!ItemInteractEvents.canClaimWorld(((CommandSourceStack)context.getSource()).getLevel(), player)) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(((CommandSourceStack)context.getSource()).getLevel());
        boolean evenX = x % 2 == 0;
        boolean evenZ = z % 2 == 0;
        BlockPos from = player.blockPosition().offset(evenX ? -((int)((double)(x - 1) * 0.5)) : -((int)((double)x * 0.5)), -5, evenZ ? -((int)((double)(z - 1) * 0.5)) : -((int)((double)z * 0.5)));
        BlockPos to = player.blockPosition().offset((int)((double)x * 0.5), -5, (int)((double)z * 0.5));
        storage.createClaim(from, to, player);
        return 1;
    }

    private static /* synthetic */ Component lambda$addClaimAs$10() {
        return ClaimUtils.translatedText("flan.claimCreateSuccess", ChatFormatting.GOLD);
    }

    private static /* synthetic */ Component lambda$addClaimAs$9() {
        return ClaimUtils.translatedText("flan.claimCreationFailCommand", new Object[0]);
    }

    private static /* synthetic */ Component lambda$addClaimAs$8(String as) {
        return ClaimUtils.translatedText("flan.noSuchPlayer", as);
    }

    private static /* synthetic */ Component lambda$addClaimAs$7(ResourceLocation levelID) {
        return ClaimUtils.translatedText("flan.noSuchLevel", levelID);
    }
}

