/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.server.level.ServerPlayer;

public class ConfirmCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(Commands.literal((String)"confirm").then(Commands.argument((String)"confirm", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(List.of("confirm", "deny"), (SuggestionsBuilder)sb)).executes(ConfirmCommand::confirmCommand)));
    }

    private static int confirmCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        String confirm = StringArgumentType.getString(context, (String)"confirm");
        if (!confirm.equals("confirm") && !confirm.equals("deny")) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand.args", ChatFormatting.RED), false);
            return 0;
        }
        int res = data.runPendingCommand(confirm.equals("confirm"));
        if (res == -1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand.none", ChatFormatting.RED), false);
            return 0;
        }
        return res;
    }
}

