/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.config.BuySellHandler;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.config.ConfigUpdater;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class Config {
    private final File config;
    public int startingBlocks = 500;
    public int maxClaimBlocks = 5000;
    public int ticksForNextBlock = 600;
    public int minClaimsize = 100;
    public int defaultClaimDepth = 10;
    public boolean subClaimsInheritParentDepth = true;
    public int maxClaims = -1;
    public String defaultClaimName = "";
    public String defaultEnterMessage = "";
    public String defaultLeaveMessage = "";
    public boolean noSpawnClaim;
    public int claimingCooldown;
    public String[] blacklistedWorlds = new String[0];
    public boolean worldWhitelist;
    public Item claimingItem = Items.GOLDEN_HOE;
    public CompoundTag claimingNBT = new CompoundTag();
    public Item inspectionItem = Items.STICK;
    public CompoundTag inspectionNBT = new CompoundTag();
    public boolean main3dClaims = true;
    public int minHeight3d = 10;
    public int nearbyClaimsToolDisplay = 24;
    public int claimDisplayTime = 600;
    public boolean particleDisplay = false;
    public boolean claimDisplayActionBar = false;
    public int permissionLevel = 2;
    public boolean autoClaimStructures;
    public boolean ftbChunksCheck = true;
    public boolean gomlReservedCheck = true;
    public boolean mineColoniesCheck = true;
    public BuySellHandler buySellHandler = new BuySellHandler();
    public int maxBuyBlocks = -1;
    public boolean lenientBlockEntityCheck;
    public List<String> breakBlockBlacklist = Lists.newArrayList((Object[])new String[]{"universal_graves:grave", "yigd:grave"});
    public List<String> interactBlockBlacklist = Lists.newArrayList((Object[])new String[]{"universal_graves:grave", "yigd:grave", "waystones", "universal_shops:trade_block"});
    public List<String> breakBlockEntityTagBlacklist = Lists.newArrayList();
    public List<String> interactBlockEntityTagBlacklist = Lists.newArrayList((Object[])new String[]{"IsDeathChest", "gunpowder.owner", "shop-activated"});
    public List<String> ignoredEntityTypes = Lists.newArrayList((Object[])new String[]{"corpse:corpse"});
    public List<String> entityTagIgnore = Lists.newArrayList((Object[])new String[]{"graves.marker"});
    private List<String> legacyOverrides = Lists.newArrayList((Object[])new String[]{"@c:wrenches-flan:interact_block", "appliedenergistics2:nether_quartz_wrench-flan:interact_block", "appliedenergistics2:certus_quartz_wrench-flan:interact_block"});
    public int dropTicks = 6000;
    public int inactivityTime = -1;
    public int inactivityBlocksMax = 2000;
    public boolean deletePlayerFile = false;
    public int bannedDeletionTime = 30;
    public int offlineProtectActivation = -1;
    public boolean dynmapIntegration;
    public boolean bluemapIntegration;
    public boolean log;
    public int configVersion = 7;
    public int preConfigVersion;
    public Map<String, Map<ResourceLocation, Boolean>> defaultGroups = Config.createHashMap(map -> {
        map.put("Co-Owner", Config.createHashMap(perms -> PermissionManager.getInstance().getAll().forEach(p -> perms.put(p.getId(), true))));
        map.put("Visitor", Config.createHashMap(perms -> {
            perms.put(BuiltinPermission.BED, true);
            perms.put(BuiltinPermission.DOOR, true);
            perms.put(BuiltinPermission.FENCEGATE, true);
            perms.put(BuiltinPermission.TRAPDOOR, true);
            perms.put(BuiltinPermission.BUTTONLEVER, true);
            perms.put(BuiltinPermission.PRESSUREPLATE, true);
            perms.put(BuiltinPermission.ENDERCHEST, true);
            perms.put(BuiltinPermission.ENCHANTMENTTABLE, true);
            perms.put(BuiltinPermission.ITEMFRAMEROTATE, true);
            perms.put(BuiltinPermission.PORTAL, true);
            perms.put(BuiltinPermission.TRADING, true);
        }));
    });
    protected final Map<String, Map<ResourceLocation, GlobalType>> globalDefaultPerms = Config.createHashMap(map -> map.put("*", Config.createHashMap(perms -> {
        perms.put(BuiltinPermission.ALLOW_FLIGHT, GlobalType.ALLTRUE);
        perms.put(BuiltinPermission.MAY_FLIGHT, GlobalType.ALLFALSE);
        perms.put(BuiltinPermission.MOBSPAWN, GlobalType.ALLFALSE);
        perms.put(BuiltinPermission.TELEPORT, GlobalType.ALLFALSE);
        perms.put(BuiltinPermission.NOHUNGER, GlobalType.ALLFALSE);
        perms.put(BuiltinPermission.EDITPOTIONS, GlobalType.ALLFALSE);
        perms.put(BuiltinPermission.LOCKITEMS, GlobalType.ALLTRUE);
    })));

    public Config() {
        File configDir = CrossPlatformStuff.INSTANCE.configPath().resolve("flan").toFile();
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        this.config = new File(configDir, "flan_config.json");
    }

    public void load(MinecraftServer server) {
        if (!this.config.exists()) {
            try {
                this.config.createNewFile();
            }
            catch (IOException e2) {
                Flan.LOGGER.error((Object)e2);
            }
            this.save(server);
        }
        try {
            FileReader reader = new FileReader(this.config);
            JsonObject obj = (JsonObject)ConfigHandler.GSON.fromJson((Reader)reader, JsonObject.class);
            reader.close();
            this.preConfigVersion = ConfigHandler.fromJson(obj, "configVersion", 0);
            obj = ConfigUpdater.updateConfig(this.preConfigVersion, obj);
            this.startingBlocks = ConfigHandler.fromJson(obj, "startingBlocks", this.startingBlocks);
            this.maxClaimBlocks = ConfigHandler.fromJson(obj, "maxClaimBlocks", this.maxClaimBlocks);
            this.ticksForNextBlock = ConfigHandler.fromJson(obj, "ticksForNextBlock", this.ticksForNextBlock);
            this.minClaimsize = ConfigHandler.fromJson(obj, "minClaimsize", this.minClaimsize);
            this.defaultClaimDepth = ConfigHandler.fromJson(obj, "defaultClaimDepth", this.defaultClaimDepth);
            this.subClaimsInheritParentDepth = ConfigHandler.fromJson(obj, "subClaimsInheritParentDepth", this.subClaimsInheritParentDepth);
            this.maxClaims = ConfigHandler.fromJson(obj, "maxClaims", this.maxClaims);
            this.defaultClaimName = ConfigHandler.fromJson(obj, "defaultClaimName", this.defaultClaimName);
            this.defaultEnterMessage = ConfigHandler.fromJson(obj, "defaultEnterMessage", this.defaultEnterMessage);
            this.defaultLeaveMessage = ConfigHandler.fromJson(obj, "defaultLeaveMessage", this.defaultLeaveMessage);
            this.noSpawnClaim = ConfigHandler.fromJson(obj, "noSpawnClaim", this.noSpawnClaim);
            this.claimingCooldown = ConfigHandler.fromJson(obj, "claimingCooldown", this.claimingCooldown);
            JsonArray arr = ConfigHandler.arrayFromJson(obj, "blacklistedWorlds");
            this.blacklistedWorlds = new String[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                this.blacklistedWorlds[i] = arr.get(i).getAsString();
            }
            this.worldWhitelist = ConfigHandler.fromJson(obj, "worldWhitelist", this.worldWhitelist);
            if (obj.has("claimingItem")) {
                this.claimingItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)obj.get("claimingItem").getAsString()));
            }
            this.claimingNBT = (CompoundTag)CompoundTag.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.getAsJsonObject((JsonObject)obj, (String)"claimingNBT", (JsonObject)new JsonObject())).getOrThrow();
            if (obj.has("inspectionItem")) {
                this.inspectionItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)obj.get("inspectionItem").getAsString()));
            }
            this.inspectionNBT = (CompoundTag)CompoundTag.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.getAsJsonObject((JsonObject)obj, (String)"inspectionNBT", (JsonObject)new JsonObject())).getOrThrow();
            this.main3dClaims = ConfigHandler.fromJson(obj, "main3dClaims", this.main3dClaims);
            this.minHeight3d = ConfigHandler.fromJson(obj, "minHeight3d", this.minHeight3d);
            this.nearbyClaimsToolDisplay = ConfigHandler.fromJson(obj, "nearbyClaimsToolDisplay", this.nearbyClaimsToolDisplay);
            this.claimDisplayTime = ConfigHandler.fromJson(obj, "claimDisplayTime", this.claimDisplayTime);
            this.particleDisplay = ConfigHandler.fromJson(obj, "particleDisplay", this.particleDisplay);
            this.claimDisplayActionBar = ConfigHandler.fromJson(obj, "claimDisplayActionBar", this.claimDisplayActionBar);
            this.permissionLevel = ConfigHandler.fromJson(obj, "permissionLevel", this.permissionLevel);
            this.autoClaimStructures = ConfigHandler.fromJson(obj, "autoClaimStructures", this.autoClaimStructures);
            this.ftbChunksCheck = ConfigHandler.fromJson(obj, "ftbChunksCheck", this.ftbChunksCheck);
            this.gomlReservedCheck = ConfigHandler.fromJson(obj, "gomlReservedCheck", this.gomlReservedCheck);
            this.mineColoniesCheck = ConfigHandler.fromJson(obj, "mineColoniesCheck", this.mineColoniesCheck);
            this.buySellHandler.fromJson(ConfigHandler.fromJson(obj, "buySellHandler"), server);
            this.maxBuyBlocks = ConfigHandler.fromJson(obj, "maxBuyBlocks", this.maxBuyBlocks);
            this.lenientBlockEntityCheck = ConfigHandler.fromJson(obj, "lenientBlockEntityCheck", this.lenientBlockEntityCheck);
            this.breakBlockBlacklist.clear();
            ConfigHandler.arrayFromJson(obj, "breakBlockBlacklist").forEach(e -> this.breakBlockBlacklist.add(e.getAsString()));
            this.interactBlockBlacklist.clear();
            ConfigHandler.arrayFromJson(obj, "interactBlockBlacklist").forEach(e -> this.interactBlockBlacklist.add(e.getAsString()));
            this.breakBlockEntityTagBlacklist.clear();
            ConfigHandler.arrayFromJson(obj, "breakBlockEntityTagBlacklist").forEach(e -> this.breakBlockEntityTagBlacklist.add(e.getAsString()));
            this.interactBlockEntityTagBlacklist.clear();
            ConfigHandler.arrayFromJson(obj, "interactBlockEntityTagBlacklist").forEach(e -> this.interactBlockEntityTagBlacklist.add(e.getAsString()));
            this.ignoredEntityTypes.clear();
            ConfigHandler.arrayFromJson(obj, "ignoredEntities").forEach(e -> this.ignoredEntityTypes.add(e.getAsString()));
            this.entityTagIgnore.clear();
            ConfigHandler.arrayFromJson(obj, "entityTagIgnore").forEach(e -> this.entityTagIgnore.add(e.getAsString()));
            this.legacyOverrides.clear();
            ConfigHandler.arrayFromJson(obj, "legacyOverrides").forEach(e -> this.legacyOverrides.add(e.getAsString()));
            ConfigHandler.arrayFromJson(obj, "customItemPermission").forEach(e -> this.legacyOverrides.add(e.getAsString()));
            ConfigHandler.arrayFromJson(obj, "customBlockPermission").forEach(e -> this.legacyOverrides.add(e.getAsString()));
            ConfigHandler.arrayFromJson(obj, "customEntityPermission").forEach(e -> this.legacyOverrides.add(e.getAsString()));
            ConfigHandler.arrayFromJson(obj, "leftClickBlockPermission").forEach(e -> this.legacyOverrides.add(e.getAsString()));
            this.dropTicks = ConfigHandler.fromJson(obj, "dropTicks", this.dropTicks);
            this.inactivityTime = ConfigHandler.fromJson(obj, "inactivityTimeDays", this.inactivityTime);
            this.inactivityBlocksMax = ConfigHandler.fromJson(obj, "inactivityBlocksMax", this.inactivityBlocksMax);
            this.deletePlayerFile = ConfigHandler.fromJson(obj, "deletePlayerFile", this.deletePlayerFile);
            this.bannedDeletionTime = ConfigHandler.fromJson(obj, "bannedDeletionTime", this.bannedDeletionTime);
            this.offlineProtectActivation = ConfigHandler.fromJson(obj, "offlineProtectActivation", this.offlineProtectActivation);
            this.dynmapIntegration = ConfigHandler.fromJson(obj, "dynmapIntegration", this.dynmapIntegration);
            this.bluemapIntegration = ConfigHandler.fromJson(obj, "bluemapIntegration", this.bluemapIntegration);
            this.log = ConfigHandler.fromJson(obj, "enableLogs", this.log);
            this.defaultGroups.clear();
            JsonObject defP = ConfigHandler.fromJson(obj, "defaultGroups");
            defP.entrySet().forEach(e -> {
                HashMap perms = new HashMap();
                if (((JsonElement)e.getValue()).isJsonObject()) {
                    ((JsonElement)e.getValue()).getAsJsonObject().entrySet().forEach(jperm -> {
                        ResourceLocation id = BuiltinPermission.tryLegacy((String)jperm.getKey());
                        perms.put(id, ((JsonElement)jperm.getValue()).getAsBoolean());
                    });
                }
                this.defaultGroups.put((String)e.getKey(), perms);
            });
            this.globalDefaultPerms.clear();
            JsonObject glob = ConfigHandler.fromJson(obj, "globalDefaultPerms");
            glob.entrySet().forEach(e -> {
                HashMap perms = new HashMap();
                if (((JsonElement)e.getValue()).isJsonObject()) {
                    ((JsonElement)e.getValue()).getAsJsonObject().entrySet().forEach(jperm -> {
                        ResourceLocation id = BuiltinPermission.tryLegacy((String)jperm.getKey());
                        if (((JsonElement)jperm.getValue()).isJsonPrimitive() && ((JsonElement)jperm.getValue()).getAsJsonPrimitive().isBoolean()) {
                            perms.put(id, ((JsonElement)jperm.getValue()).getAsBoolean() ? GlobalType.ALLTRUE : GlobalType.ALLFALSE);
                        } else {
                            perms.put(id, GlobalType.valueOf(((JsonElement)jperm.getValue()).getAsString()));
                        }
                    });
                }
                this.globalDefaultPerms.put((String)e.getKey(), perms);
            });
            ConfigUpdater.postUpdateConfig(this.preConfigVersion, this);
        }
        catch (IOException e3) {
            Flan.LOGGER.error((Object)e3);
        }
        this.save(server);
    }

    private void save(MinecraftServer server) {
        JsonObject obj = new JsonObject();
        obj.addProperty("__comment", "For help with the config refer to https://github.com/Flemmli97/Flan/wiki/Config");
        obj.addProperty("configVersion", (Number)this.configVersion);
        obj.addProperty("startingBlocks", (Number)this.startingBlocks);
        obj.addProperty("maxClaimBlocks", (Number)this.maxClaimBlocks);
        obj.addProperty("ticksForNextBlock", (Number)this.ticksForNextBlock);
        obj.addProperty("minClaimsize", (Number)this.minClaimsize);
        obj.addProperty("defaultClaimDepth", (Number)this.defaultClaimDepth);
        obj.addProperty("subClaimsInheritParentDepth", Boolean.valueOf(this.subClaimsInheritParentDepth));
        obj.addProperty("maxClaims", (Number)this.maxClaims);
        obj.addProperty("defaultClaimName", this.defaultClaimName);
        obj.addProperty("defaultEnterMessage", this.defaultEnterMessage);
        obj.addProperty("defaultLeaveMessage", this.defaultLeaveMessage);
        obj.addProperty("noSpawnClaim", Boolean.valueOf(this.noSpawnClaim));
        obj.addProperty("claimingCooldown", (Number)this.claimingCooldown);
        JsonArray arr = new JsonArray();
        for (String blacklistedWorld : this.blacklistedWorlds) {
            arr.add(blacklistedWorld);
        }
        obj.add("blacklistedWorlds", (JsonElement)arr);
        obj.addProperty("worldWhitelist", Boolean.valueOf(this.worldWhitelist));
        obj.addProperty("claimingItem", BuiltInRegistries.ITEM.getKey((Object)this.claimingItem).toString());
        obj.add("claimingNBT", (JsonElement)CompoundTag.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.claimingNBT).getOrThrow());
        obj.addProperty("inspectionItem", BuiltInRegistries.ITEM.getKey((Object)this.inspectionItem).toString());
        obj.add("inspectionNBT", (JsonElement)CompoundTag.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.inspectionNBT).getOrThrow());
        obj.addProperty("main3dClaims", Boolean.valueOf(this.main3dClaims));
        obj.addProperty("minHeight3d", (Number)this.minHeight3d);
        obj.addProperty("nearbyClaimsToolDisplay", (Number)this.nearbyClaimsToolDisplay);
        obj.addProperty("claimDisplayTime", (Number)this.claimDisplayTime);
        obj.addProperty("particleDisplay", Boolean.valueOf(this.particleDisplay));
        obj.addProperty("claimDisplayActionBar", Boolean.valueOf(this.claimDisplayActionBar));
        obj.addProperty("permissionLevel", (Number)this.permissionLevel);
        obj.addProperty("autoClaimStructures", Boolean.valueOf(this.autoClaimStructures));
        obj.addProperty("ftbChunksCheck", Boolean.valueOf(this.ftbChunksCheck));
        obj.addProperty("gomlReservedCheck", Boolean.valueOf(this.gomlReservedCheck));
        obj.addProperty("mineColoniesCheck", Boolean.valueOf(this.mineColoniesCheck));
        obj.add("buySellHandler", (JsonElement)this.buySellHandler.toJson(server));
        obj.addProperty("maxBuyBlocks", (Number)this.maxBuyBlocks);
        obj.addProperty("lenientBlockEntityCheck", Boolean.valueOf(this.lenientBlockEntityCheck));
        JsonArray blocksBreak = new JsonArray();
        this.breakBlockBlacklist.forEach(arg_0 -> ((JsonArray)blocksBreak).add(arg_0));
        obj.add("breakBlockBlacklist", (JsonElement)blocksBreak);
        JsonArray blocksInteract = new JsonArray();
        this.interactBlockBlacklist.forEach(arg_0 -> ((JsonArray)blocksInteract).add(arg_0));
        obj.add("interactBlockBlacklist", (JsonElement)blocksInteract);
        JsonArray blocksEntities = new JsonArray();
        this.breakBlockEntityTagBlacklist.forEach(arg_0 -> ((JsonArray)blocksEntities).add(arg_0));
        obj.add("breakBlockEntityTagBlacklist", (JsonElement)blocksEntities);
        JsonArray blocksEntitiesInteract = new JsonArray();
        this.interactBlockEntityTagBlacklist.forEach(arg_0 -> ((JsonArray)blocksEntitiesInteract).add(arg_0));
        obj.add("interactBlockEntityTagBlacklist", (JsonElement)blocksEntitiesInteract);
        JsonArray entities = new JsonArray();
        this.ignoredEntityTypes.forEach(arg_0 -> ((JsonArray)entities).add(arg_0));
        obj.add("ignoredEntities", (JsonElement)entities);
        JsonArray entitiesTags = new JsonArray();
        this.entityTagIgnore.forEach(arg_0 -> ((JsonArray)entitiesTags).add(arg_0));
        obj.add("entityTagIgnore", (JsonElement)entitiesTags);
        JsonArray overrides = new JsonArray();
        this.legacyOverrides.forEach(arg_0 -> ((JsonArray)overrides).add(arg_0));
        obj.add("legacyOverrides", (JsonElement)overrides);
        obj.addProperty("dropTicks", (Number)this.dropTicks);
        obj.addProperty("inactivityTimeDays", (Number)this.inactivityTime);
        obj.addProperty("inactivityBlocksMax", (Number)this.inactivityBlocksMax);
        obj.addProperty("deletePlayerFile", Boolean.valueOf(this.deletePlayerFile));
        obj.addProperty("bannedDeletionTime", (Number)this.bannedDeletionTime);
        obj.addProperty("offlineProtectActivation", (Number)this.offlineProtectActivation);
        obj.addProperty("dynmapIntegration", Boolean.valueOf(this.dynmapIntegration));
        obj.addProperty("bluemapIntegration", Boolean.valueOf(this.bluemapIntegration));
        obj.addProperty("enableLogs", Boolean.valueOf(this.log));
        JsonObject defPerm = new JsonObject();
        this.defaultGroups.forEach((key, value) -> {
            JsonObject perm = new JsonObject();
            value.forEach((key1, value1) -> perm.addProperty(key1.toString(), value1));
            defPerm.add(key, (JsonElement)perm);
        });
        obj.add("defaultGroups", (JsonElement)defPerm);
        JsonObject global = new JsonObject();
        this.globalDefaultPerms.forEach((key, value) -> {
            JsonObject perm = new JsonObject();
            TreeMap<ResourceLocation, Object> map = new TreeMap<ResourceLocation, Object>(ClaimPermission.NAMESPACE_FIRST);
            map.putAll((Map<ResourceLocation, Object>)value);
            map.forEach((key1, value1) -> perm.addProperty(key1.toString(), value1.toString()));
            global.add(key, (JsonElement)perm);
        });
        obj.add("globalDefaultPerms", (JsonElement)global);
        try {
            FileWriter writer = new FileWriter(this.config);
            ConfigHandler.GSON.toJson((JsonElement)obj, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            Flan.LOGGER.error((Object)e);
        }
    }

    public boolean globallyDefined(ServerLevel level, ResourceLocation perm) {
        return !this.getGlobal(level, perm).canModify();
    }

    public void validatePermissionConfigs() {
        HashSet missing = new HashSet();
        this.defaultGroups.forEach((group, perms) -> perms.keySet().forEach(id -> {
            ClaimPermission perm = PermissionManager.getInstance().get((ResourceLocation)id);
            if (perm == null) {
                missing.add(id);
            }
        }));
        if (!missing.isEmpty()) {
            Flan.error("Default groups: Missing permissions for {}", missing);
        }
        HashSet missing2 = new HashSet();
        this.globalDefaultPerms.forEach((group, perms) -> perms.keySet().forEach(id -> {
            ClaimPermission perm = PermissionManager.getInstance().get((ResourceLocation)id);
            if (perm == null) {
                missing2.add(id);
            }
        }));
        if (!missing2.isEmpty()) {
            Flan.error("Global Perms: Missing permissions for {}", missing2);
        }
    }

    public GlobalType getGlobal(ServerLevel level, ResourceLocation perm) {
        Map<ResourceLocation, GlobalType> permMap;
        Map<ResourceLocation, GlobalType> allMap = ConfigHandler.CONFIG.globalDefaultPerms.get("*");
        if (allMap != null) {
            level.getServer().getAllLevels().forEach(w -> {
                Map wMap = ConfigHandler.CONFIG.globalDefaultPerms.getOrDefault(w.dimension().location().toString(), new HashMap());
                allMap.forEach((key, value) -> {
                    if (!wMap.containsKey(key)) {
                        wMap.put(key, value);
                    }
                });
                ConfigHandler.CONFIG.globalDefaultPerms.put(w.dimension().location().toString(), wMap);
            });
            ConfigHandler.CONFIG.globalDefaultPerms.remove("*");
        }
        return (permMap = ConfigHandler.CONFIG.globalDefaultPerms.get(level.dimension().location().toString())) == null ? GlobalType.NONE : permMap.getOrDefault(perm, GlobalType.NONE);
    }

    public Stream<Map.Entry<ResourceLocation, GlobalType>> getGloballyDefinedVals(ServerLevel level) {
        Map<ResourceLocation, GlobalType> permMap;
        Map<ResourceLocation, GlobalType> allMap = ConfigHandler.CONFIG.globalDefaultPerms.get("*");
        if (allMap != null) {
            level.getServer().getAllLevels().forEach(w -> {
                Map wMap = ConfigHandler.CONFIG.globalDefaultPerms.getOrDefault(w.dimension().location().toString(), new HashMap());
                allMap.forEach((key, value) -> {
                    if (!wMap.containsKey(key)) {
                        wMap.put(key, value);
                    }
                });
                ConfigHandler.CONFIG.globalDefaultPerms.put(w.dimension().location().toString(), wMap);
            });
            ConfigHandler.CONFIG.globalDefaultPerms.remove("*");
        }
        return (permMap = ConfigHandler.CONFIG.globalDefaultPerms.get(level.dimension().location().toString())) == null ? Stream.empty() : permMap.entrySet().stream().filter(e -> ((GlobalType)((Object)((Object)e.getValue()))).canModify());
    }

    public static <V, K> Map<V, K> createHashMap(Consumer<Map<V, K>> cons) {
        HashMap map = new HashMap();
        cons.accept(map);
        return map;
    }

    public static enum GlobalType {
        ALLTRUE,
        ALLFALSE,
        TRUE,
        FALSE,
        NONE;


        public boolean getValue() {
            return this == ALLTRUE || this == TRUE;
        }

        public boolean canModify() {
            return this.ordinal() > 1;
        }
    }
}

