/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.mixin;

import com.mojang.authlib.GameProfile;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.event.PlayerEvents;
import io.github.flemmli97.flan.platform.ClaimEvents;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.utils.IPlayerClaimImpl;
import io.github.flemmli97.flan.utils.VanillaFlightStateTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class PlayerClaimMixin
extends Player
implements IPlayerClaimImpl,
VanillaFlightStateTracker {
    @Unique
    private PlayerClaimData flan$ClaimData;
    @Unique
    private Claim flan$CurrentClaim;
    @Unique
    private boolean flan$claimFlight;
    @Unique
    private boolean flan$togglingFlight;
    @Unique
    private boolean flan$otherFlightState;

    private PlayerClaimMixin(Level level, BlockPos pos, float yRot, GameProfile gameProfile) {
        super(level, pos, yRot, gameProfile);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void initData(CallbackInfo info) {
        this.flan$ClaimData = new PlayerClaimData((ServerPlayer)this);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickData(CallbackInfo info) {
        Claim newClaim = PlayerEvents.currentClaimTick((ServerPlayer)this, this.flan$CurrentClaim);
        if (this.flan$CurrentClaim != newClaim) {
            ClaimEvents.INSTANCE.borderCross((ServerPlayer)this, newClaim, this.flan$CurrentClaim);
        }
        this.flan$CurrentClaim = newClaim;
        this.flan$ClaimData.tick(this.flan$CurrentClaim);
    }

    @Inject(method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"}, at={@At(value="RETURN")})
    private void copyOld(ServerPlayer oldPlayer, boolean alive, CallbackInfo info) {
        this.flan$ClaimData.clone(PlayerClaimData.get(oldPlayer));
    }

    @Inject(method={"onUpdateAbilities()V"}, at={@At(value="HEAD")})
    private void abilityUpdate(CallbackInfo info) {
        if (!this.flan$togglingFlight) {
            this.flan$otherFlightState = this.getAbilities().mayfly;
        }
    }

    @Override
    public PlayerClaimData flan$get() {
        return this.flan$ClaimData;
    }

    @Override
    public Claim flan$getCurrentClaim() {
        return this.flan$CurrentClaim;
    }

    @Override
    public void flan$toggleFlight(boolean mayFly) {
        boolean changed = false;
        if (this.flan$claimFlight != mayFly) {
            if (mayFly) {
                this.flan$otherFlightState = this.getAbilities().mayfly;
                this.getAbilities().mayfly = true;
            } else {
                this.getAbilities().mayfly = this.flan$otherFlightState;
            }
            changed = true;
        }
        this.flan$claimFlight = mayFly;
        if (this.flan$claimFlight && !this.getAbilities().mayfly) {
            this.getAbilities().mayfly = true;
            changed = true;
        }
        if (!changed) {
            return;
        }
        if (!this.getAbilities().mayfly && this.getAbilities().flying) {
            this.getAbilities().flying = false;
        }
        this.flan$togglingFlight = true;
        this.onUpdateAbilities();
        this.flan$togglingFlight = false;
    }
}

