/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.DrawerProperties;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.client.gui.DrawerInfoGuiAddon;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.inventory.EnderInventoryHandler;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.network.EnderDrawerSyncMessage;
import com.buuz135.functionalstorage.util.Utils;
import com.buuz135.functionalstorage.world.EnderSavedData;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.network.Message;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EnderDrawerTile
extends ItemControllableDrawerTile<EnderDrawerTile> {
    @Save
    private String frequency = UUID.randomUUID().toString();
    private IItemHandler storage;

    public EnderDrawerTile(BasicTileBlock<EnderDrawerTile> base, BlockEntityType<EnderDrawerTile> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state, new DrawerProperties(32, FSAttachments.ITEM_STORAGE_MODIFIER));
    }

    public void setLevel(Level p_155231_) {
        super.setLevel(p_155231_);
        this.invalidateCapabilities();
        this.storage = EnderSavedData.getInstance((LevelAccessor)this.level).getFrequency(this.frequency);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new DrawerInfoGuiAddon(64, 16, Utils.resourceLocation("functionalstorage", "textures/block/ender_front.png"), 1, FunctionalStorage.DrawerType.X_1.getSlotPosition(), integer -> this.getStorage().getStackInSlot(integer.intValue()), integer -> this.getStorage().getSlotLimit(integer.intValue()), integer -> {
            ItemStack itemStack;
            IItemHandler patt0$temp = this.getStorage();
            if (patt0$temp instanceof BigInventoryHandler) {
                BigInventoryHandler bigInventoryHandler = (BigInventoryHandler)patt0$temp;
                itemStack = bigInventoryHandler.getStoredStacks().get((int)integer).getStack();
            } else {
                itemStack = this.getStorage().getStackInSlot(integer.intValue());
            }
            return itemStack;
        }));
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, EnderDrawerTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (level.getGameTime() % 20L == 0L) {
            FunctionalStorage.NETWORK.sendToNearby(level, pos, 32, (Message)new EnderDrawerSyncMessage(this.frequency, (EnderInventoryHandler)this.getStorage()));
        }
        if (level.getGameTime() % 10L == 0L) {
            EnderInventoryHandler handler = EnderSavedData.getInstance((LevelAccessor)this.level).getFrequency(this.frequency);
            if (handler.isLocked() != this.isLocked()) {
                super.setLocked(handler.isLocked());
            }
            if (!handler.isVoid()) {
                for (int i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
                    ItemStack stack = this.getUtilityUpgrades().getStackInSlot(i);
                    if (stack.isEmpty() || !stack.is((Item)FunctionalStorage.VOID_UPGRADE.get())) continue;
                    handler.setVoidItems(true);
                    stack.shrink(1);
                    break;
                }
            }
        }
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        InteractionResult result = super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot);
        if (slot != -1) {
            FunctionalStorage.NETWORK.sendToNearby(this.level, this.getBlockPos(), 32, (Message)new EnderDrawerSyncMessage(this.frequency, (EnderInventoryHandler)this.getStorage()));
        }
        return result;
    }

    @Override
    public void onClicked(Player playerIn, int slot) {
        super.onClicked(playerIn, slot);
        if (slot != -1) {
            FunctionalStorage.NETWORK.sendToNearby(this.level, this.getBlockPos(), 32, (Message)new EnderDrawerSyncMessage(this.frequency, (EnderInventoryHandler)this.getStorage()));
        }
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        String oldFreq = this.frequency;
        super.loadAdditional(compound, provider);
        if (!this.frequency.equalsIgnoreCase(oldFreq) && this.level instanceof ServerLevel) {
            this.setFrequency(this.frequency);
        }
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        EnderSavedData.getInstance((LevelAccessor)this.level).getFrequency(this.frequency).setLocked(locked);
    }

    @Override
    public boolean isVoid() {
        return EnderSavedData.getInstance((LevelAccessor)this.level).getFrequency(this.frequency).isVoid();
    }

    @NotNull
    public EnderDrawerTile getSelf() {
        return this;
    }

    @Override
    public int getStorageSlotAmount() {
        return 0;
    }

    @Override
    public IItemHandler getStorage() {
        return this.storage;
    }

    @Override
    public boolean isEverythingEmpty() {
        int i;
        EnderInventoryHandler inventoryHandler = EnderSavedData.getInstance((LevelAccessor)this.level).getFrequency(this.frequency);
        for (i = 0; i < inventoryHandler.getSlots(); ++i) {
            if (inventoryHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setFrequency(String frequency) {
        if (frequency == null) {
            return;
        }
        this.frequency = frequency;
        this.invalidateCapabilities();
        this.storage = EnderSavedData.getInstance((LevelAccessor)this.level).getFrequency(this.frequency);
        this.markForUpdate();
    }

    public String getFrequency() {
        return this.frequency;
    }
}

