/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.DrawerTile;
import com.buuz135.functionalstorage.client.BaseDrawerRenderer;
import com.buuz135.functionalstorage.client.FunctionalStorageClientConfig;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.util.MathUtils;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.buuz135.functionalstorage.util.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class DrawerRenderer
extends BaseDrawerRenderer<DrawerTile> {
    @Override
    public final void renderItems(DrawerTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_1) {
            this.render1Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_2) {
            this.render2Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        if (tile.getDrawerType() == FunctionalStorage.DrawerType.X_4) {
            this.render4Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        }
        matrixStack.popPose();
    }

    public static void renderUpgrades(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ControllableDrawerTile<?> tile) {
        float scale = 0.0625f;
        if (tile.getDrawerOptions().isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_UPGRADES)) {
            matrixStack.pushPose();
            matrixStack.translate(0.031, (double)0.031f, 0.0295);
            for (int i = 0; i < tile.getStorageUpgrades().getSlots(); ++i) {
                ItemStack stack = tile.getStorageUpgrades().getStackInSlot(i);
                if (stack.isEmpty()) continue;
                matrixStack.pushPose();
                matrixStack.scale(scale, scale, scale);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, tile.getLevel(), 0);
                matrixStack.popPose();
                matrixStack.translate(scale, 0.0f, 0.0f);
            }
            matrixStack.popPose();
        }
        if (tile.isVoid()) {
            matrixStack.pushPose();
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.969f, 0.031f, 0.0293125f), new Vector3f(0.0f), scale));
            Minecraft.getInstance().getItemRenderer().renderStatic(new ItemStack((ItemLike)FunctionalStorage.VOID_UPGRADE.get()), ItemDisplayContext.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, tile.getLevel(), 0);
            matrixStack.popPose();
        }
    }

    public static void renderIndicator(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, float progress, ControllableDrawerTile.DrawerOptions options) {
        int indicatiorValue = options.getAdvancedValue(ConfigurationToolItem.ConfigurationAction.INDICATOR);
        if (indicatiorValue != 0) {
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(Utils.resourceLocation("functionalstorage", "block/indicator"));
            VertexConsumer builder = bufferIn.getBuffer(RenderType.translucent());
            Matrix4f posMat = matrixStack.last().pose();
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            float alpha = 1.0f;
            float x1 = -0.25f;
            float x2 = x1 + 0.5f;
            float y1 = -0.415625f;
            float y2 = y1 + 0.078125f;
            float z2 = 0.0f;
            float bx1 = 0.0f;
            float bx2 = 0.5f;
            float bz1 = 0.0f;
            float bz2 = 0.125f;
            float u1 = still.getU(bx1);
            float u2 = still.getU(bx2);
            float v1 = still.getV(bz1);
            float v2 = still.getV(bz2);
            if (indicatiorValue != 3) {
                builder.addVertex(posMat, x2, y1, z2).setColor(red, green, blue, alpha).setUv(u2, v1).setOverlay(combinedOverlayIn).setLight(combinedLightIn).setNormal(0.0f, 0.0f, 1.0f);
                builder.addVertex(posMat, x2, y2, z2).setColor(red, green, blue, alpha).setUv(u2, v2).setOverlay(combinedOverlayIn).setLight(combinedLightIn).setNormal(0.0f, 0.0f, 1.0f);
                builder.addVertex(posMat, x1, y2, z2).setColor(red, green, blue, alpha).setUv(u1, v2).setOverlay(combinedOverlayIn).setLight(combinedLightIn).setNormal(0.0f, 0.0f, 1.0f);
                builder.addVertex(posMat, x1, y1, z2).setColor(red, green, blue, alpha).setUv(u1, v1).setOverlay(combinedOverlayIn).setLight(combinedLightIn).setNormal(0.0f, 0.0f, 1.0f);
            }
            u2 = still.getU(bx2 * progress);
            x2 = x1 + 0.5f * progress;
            z2 = 1.0E-4f;
            v1 = still.getV(0.5f);
            v2 = still.getV(0.625f);
            if (indicatiorValue == 1 || progress >= 1.0f) {
                builder.addVertex(posMat, x2, y1, z2).setColor(red, green, blue, alpha).setUv(u2, v1).setOverlay(combinedOverlayIn).setLight(combinedLightIn).setNormal(0.0f, 0.0f, 1.0f);
                builder.addVertex(posMat, x2, y2, z2).setColor(red, green, blue, alpha).setUv(u2, v2).setOverlay(combinedOverlayIn).setLight(combinedLightIn).setNormal(0.0f, 0.0f, 1.0f);
                builder.addVertex(posMat, x1, y2, z2).setColor(red, green, blue, alpha).setUv(u1, v2).setOverlay(combinedOverlayIn).setLight(combinedLightIn).setNormal(0.0f, 0.0f, 1.0f);
                builder.addVertex(posMat, x1, y1, z2).setColor(red, green, blue, alpha).setUv(u1, v1).setOverlay(combinedOverlayIn).setLight(combinedLightIn).setNormal(0.0f, 0.0f, 1.0f);
            }
        }
    }

    private void render1Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, DrawerTile tile) {
        BigInventoryHandler inventoryHandler = (BigInventoryHandler)tile.getStorage();
        if (!inventoryHandler.getStoredStacks().get(0).getStack().isEmpty()) {
            matrixStack.translate(0.5, 0.5, (double)5.0E-4f);
            ItemStack stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(0).getCount(), inventoryHandler.getSlotLimit(0), 0.015f, tile.getDrawerOptions(), tile.getLevel());
        }
    }

    private void render2Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, DrawerTile tile) {
        ItemStack stack;
        BigInventoryHandler inventoryHandler = (BigInventoryHandler)tile.getStorage();
        if (!inventoryHandler.getStoredStacks().get(0).getStack().isEmpty()) {
            matrixStack.pushPose();
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.5f, 0.27f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(0).getCount(), inventoryHandler.getSlotLimit(0), 0.02f, tile.getDrawerOptions(), tile.getLevel());
            matrixStack.popPose();
        }
        if (!inventoryHandler.getStoredStacks().get(1).getStack().isEmpty()) {
            matrixStack.pushPose();
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.5f, 0.77f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(1).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(1).getCount(), inventoryHandler.getSlotLimit(1), 0.02f, tile.getDrawerOptions(), tile.getLevel());
            matrixStack.popPose();
        }
    }

    private void render4Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, DrawerTile tile) {
        ItemStack stack;
        BigInventoryHandler inventoryHandler = (BigInventoryHandler)tile.getStorage();
        if (!inventoryHandler.getStoredStacks().get(0).getStack().isEmpty()) {
            matrixStack.pushPose();
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.75f, 0.27f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(0).getCount(), inventoryHandler.getSlotLimit(0), 0.02f, tile.getDrawerOptions(), tile.getLevel());
            matrixStack.popPose();
        }
        if (!inventoryHandler.getStoredStacks().get(1).getStack().isEmpty()) {
            matrixStack.pushPose();
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.25f, 0.27f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(1).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(1).getCount(), inventoryHandler.getSlotLimit(1), 0.02f, tile.getDrawerOptions(), tile.getLevel());
            matrixStack.popPose();
        }
        if (!inventoryHandler.getStoredStacks().get(2).getStack().isEmpty()) {
            matrixStack.pushPose();
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.75f, 0.77f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(2).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(2).getCount(), inventoryHandler.getSlotLimit(2), 0.02f, tile.getDrawerOptions(), tile.getLevel());
            matrixStack.popPose();
        }
        if (!inventoryHandler.getStoredStacks().get(3).getStack().isEmpty()) {
            matrixStack.pushPose();
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.25f, 0.77f, 5.0E-4f), new Vector3f(0.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
            stack = inventoryHandler.getStoredStacks().get(3).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStackInSlot(3).getCount(), inventoryHandler.getSlotLimit(3), 0.02f, tile.getDrawerOptions(), tile.getLevel());
            matrixStack.popPose();
        }
    }

    public static void renderStack(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ItemStack stack, int amount, int maxAmount, float scale, ControllableDrawerTile.DrawerOptions options, Level level) {
        DrawerRenderer.renderIndicator(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, Math.min(1.0f, (float)amount / (float)maxAmount), options);
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
        if (model.isGui3d()) {
            float thickness = (float)FunctionalStorageClientConfig.DRAWER_RENDER_THICKNESS;
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f), new Vector3f(0.75f, 0.75f, thickness)));
        } else {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f), 0.4f));
        }
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        if (options.isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_RENDER)) {
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, level, 0);
        }
        matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        if (!model.isGui3d()) {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f), new Vector3f(1.25f, 1.25f, 1.0f)));
        } else {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f), 0.665f));
        }
        if (options.isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_NUMBERS)) {
            DrawerRenderer.renderText(matrixStack, bufferIn, combinedOverlayIn, (Component)Component.literal((String)(String.valueOf(ChatFormatting.WHITE) + NumberUtils.getFormatedBigNumber(amount))), Direction.NORTH, scale);
        }
    }

    public static void renderText(PoseStack matrix, MultiBufferSource renderer, int overlayLight, Component text, Direction side, float maxScale) {
        matrix.translate(0.0, -0.745, 0.01);
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        Font font = Minecraft.getInstance().font;
        int requiredWidth = Math.max(font.width((FormattedText)text), 1);
        Objects.requireNonNull(font);
        int requiredHeight = 9 + 2;
        float scaler = 0.4f;
        float scaleX = displayWidth / (float)requiredWidth;
        float scale = scaleX * scaler;
        if (maxScale > 0.0f) {
            scale = Math.min(scale, maxScale);
        }
        matrix.scale(scale, -scale, scale);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - requiredHeight) / 2;
        font.drawInBatch(text, (float)(offsetX - realWidth / 2), (float)(3 + offsetY - realHeight / 2), overlayLight, false, matrix.last().pose(), renderer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

