/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item.component;

import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public record ExecuteEveryBehavior(int ticks, FunctionalUpgradeBehavior behavior) implements FunctionalUpgradeBehavior
{
    public static final MapCodec<ExecuteEveryBehavior> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("speed").forGetter(ExecuteEveryBehavior::ticks), (App)FunctionalUpgradeBehavior.CODEC.fieldOf("behavior").forGetter(ExecuteEveryBehavior::behavior)).apply((Applicative)in, ExecuteEveryBehavior::new));

    @Override
    public void work(Level level, BlockPos pos, ControllableDrawerTile<?> drawer, ItemStack upgradeStack, int upgradeSlot) {
        if (level.getGameTime() % (long)this.ticks == 0L) {
            this.behavior.work(level, pos, drawer, upgradeStack, upgradeSlot);
        }
    }

    @Override
    public boolean canConnectRedstone(Level level, BlockPos blockPos, BlockState state, ControllableDrawerTile<?> drawer, Direction direction, ItemStack upgradeStack, int upgradeSlot) {
        return this.behavior.canConnectRedstone(level, blockPos, state, drawer, direction, upgradeStack, upgradeSlot);
    }

    @Override
    public int getRedstoneSignal(Level level, BlockPos blockPos, BlockState state, ControllableDrawerTile<?> drawer, Direction direction, ItemStack upgradeStack, int upgradeSlot) {
        return this.behavior.getRedstoneSignal(level, blockPos, state, drawer, direction, upgradeStack, upgradeSlot);
    }

    @Override
    public MapCodec<? extends FunctionalUpgradeBehavior> codec() {
        return CODEC;
    }

    @Override
    public List<Component> getTooltip() {
        List<Component> list = FunctionalUpgradeBehavior.super.getTooltip();
        list.add((Component)Component.translatable((String)"functionalupgrade.desc.execute_every_tick", (Object[])new Object[]{this.ticks}).withStyle(ChatFormatting.YELLOW));
        for (Component component : this.behavior.getTooltip()) {
            list.add((Component)Component.literal((String)" ").append(component));
        }
        return list;
    }
}

