/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.mekanism;

import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;

public record VoidChemicalHandler(BlockEntity voidContainer) implements IChemicalHandler
{
    public static VoidChemicalHandler INSTANCE = new VoidChemicalHandler(null);

    public int getChemicalTanks() {
        return 1;
    }

    @NotNull
    public ChemicalStack getChemicalInTank(int tank) {
        return ChemicalStack.EMPTY;
    }

    public void setChemicalInTank(int tank, @NotNull ChemicalStack stack) {
    }

    public long getChemicalTankCapacity(int tank) {
        return 1000000000000000000L;
    }

    public boolean isValid(int tank, @NotNull ChemicalStack stack) {
        return true;
    }

    @NotNull
    public ChemicalStack insertChemical(int tank, @NotNull ChemicalStack stack, @NotNull Action action) {
        if (action.execute() && this.voidContainer != null) {
            this.voidContainer.setData(CoreAttachments.Void, (Object)true);
        }
        return stack.getChemical().hasAttributesWithValidation() ? stack : ChemicalStack.EMPTY;
    }

    @NotNull
    public ChemicalStack extractChemical(int tank, long amount, @NotNull Action action) {
        return ChemicalStack.EMPTY;
    }
}

