/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModule;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModuleContainer;
import tv.soaryn.xycraft.api.content.capabilities.modular.ModuleType;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.serialization.CommonCodecs;

public class EngineeringTableAttachment
implements CommonCodecs.IItemContainerHolder {
    private static final Codec<EngineeringTableAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CommonCodecs.recordCodec((String)"inventory")).apply((Applicative)builder, EngineeringTableAttachment::new));
    public static final AttachmentType.Builder<EngineeringTableAttachment> BUILDER = AttachmentUtils.createBuilder(EngineeringTableAttachment::new, CODEC, (data, holder) -> {
        data.Inventory._blockEntity = data._blockEntity = (BlockEntity)holder;
    });
    public final Container Inventory;
    private BlockEntity _blockEntity;

    private EngineeringTableAttachment(List<ItemStack> items) {
        this.Inventory = new Container(items.size(), this::setChanged);
        for (int i = 0; i < items.size(); ++i) {
            this.Inventory.set(i, items.get(i));
        }
    }

    private EngineeringTableAttachment(IAttachmentHolder holder) {
        this.Inventory = new Container(7, this::setChanged);
        this.Inventory._blockEntity = this._blockEntity = (BlockEntity)holder;
    }

    public ItemContainer getInventory() {
        return this.Inventory;
    }

    private void setChanged() {
        if (this._blockEntity != null) {
            this._blockEntity.setChanged();
        }
    }

    public static class Container
    extends SimpleItemContainer {
        private BlockEntity _blockEntity;

        public Container(int size, @Nullable Runnable updateCallback) {
            super(size, updateCallback);
        }

        public void set(int slot, @NotNull ItemStack stack) {
            ItemStack current = this.get(slot);
            ItemStack storageStack = this.get(0);
            if (stack == current) {
                return;
            }
            if (slot == 0) {
                super.set(slot, stack);
                if (stack.isEmpty()) {
                    for (int i = 1; i < this.size(); ++i) {
                        this.set(i, ItemStack.EMPTY);
                    }
                } else {
                    IModuleContainer storageCap = (IModuleContainer)stack.getCapability(CoreCapabilities.ModuleContainer.ITEM);
                    if (storageCap == null) {
                        return;
                    }
                    List modules = storageCap.getInstalledModules();
                    for (int i = 0; i < modules.size(); ++i) {
                        this.set(i + 1, ((IModuleContainer.ModuleRecord)modules.get(i)).stack().copy());
                    }
                }
                return;
            }
            IModuleContainer storageCap = (IModuleContainer)storageStack.getCapability(CoreCapabilities.ModuleContainer.ITEM);
            if (storageCap != null) {
                Level level;
                List modules = storageCap.getInstalledModules();
                if (stack.isEmpty()) {
                    module = ((IModuleContainer.ModuleRecord)modules.get(slot - 1)).module();
                    if (module != null) {
                        module.onRemoved(storageStack);
                    }
                } else {
                    module = (IModule)stack.getCapability(IModule.ITEM);
                    if (module != null) {
                        module.onAdded(storageStack);
                    }
                }
                storageCap.installModule(slot - 1, stack.copy());
                if (this._blockEntity != null && (level = this._blockEntity.getLevel()) != null) {
                    storageCap.invalidate(level.registryAccess());
                }
            }
            super.set(slot, stack);
        }

        public boolean isValid(int slot, @NotNull ItemStack stack) {
            if (!super.isValid(slot, stack)) {
                return false;
            }
            if (slot == 0) {
                return stack.getCapability(IModuleContainer.ITEM) != null;
            }
            ItemStack storageStack = this.get(0);
            if (storageStack.isEmpty()) {
                return false;
            }
            IModuleContainer moduleStorage = (IModuleContainer)storageStack.getCapability(IModuleContainer.ITEM);
            IModule module = (IModule)stack.getCapability(IModule.ITEM);
            if (moduleStorage == null || module == null) {
                return false;
            }
            List moduleRecords = moduleStorage.getInstalledModules();
            ArrayList<IModule> list = new ArrayList<IModule>();
            ModuleType type = module.getModuleType();
            for (int i = 0; i < moduleRecords.size(); ++i) {
                IModule slotModule;
                if (slot - 1 == i || (slotModule = ((IModuleContainer.ModuleRecord)moduleRecords.get(i)).module()) == null) continue;
                if (!type.isCompatible(slotModule.getModuleType())) {
                    return false;
                }
                if (slotModule.getModuleType() == ModuleType.Mythic || type == ModuleType.Specialization && slotModule.getModuleType() == ModuleType.Specialization) {
                    return false;
                }
                list.add(slotModule);
            }
            if (type == ModuleType.Mythic && !list.isEmpty()) {
                return false;
            }
            return module.isValidFor(storageStack) && module.isCompatibleWith(list);
        }
    }
}

