/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe.objects;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.IInfoPresenter;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.api.content.pipes.PipeGraphState;
import tv.soaryn.xycraft.api.content.pipes.PipeGroup;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.api.content.pipes.PipeRoute;
import tv.soaryn.xycraft.api.content.pipes.examples.EnergyPipeGraph;
import tv.soaryn.xycraft.core.content.attachments.memory.CapabilitySidedCacheAttachment;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.machines.content.blocks.pipe.BasicPipeConnectionLogic;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeBlock;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.pipe.objects.DummyEnergyStorage;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesCapabilities;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class EnergyPipeBlockEntity
extends PipeBlockEntity<IEnergyStorage> {
    public EnergyPipeBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.Block.PipeEnergy.entity(), pos, state, MachinesAttachments.Block.PipeConnectionData.get());
    }

    public static PipeBlock<EnergyPipeGraph, IEnergyStorage> block(BlockBehaviour.Properties properties) {
        return new PipeBlock<EnergyPipeGraph, IEnergyStorage>(properties.dynamicShape().noOcclusion().mapColor(MapColor.COLOR_ORANGE).strength(Blocks.STONE.defaultDestroyTime()).sound(SoundType.COPPER), EnergyPipeBlockEntity::new, CoreAttachments.AdjacentEnergyCapabilityCache, MachinesAttachments.Level.EnergyPipeNetwork);
    }

    @SubscribeEvent
    private static void exposeCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, MachinesContent.Block.PipeEnergy.entity(), EnergyPipeBlockEntity::getHandler);
        event.registerBlockEntity(MachinesCapabilities.PipeConnection.BLOCK, MachinesContent.Block.PipeEnergy.entity(), (blockEntity, context) -> new BasicPipeConnectionLogic((BlockCapability<?, Direction>)Capabilities.EnergyStorage.BLOCK, (BlockEntity)blockEntity, 1000L));
        event.registerBlockEntity(CoreCapabilities.WrenchBlock.BLOCK, MachinesContent.Block.PipeEnergy.entity(), PipeBlock::handleWrench);
        event.registerBlockEntity(IInfoPresenter.BLOCK, MachinesContent.Block.PipeEnergy.entity(), (object, context) -> player -> {
            Level level = player.level();
            BlockPos pos = object.getBlockPos();
            if (level.isClientSide()) {
                return;
            }
            PipeNetwork data = (PipeNetwork)player.level().getData(MachinesAttachments.Level.EnergyPipeNetwork);
            EnergyPipeGraph graph = (EnergyPipeGraph)data.getPipeGraph(pos.asLong());
            if (!(graph instanceof EnergyPipeGraph)) {
                return;
            }
            EnergyPipeGraph energyPipeGraph = graph;
            int color = ((DyeColors)MathUtils.fromArray((int)(Mth.abs((int)graph.id().hashCode()) % 4), (Object[])new DyeColors[]{DyeColors.LightBlue, DyeColors.Lime, DyeColors.Yellow})).getColor();
            long sum = graph.getAllBuffers().stream().mapToLong(PipeGroup::getStored).sum();
            String output = "\n    - Total Stored: " + sum + "\n    - Connected Handlers: " + String.valueOf(((ObjectArraySet)energyPipeGraph.getRouteContainer().PosToExternalCaches.get(pos.asLong())).stream().map(PipeRoute.CacheWrapper::getCapability).filter(Objects::nonNull).map(handler -> handler.getClass().getSimpleName()).toList()) + "\n    - Simulated Demands:  " + String.valueOf(((ObjectArraySet)energyPipeGraph.getRouteContainer().PosToExternalCaches.get(pos.asLong())).stream().map(PipeRoute.CacheWrapper::getCapability).filter(Objects::nonNull).map(handler -> handler.receiveEnergy(Integer.MAX_VALUE, true)).toList());
            player.sendSystemMessage((Component)Component.literal((String)("Graph: " + graph.id().toString().substring(0, 13) + " : " + graph.getRouteContainer().RouteGraph.vertexSet().size() + " pipes")).withColor(color).append((Component)Component.literal((String)output)));
        });
    }

    @Override
    public Supplier<AttachmentType<CapabilitySidedCacheAttachment<IEnergyStorage>>> getCapCache() {
        return CoreAttachments.AdjacentEnergyCapabilityCache;
    }

    @Nullable
    private static IEnergyStorage getHandler(BlockEntity pipe, Direction context) {
        ServerLevel level;
        block11: {
            block10: {
                Level level2 = pipe.getLevel();
                if (!(level2 instanceof ServerLevel)) break block10;
                level = (ServerLevel)level2;
                if (context != null) break block11;
            }
            return null;
        }
        IPipeConnection pipeCap = (IPipeConnection)level.getCapability(IPipeConnection.BLOCK, pipe.getBlockPos(), null);
        if (pipeCap == null) {
            return null;
        }
        if (pipeCap.isClosed(context)) {
            return new DummyEnergyStorage();
        }
        return switch (pipeCap.getLogic(context)) {
            default -> throw new MatchException(null, null);
            case PipeConnectionType.None -> null;
            case PipeConnectionType.Insert -> new DummyEnergyStorage();
            case PipeConnectionType.Transfer, PipeConnectionType.Extract -> new EnergyPipeGraphHandler(level, pipe);
        };
    }

    private record EnergyPipeGraphHandler(ServerLevel level, BlockEntity pipe) implements IEnergyStorage
    {
        public int getEnergyStored() {
            ObjectArraySet<PipeGroup<IEnergyStorage>> buffers = this.getPipeGroups();
            if (buffers == null) {
                return 0;
            }
            return MathUtils.toInt((long)buffers.stream().mapToLong(PipeGroup::getStored).sum());
        }

        public int getMaxEnergyStored() {
            ObjectArraySet<PipeGroup<IEnergyStorage>> groups = this.getPipeGroups();
            if (groups == null) {
                return 0;
            }
            return MathUtils.toInt((long)groups.stream().mapToLong(PipeGroup::getAcceptanceBuffer).sum());
        }

        @Nullable
        private ObjectArraySet<PipeGroup<IEnergyStorage>> getPipeGroups() {
            long posId = this.pipe.getBlockPos().asLong();
            EnergyPipeGraph graph = (EnergyPipeGraph)((PipeNetwork)this.level.getData(MachinesAttachments.Level.EnergyPipeNetwork)).getPipeGraph(posId);
            if (graph == null || graph.state() != PipeGraphState.READY) {
                return null;
            }
            return graph.initBufferAllowances(this.level, posId);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            EnergyPipeGraph graph = (EnergyPipeGraph)((PipeNetwork)this.level.getData(MachinesAttachments.Level.EnergyPipeNetwork)).getPipeGraph(this.pipe.getBlockPos());
            if (graph == null || graph.state() != PipeGraphState.READY) {
                return 0;
            }
            ObjectArraySet buffers = graph.initBufferAllowances(this.level, this.pipe.getBlockPos().asLong());
            int inject = maxReceive;
            for (PipeGroup b : buffers) {
                if (inject == 0) break;
                if (b.AcceptanceBuffer == 0L) continue;
                int injected = MathUtils.toInt((long)Math.min((long)inject, b.AcceptanceBuffer));
                inject -= injected;
                if (simulate) continue;
                b.AcceptanceBuffer -= (long)injected;
                b.Stored += (long)injected;
            }
            return maxReceive - inject;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EnergyPipeGraphHandler)) {
                return false;
            }
            EnergyPipeGraphHandler otherHandler = (EnergyPipeGraphHandler)obj;
            long posId = this.pipe.getBlockPos().asLong();
            EnergyPipeGraph graph = (EnergyPipeGraph)((PipeNetwork)this.level.getData(MachinesAttachments.Level.EnergyPipeNetwork)).getPipeGraph(posId);
            long otherId = otherHandler.pipe().getBlockPos().asLong();
            EnergyPipeGraph otherGraph = (EnergyPipeGraph)((PipeNetwork)this.level.getData(MachinesAttachments.Level.EnergyPipeNetwork)).getPipeGraph(otherId);
            if (graph == otherGraph) {
                return true;
            }
            if (graph == null || otherGraph == null) {
                return false;
            }
            return graph.id().equals(otherGraph.id());
        }
    }
}

