/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.pipes;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.core.content.attachments.accessors.Ticks;
import tv.soaryn.xycraft.core.content.systems.ISystemData;
import tv.soaryn.xycraft.core.content.systems.LevelSystemAttachment;
import tv.soaryn.xycraft.core.content.systems.LevelSystemBase;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public class EnergyPipeEventSystem
extends LevelSystemBase<LevelSystemAttachment> {
    public EnergyPipeEventSystem() {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, this::load);
    }

    void load(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        PipeNetwork network = (PipeNetwork)level.getData(MachinesAttachments.Level.EnergyPipeNetwork);
        network.load(level);
    }

    public void preTick(LevelTickEvent event, LevelSystemAttachment data) {
        super.preTick(event, (ISystemData)data);
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ((PipeNetwork)level2.getData(MachinesAttachments.Level.EnergyPipeNetwork)).preTick(level2);
    }

    public void postTick(LevelTickEvent event, LevelSystemAttachment data) {
        super.postTick(event, (ISystemData)data);
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        PipeNetwork network = (PipeNetwork)level2.getData(MachinesAttachments.Level.EnergyPipeNetwork);
        if (data.enabled() && level2.tickRateManager().runsNormally() && Ticks.of((IAttachmentHolder)level2) % data.frequency() == 0L) {
            network.postTick(level2);
        }
        network.clean(level2);
    }

    public boolean overridesEnabledFlag() {
        return true;
    }

    @NotNull
    protected Supplier<AttachmentType<LevelSystemAttachment>> getAttachmentType() {
        return MachinesAttachments.System.EnergyPipeSystemData;
    }
}

