/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.pipes;

import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import tv.soaryn.xycraft.api.content.pipes.PipeGroup;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.api.content.pipes.PipeRoute;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.multiblock.pipes.FluidPipeGraph;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.network.CBFluidPipeGraphUpdatePacket;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public interface FluidPipeEventSystem {
    @SubscribeEvent
    public static void load(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        PipeNetwork network = (PipeNetwork)level.getData(MachinesAttachments.Level.FluidPipeNetwork);
        network.load(level);
    }

    @SubscribeEvent
    public static void tickPre(LevelTickEvent.Pre event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (!(level2 instanceof ServerLevel) || !(level = (ServerLevel)level2).tickRateManager().runsNormally()) {
            return;
        }
        PipeNetwork network = (PipeNetwork)level.getData(MachinesAttachments.Level.FluidPipeNetwork);
        network.preTick(level);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void tickPost(LevelTickEvent.Post event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (!(level2 instanceof ServerLevel) || !(level = (ServerLevel)level2).tickRateManager().runsNormally()) {
            return;
        }
        PipeNetwork network = (PipeNetwork)level.getData(MachinesAttachments.Level.FluidPipeNetwork);
        network.postTick(level);
        network.clean(level);
    }

    @SubscribeEvent
    public static void watch(ChunkWatchEvent.Sent event) {
        ServerLevel level = event.getLevel();
        PipeNetwork network = (PipeNetwork)level.getData(MachinesAttachments.Level.FluidPipeNetwork);
        if (network.IdToGraph().isEmpty()) {
            return;
        }
        ChunkPos chunkPos = event.getChunk().getPos();
        long chunkId = ChunkPos.asLong((int)chunkPos.x, (int)chunkPos.z);
        LongArraySet posSet = (LongArraySet)network.ChunkToPos().get(chunkId);
        if (posSet == null) {
            return;
        }
        for (long posId : posSet.toLongArray()) {
            FluidPipeGraph graph;
            UUID id = (UUID)network.PosToId().get(posId);
            if (id == null || (graph = (FluidPipeGraph)((Object)network.IdToGraph().get((Object)id))) == null) continue;
            PipeRoute route = graph.getRouteContainer();
            graph.onGraphForm(level, graph.id(), new LongArraySet(route.RouteGraph.vertexSet()), route.RouteGraph.edgeSet());
            long sum = 0L;
            for (PipeGroup value : graph.getAllBuffers()) {
                sum += value.Stored;
            }
            XyMachines.Network.broadcast((Level)level, (Packet.ClientBound)new CBFluidPipeGraphUpdatePacket(graph.id(), graph.Filter, sum));
        }
    }
}

