/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.BufferedTankAttachment;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class NitrogenExtractorTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.NitrogenExtractor.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.NitrogenExtractor.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Nitrogen Extractor at block position {} was moved without calling onRemove. Take note of how it may have been moved and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }

    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        IFluidHandler cap = CapAccess.fluid((BlockEntity)blockEntity, (Direction)SidePartBlock.directionOf((BlockState)state));
        if (cap == null) {
            return;
        }
        FluidStack fluidToFill = MachinesContent.Fluid.Nitrogen.fluid(1000);
        BufferedTankAttachment data = (BufferedTankAttachment)blockEntity.getData(MachinesAttachments.Block.BufferedTankData);
        if (!FluidStack.isSameFluidSameComponents((FluidStack)data.Tank.getFluid(), (FluidStack)fluidToFill)) {
            data.Tank.setFluid(FluidStack.EMPTY);
        }
        data.Tank.fill(fluidToFill.copy(), IFluidHandler.FluidAction.EXECUTE);
        FluidUtil.tryFluidTransfer((IFluidHandler)cap, (IFluidHandler)data.Tank, (int)data.Tank.getCapacity(), (boolean)true);
        blockEntity.setChanged();
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.System.NitrogenExtractorSystemData;
    }
}

