/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.volumes;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.level.LevelEvent;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.content.volumes.ICacheableVolume;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public record IlluminationVolume(BlockPos pos) implements ICacheableVolume
{
    public static final AttachmentType.Builder<VolumeLevelAttachment<IlluminationVolume>> Builder = VolumeLevelAttachment.builder(IlluminationVolume.class, IlluminationVolume::new);

    public int getRange() {
        return 7;
    }

    public BlockPos getPos() {
        return this.pos();
    }

    public int getLightLevel(BlockState state) {
        return (Integer)state.getValue((Property)BlockStateProperties.LEVEL);
    }

    public boolean isStateValid(BlockState blockState) {
        return blockState.is(MachinesContent.Block.IlluminationField.block());
    }

    @SubscribeEvent
    public static void onLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        VolumeLevelAttachment.load((ServerLevel)serverLevel, MachinesAttachments.Block.IlluminationVolumeData);
    }
}

