/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.configs.CommonConfigs;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundDamageNumberMessage;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.entity.EntityTypeTest;

public class ModEvents {
    public static void onEntityCriticalHit(Player attacker, Entity target, float damageModifier) {
        if (attacker != null && !attacker.level().isClientSide && target instanceof TargetDummyEntity) {
            TargetDummyEntity dummy = (TargetDummyEntity)target;
            dummy.moist((Entity)attacker, damageModifier);
        }
    }

    public static boolean canBeScaredByScarecrow(Entity entity) {
        String name = Utils.getID((EntityType)entity.getType()).toString();
        return (entity instanceof Animal || CommonConfigs.WHITELIST.get().contains(name)) && !CommonConfigs.BLACKLIST.get().contains(name);
    }

    public static boolean isScarecrowInRange(Entity entity, Level world) {
        return !world.getEntities((EntityTypeTest)Dummmmmmy.TARGET_DUMMY.get(), entity.getBoundingBox().inflate(10.0), TargetDummyEntity::canScare).isEmpty();
    }

    public static boolean onCheckSpawn(Mob entity, LevelAccessor level) {
        if (level instanceof Level) {
            Level l = (Level)level;
            if (ModEvents.canBeScaredByScarecrow((Entity)entity)) {
                return ModEvents.isScarecrowInRange((Entity)entity, l);
            }
        }
        return false;
    }

    public static void onEntityJoinWorld(Entity entity) {
        if (entity.level().isClientSide) {
            return;
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            if (ModEvents.canBeScaredByScarecrow(entity)) {
                mob.goalSelector.addGoal(0, (Goal)new AvoidEntityGoal(mob, TargetDummyEntity.class, (float)CommonConfigs.RADIUS.get().intValue(), 1.0, 1.3, d -> ((TargetDummyEntity)((Object)d)).canScare()));
            }
        }
        if (CommonConfigs.DECOY.get().booleanValue() && entity instanceof Monster) {
            Monster m = (Monster)entity;
            m.goalSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)m, TargetDummyEntity.class, 20, true, true, d -> ((TargetDummyEntity)((Object)d)).canAttract()));
        }
    }

    public static void onEntityDamage(LivingEntity target, float amount, DamageSource source) {
        if (!target.level().isClientSide && target.getType() != Dummmmmmy.TARGET_DUMMY.get() && amount != 0.0f) {
            ClientBoundDamageNumberMessage message = new ClientBoundDamageNumberMessage(target.getId(), amount, source, null, target.level());
            switch (CommonConfigs.DAMAGE_NUMBERS_MODE.get()) {
                case ALL_ENTITIES: {
                    NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)target, (CustomPacketPayload)message);
                    break;
                }
                case ALL_PLAYERS: {
                    if (!(source.getEntity() instanceof ServerPlayer)) break;
                    NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)target, (CustomPacketPayload)message);
                    break;
                }
                case LOCAL_PLAYER: {
                    Entity entity = source.getEntity();
                    if (!(entity instanceof ServerPlayer)) break;
                    ServerPlayer attackingPlayer = (ServerPlayer)entity;
                    NetworkHelper.sendToClientPlayer((ServerPlayer)attackingPlayer, (CustomPacketPayload)message);
                    break;
                }
            }
        }
    }

    public static void onEntityHeal(LivingEntity entity, float amount) {
        if (!entity.level().isClientSide && entity.getType() != Dummmmmmy.TARGET_DUMMY.get() && amount != 0.0f) {
            ClientBoundDamageNumberMessage message = new ClientBoundDamageNumberMessage(entity.getId(), -amount, null, null, entity.level());
            switch (CommonConfigs.HEALING_NUMBERS_MODE.get()) {
                case ALL_ENTITIES: {
                    NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)message);
                    break;
                }
                case ALL_PLAYERS: {
                    if (!(entity instanceof ServerPlayer)) break;
                    NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)message);
                    break;
                }
                case LOCAL_PLAYER: {
                    if (!(entity instanceof ServerPlayer)) break;
                    ServerPlayer player = (ServerPlayer)entity;
                    NetworkHelper.sendToClientPlayer((ServerPlayer)player, (CustomPacketPayload)message);
                    break;
                }
            }
        }
    }
}

