/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.measurements.client.BoxHandler;
import com.mrbysco.measurements.client.LineRenderType;
import com.mrbysco.measurements.config.TextColor;
import com.mrbysco.measurements.platform.Services;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class MeasurementBox {
    private final BlockPos startPos;
    private BlockPos endPos;
    public AABB box;
    private final ResourceKey<Level> dimensionKey;
    private boolean finished;
    private final DyeColor lineColor;
    private final DyeColor textX;
    private final DyeColor textY;
    private final DyeColor textZ;

    MeasurementBox(BlockPos block, ResourceKey<Level> dimensionKey) {
        this.startPos = block;
        this.endPos = block;
        this.dimensionKey = dimensionKey;
        this.finished = false;
        this.lineColor = Services.PLATFORM.getLineColor().getColor(BoxHandler.random);
        TextColor textColor = Services.PLATFORM.getTextColor();
        if (textColor == TextColor.XYZRGB) {
            this.textX = Services.PLATFORM.getTextColor().getColor(BoxHandler.random, Direction.Axis.X);
            this.textY = Services.PLATFORM.getTextColor().getColor(BoxHandler.random, Direction.Axis.Y);
            this.textZ = Services.PLATFORM.getTextColor().getColor(BoxHandler.random, Direction.Axis.Z);
        } else {
            DyeColor color;
            this.textX = color = textColor.getColor(BoxHandler.random, null);
            this.textY = color;
            this.textZ = color;
        }
        this.setBoundingBox();
    }

    private void setBoundingBox() {
        int ax = this.startPos.getX();
        int ay = this.startPos.getY();
        int az = this.startPos.getZ();
        int bx = this.endPos.getX();
        int by = this.endPos.getY();
        int bz = this.endPos.getZ();
        this.box = new AABB((double)Math.min(ax, bx), (double)Math.min(ay, by), (double)Math.min(az, bz), (double)(Math.max(ax, bx) + 1), (double)(Math.max(ay, by) + 1), (double)(Math.max(az, bz) + 1));
    }

    public void setBlockEnd(BlockPos blockEnd) {
        this.endPos = blockEnd;
        this.setBoundingBox();
    }

    public void render(ResourceKey<Level> currentDimensionKey, PoseStack poseStack, RenderBuffers renderBuffers, Camera camera, Matrix4f projection) {
        if (!this.dimensionKey.location().equals((Object)currentDimensionKey.location())) {
            return;
        }
        int color = this.lineColor.getTextureDiffuseColor();
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        float a = 0.95f;
        Vec3 pos = camera.getPosition();
        double distance = this.box.getCenter().distanceTo(pos);
        float lineWidth = Services.PLATFORM.getLineWidth();
        if (distance > 48.0) {
            lineWidth = Services.PLATFORM.getLineWidthMax();
        }
        MultiBufferSource.BufferSource bufferSource = renderBuffers.bufferSource();
        poseStack.pushPose();
        RenderType renderType = LineRenderType.lineRenderType(lineWidth);
        VertexConsumer builder = bufferSource.getBuffer(renderType);
        poseStack.translate(-pos.x, -pos.y, -pos.z);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)builder, (AABB)this.box, (float)r, (float)g, (float)b, (float)0.95f);
        bufferSource.endBatch(renderType);
        poseStack.popPose();
        this.drawLength(poseStack, camera, projection, bufferSource);
    }

    private void drawLength(PoseStack poseStack, Camera camera, Matrix4f projection, MultiBufferSource.BufferSource bufferSource) {
        int lengthX = (int)this.box.getXsize();
        int lengthY = (int)this.box.getYsize();
        int lengthZ = (int)this.box.getZsize();
        Vec3 pos = camera.getPosition();
        Frustum clippingHelper = new Frustum(poseStack.last().pose(), projection);
        clippingHelper.prepare(pos.x, pos.y, pos.z);
        AABB boxT = this.box.inflate((double)0.08f);
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(Line.createLine(new AABB(boxT.minX, boxT.minY, boxT.minZ, boxT.minX, boxT.minY, boxT.maxZ), pos));
        lines.add(Line.createLine(new AABB(boxT.minX, boxT.maxY, boxT.minZ, boxT.minX, boxT.maxY, boxT.maxZ), pos));
        lines.add(Line.createLine(new AABB(boxT.maxX, boxT.minY, boxT.minZ, boxT.maxX, boxT.minY, boxT.maxZ), pos));
        lines.add(Line.createLine(new AABB(boxT.maxX, boxT.maxY, boxT.minZ, boxT.maxX, boxT.maxY, boxT.maxZ), pos));
        Collections.sort(lines);
        AABB lineZ = ((Line)lines.getFirst()).line;
        Vec3 maxZ = lineZ.getMaxPosition();
        Vec3 minZ = lineZ.getMinPosition();
        lines.clear();
        lines.add(Line.createLine(new AABB(boxT.minX, boxT.minY, boxT.minZ, boxT.minX, boxT.maxY, boxT.minZ), pos));
        lines.add(Line.createLine(new AABB(boxT.minX, boxT.minY, boxT.maxZ, boxT.minX, boxT.maxY, boxT.maxZ), pos));
        lines.add(Line.createLine(new AABB(boxT.maxX, boxT.minY, boxT.minZ, boxT.maxX, boxT.maxY, boxT.minZ), pos));
        lines.add(Line.createLine(new AABB(boxT.maxX, boxT.minY, boxT.maxZ, boxT.maxX, boxT.maxY, boxT.maxZ), pos));
        Collections.sort(lines);
        AABB lineY = ((Line)lines.getFirst()).line;
        Vec3 maxY = lineY.getMaxPosition();
        Vec3 minY = lineY.getMinPosition();
        lines.clear();
        lines.add(Line.createLine(new AABB(boxT.minX, boxT.minY, boxT.minZ, boxT.maxX, boxT.minY, boxT.minZ), pos));
        lines.add(Line.createLine(new AABB(boxT.minX, boxT.minY, boxT.maxZ, boxT.maxX, boxT.minY, boxT.maxZ), pos));
        lines.add(Line.createLine(new AABB(boxT.minX, boxT.maxY, boxT.minZ, boxT.maxX, boxT.maxY, boxT.minZ), pos));
        lines.add(Line.createLine(new AABB(boxT.minX, boxT.maxY, boxT.maxZ, boxT.maxX, boxT.maxY, boxT.maxZ), pos));
        Collections.sort(lines);
        AABB lineX = ((Line)lines.getFirst()).line;
        Vec3 maxX = lineX.getMaxPosition();
        Vec3 minX = lineX.getMinPosition();
        lines.clear();
        Vec3 lineXPoint = this.calculateNearestPoint(minX, maxX, pos);
        Vec3 lineYPoint = this.calculateNearestPoint(minY, maxY, pos);
        Vec3 lineZPoint = this.calculateNearestPoint(minZ, maxZ, pos);
        poseStack.pushPose();
        poseStack.translate(-pos.x, -pos.y, -pos.z);
        this.drawText(poseStack, camera, new Vec3(lineXPoint.x, lineXPoint.y, lineXPoint.z), (Component)Component.literal((String)String.valueOf(lengthX)), this.textX, bufferSource);
        this.drawText(poseStack, camera, new Vec3(lineYPoint.x, lineYPoint.y, lineYPoint.z), (Component)Component.literal((String)String.valueOf(lengthY)), this.textY, bufferSource);
        this.drawText(poseStack, camera, new Vec3(lineZPoint.x, lineZPoint.y, lineZPoint.z), (Component)Component.literal((String)String.valueOf(lengthZ)), this.textZ, bufferSource);
        poseStack.popPose();
    }

    private Vec3 calculateNearestPoint(Vec3 min, Vec3 max, Vec3 pos) {
        Vec3 lineVec = max.subtract(min);
        double lineLengthSq = lineVec.lengthSqr();
        if (lineLengthSq < (double)1.0E-5f) {
            return min;
        }
        double lineLength = Math.sqrt(lineLengthSq);
        if (lineLength < 1.0) {
            return min.add(lineVec.scale(0.5));
        }
        Vec3 vecFromMinToPos = pos.subtract(min);
        double t = vecFromMinToPos.dot(lineVec) / lineLengthSq;
        double marginFraction = 0.5 / lineLength;
        double t_clamped = Mth.clamp((double)t, (double)marginFraction, (double)(1.0 - marginFraction));
        return min.add(lineVec.multiply(t_clamped, t_clamped, t_clamped));
    }

    private void drawText(PoseStack poseStack, Camera camera, Vec3 pos, Component length, DyeColor textColor, MultiBufferSource.BufferSource bufferSource) {
        Font font = Minecraft.getInstance().font;
        float size = Services.PLATFORM.getTextSize();
        poseStack.pushPose();
        poseStack.translate(pos.x, pos.y + (double)size * 5.0, pos.z);
        poseStack.mulPose(camera.rotation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.scale(-size, -size, -size);
        poseStack.translate((float)(-font.width((FormattedText)length)) / 2.0f, 0.0f, 0.0f);
        Matrix4f pose = poseStack.last().pose();
        font.drawInBatch(length, 0.0f, 0.0f, textColor.getTextColor(), false, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        poseStack.popPose();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
    }

    private record Line(AABB line, double distance) implements Comparable<Line>
    {
        public static Line createLine(AABB line, Vec3 pos) {
            return new Line(line, line.distanceToSqr(pos));
        }

        @Override
        public int compareTo(@NotNull Line l) {
            return Double.compare(this.distance, l.distance);
        }
    }
}

