/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class FluidItemRender {
    private final ResourceLocation texture;
    private final int referenceWidth;
    private final int referenceHeight;
    private int r = 255;
    private int g = 255;
    private int b = 255;
    private int a = 255;
    private Rect2i srcRect;
    private Rect2i destRect = new Rect2i(0, 0, 0, 0);
    private boolean blending = true;

    public FluidItemRender(ResourceLocation texture, int referenceWidth, int referenceHeight) {
        this.texture = texture;
        this.referenceWidth = referenceWidth;
        this.referenceHeight = referenceHeight;
    }

    public static FluidItemRender sprite(TextureAtlasSprite sprite) {
        int refSize = 0x3FFFFFFF;
        return new FluidItemRender(sprite.atlasLocation(), 0x3FFFFFFF, 0x3FFFFFFF).src((int)(sprite.getU0() * 1.0737418E9f), (int)(sprite.getV0() * 1.0737418E9f), (int)((sprite.getU1() - sprite.getU0()) * 1.0737418E9f), (int)((sprite.getV1() - sprite.getV0()) * 1.0737418E9f));
    }

    public FluidItemRender src(int x, int y, int w, int h) {
        this.srcRect = new Rect2i(x, y, w, h);
        return this;
    }

    public FluidItemRender dest(int x, int y, int w, int h) {
        this.destRect = new Rect2i(x, y, w, h);
        return this;
    }

    public FluidItemRender color(float r, float g, float b) {
        this.r = (int)(Mth.clamp((float)r, (float)0.0f, (float)1.0f) * 255.0f);
        this.g = (int)(Mth.clamp((float)g, (float)0.0f, (float)1.0f) * 255.0f);
        this.b = (int)(Mth.clamp((float)b, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public FluidItemRender opacity(float a) {
        this.a = (int)(Mth.clamp((float)a, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public FluidItemRender blending(boolean enable) {
        this.blending = enable;
        return this;
    }

    public FluidItemRender colorRgb(int packedRgb) {
        float r = (float)(packedRgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(packedRgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(packedRgb & 0xFF) / 255.0f;
        return this.color(r, g, b);
    }

    public void blit(PoseStack poseStack, int zIndex) {
        float maxU;
        float maxV;
        float minU;
        float minV;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        if (this.srcRect == null) {
            minV = 0.0f;
            minU = 0.0f;
            maxV = 1.0f;
            maxU = 1.0f;
        } else {
            minU = (float)this.srcRect.getX() / (float)this.referenceWidth;
            minV = (float)this.srcRect.getY() / (float)this.referenceHeight;
            maxU = (float)(this.srcRect.getX() + this.srcRect.getWidth()) / (float)this.referenceWidth;
            maxV = (float)(this.srcRect.getY() + this.srcRect.getHeight()) / (float)this.referenceHeight;
        }
        float x1 = this.destRect.getX();
        float y1 = this.destRect.getY();
        float x2 = x1;
        float y2 = y1;
        if (this.destRect.getWidth() != 0 && this.destRect.getHeight() != 0) {
            x2 += (float)this.destRect.getWidth();
            y2 += (float)this.destRect.getHeight();
        } else if (this.srcRect != null) {
            x2 += (float)this.srcRect.getWidth();
            y2 += (float)this.srcRect.getHeight();
        }
        Matrix4f matrix = poseStack.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix, x1, y2, (float)zIndex).setUv(minU, maxV).setColor(this.r, this.g, this.b, this.a);
        bufferbuilder.addVertex(matrix, x2, y2, (float)zIndex).setUv(maxU, maxV).setColor(this.r, this.g, this.b, this.a);
        bufferbuilder.addVertex(matrix, x2, y1, (float)zIndex).setUv(maxU, minV).setColor(this.r, this.g, this.b, this.a);
        bufferbuilder.addVertex(matrix, x1, y1, (float)zIndex).setUv(minU, minV).setColor(this.r, this.g, this.b, this.a);
        if (this.blending) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
        } else {
            RenderSystem.disableBlend();
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void renderFluid(FluidStack fluidStack, PoseStack poseStack, int x, int y, int z) {
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(attributes.getStillTexture(fluidStack));
        FluidItemRender.sprite(sprite).colorRgb(attributes.getTintColor(fluidStack)).blending(false).dest(x, y, 16, 16).blit(poseStack, z);
    }
}

