/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.screen;

import com.google.common.collect.Lists;
import committee.nova.mods.avaritia.api.client.screen.component.OperationButton;
import committee.nova.mods.avaritia.api.client.screen.component.OperationButtonType;
import committee.nova.mods.avaritia.api.client.screen.component.Text;
import committee.nova.mods.avaritia.api.client.util.GuiUtils;
import committee.nova.mods.avaritia.api.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;

public class EntitySelectScreen
extends Screen {
    private static final Quaternionf ARMOR_STAND_ANGLE = new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI);
    private static final Logger LOGGER = LogManager.getLogger();
    private final int itemPerLine = 5;
    private final int maxLine = 5;
    private final Screen previousScreen;
    private final Consumer<EntityType<?>> onDataReceived1;
    private final Supplier<Boolean> shouldClose;
    private EditBox inputField;
    private String inputFieldText = "";
    private final List<EntityType<?>> itemList = new ArrayList();
    private final Map<Integer, OperationButton> OP_BUTTONS = new HashMap<Integer, OperationButton>();
    private final List<OperationButton> ITEM_BUTTONS = new ArrayList<OperationButton>();
    private String selectedEntityId;
    private EntityType<?> currentEntity;
    private int bgX;
    private int bgY;
    private final double margin = 3.0;
    private double itemBgX = (double)this.bgX + 3.0;
    private double itemBgY = this.bgY + 20;
    private int scrollOffset = 0;
    private double mouseDownX = -1.0;
    private double mouseDownY = -1.0;
    private double scrollOffsetOld;
    private double outScrollX;
    private double outScrollY;
    private int outScrollWidth = 5;
    private int outScrollHeight;
    private double inScrollHeight;
    private double inScrollY;

    public EntitySelectScreen(@NonNull Screen callbackScreen, @NonNull Consumer<EntityType<?>> onDataReceived) {
        this(callbackScreen, onDataReceived, null);
        if (callbackScreen == null) {
            throw new NullPointerException("callbackScreen is marked non-null but is null");
        }
        if (onDataReceived == null) {
            throw new NullPointerException("onDataReceived is marked non-null but is null");
        }
    }

    public EntitySelectScreen(@NonNull Screen callbackScreen, @NonNull Consumer<EntityType<?>> onDataReceived, Supplier<Boolean> shouldClose) {
        super((Component)Component.literal((String)"SelectScreen"));
        if (callbackScreen == null) {
            throw new NullPointerException("callbackScreen is marked non-null but is null");
        }
        if (onDataReceived == null) {
            throw new NullPointerException("onDataReceived is marked non-null but is null");
        }
        this.previousScreen = callbackScreen;
        this.onDataReceived1 = onDataReceived;
        this.currentEntity = EntityType.BEE;
        this.selectedEntityId = EntityType.BEE.getDescriptionId();
        this.shouldClose = shouldClose;
    }

    protected void init() {
        if (this.shouldClose != null && Boolean.TRUE.equals(this.shouldClose.get())) {
            Minecraft.getInstance().setScreen(this.previousScreen);
        }
        this.updateSearchResults();
        this.updateLayout();
        this.inputField = GuiUtils.newTextFieldWidget(this.font, this.bgX, this.bgY, 180, 15, (Component)Component.literal((String)""));
        this.inputField.setValue(this.inputFieldText);
        this.addRenderableWidget((GuiEventListener)this.inputField);
        this.addRenderableWidget((GuiEventListener)GuiUtils.newButton((int)((double)(this.bgX + 90) + this.margin), (int)((double)this.bgY + 178.0), (int)(90.0 - this.margin * 2.0), 20, (Component)GuiUtils.textToComponent(Text.i18n("\u63d0\u4ea4", new Object[0])), button -> {
            if (this.currentEntity == null) {
                Minecraft.getInstance().setScreen(this.previousScreen);
            } else if (this.onDataReceived1 != null) {
                this.onDataReceived1.accept(this.currentEntity);
                Minecraft.getInstance().setScreen(this.previousScreen);
            }
        }));
        this.addRenderableWidget((GuiEventListener)GuiUtils.newButton((int)((double)this.bgX + this.margin), (int)((double)this.bgY + 178.0), (int)(90.0 - this.margin * 2.0), 20, (Component)GuiUtils.textToComponent(Text.i18n("\u53d6\u6d88", new Object[0])), button -> Minecraft.getInstance().setScreen(this.previousScreen)));
    }

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        GuiUtils.fill(graphics, (int)((double)this.bgX - this.margin), (int)((double)this.bgY - this.margin), (int)(180.0 + this.margin * 2.0), 206, -859388218, 2);
        int n = (int)(this.itemBgX - this.margin);
        int n2 = (int)(this.itemBgY - this.margin);
        Objects.requireNonNull(this);
        int n3 = (int)((28.0 + this.margin) * 5.0 + this.margin);
        Objects.requireNonNull(this);
        GuiUtils.fillOutLine(graphics, n, n2, n3, (int)((28.0 + this.margin) * 5.0 + this.margin), 1, -16777216, 1);
        super.render(graphics, mouseX, mouseY, delta);
        this.inputFieldText = this.inputField.getValue();
        this.renderButton(graphics, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.setScrollOffset((double)this.getScrollOffset() - scrollY);
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AtomicBoolean flag = new AtomicBoolean(false);
        if (button == 3) {
            Minecraft.getInstance().setScreen(this.previousScreen);
            flag.set(true);
        } else if (button == 0 || button == 1) {
            this.OP_BUTTONS.forEach((key, value) -> {
                if (value.isHovered()) {
                    value.setPressed(true);
                    if (key.intValue() == OperationButtonType.SLIDER.getCode()) {
                        this.scrollOffsetOld = this.getScrollOffset();
                        this.mouseDownX = mouseX;
                        this.mouseDownY = mouseY;
                    }
                }
            });
            this.ITEM_BUTTONS.forEach(bt -> bt.setPressed(bt.isHovered()));
        }
        return flag.get() ? flag.get() : super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        AtomicBoolean flag = new AtomicBoolean(false);
        AtomicBoolean updateSearchResults = new AtomicBoolean(false);
        if (button == 0 || button == 1) {
            this.ITEM_BUTTONS.forEach(bt -> {
                if (bt.isHovered() && bt.isPressed()) {
                    this.handleItem((OperationButton)bt, button, flag);
                }
                bt.setPressed(false);
            });
            this.mouseDownX = -1.0;
            this.mouseDownY = -1.0;
            if (updateSearchResults.get()) {
                this.updateSearchResults();
            }
        }
        return flag.get() ? flag.get() : super.mouseReleased(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.OP_BUTTONS.forEach((key, value) -> {
            value.setHovered(value.isMouseOverEx(mouseX, mouseY));
            if (key.intValue() == OperationButtonType.SLIDER.getCode() && value.isPressed() && this.mouseDownX != -1.0 && this.mouseDownY != -1.0) {
                double scale = Math.ceil((double)(this.itemList.size() - 25) / 5.0) / (double)(this.outScrollHeight - 2);
                this.setScrollOffset(this.scrollOffsetOld + (mouseY - this.mouseDownY) * scale);
            }
        });
        this.ITEM_BUTTONS.forEach(bt -> bt.setHovered(bt.isMouseOverEx(mouseX, mouseY)));
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || keyCode == 259 && !this.inputField.isFocused()) {
            Minecraft.getInstance().setScreen(this.previousScreen);
            return true;
        }
        if ((keyCode == 257 || keyCode == 335) && this.inputField.isFocused()) {
            this.updateSearchResults();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private List<EntityType<?>> getAllItemList() {
        return new ArrayList(BuiltInRegistries.ENTITY_TYPE.stream().toList());
    }

    private void updateLayout() {
        this.bgX = this.width / 2 - 92;
        this.bgY = this.height / 2 - 65;
        this.itemBgX = (double)this.bgX + 3.0;
        this.itemBgY = this.bgY + 20;
        this.OP_BUTTONS.put(OperationButtonType.SLIDER.getCode(), new OperationButton(OperationButtonType.SLIDER.getCode(), context -> {
            double bgWidth = 155.0;
            double bgHeight = 152.0;
            this.outScrollX = this.itemBgX + bgWidth + 2.0;
            this.outScrollY = this.itemBgY - this.margin + 1.0;
            this.outScrollWidth = 5;
            this.outScrollHeight = (int)(bgHeight + this.margin + 1.0);
            double inScrollWidthScale = this.itemList.size() > 25 ? 25.0 / (double)this.itemList.size() : 1.0;
            double outLine = Math.max((int)Math.ceil((double)(this.itemList.size() - 25) / 5.0), 0);
            double outCellHeight = outLine == 0.0 ? 0.0 : (1.0 - inScrollWidthScale) * (double)(this.outScrollHeight - 2) / outLine;
            double inScrollTopHeight = (double)this.getScrollOffset() * outCellHeight;
            this.inScrollHeight = Math.max(2.0, (double)(this.outScrollHeight - 2) * inScrollWidthScale);
            this.inScrollY = this.outScrollY + inScrollTopHeight + 1.0;
            GuiUtils.fill(context.graphics(), (int)this.outScrollX, (int)this.outScrollY, this.outScrollWidth, this.outScrollHeight, -870112477);
            int color = context.button().isHovered() ? -855638017 : -863270005;
            GuiUtils.fill(context.graphics(), (int)this.outScrollX, (int)Math.ceil(this.inScrollY), this.outScrollWidth, (int)this.inScrollHeight, color);
            context.button().setX(this.outScrollX).setY(this.outScrollY).setWidth(this.outScrollWidth).setHeight(this.outScrollHeight);
        }));
        this.ITEM_BUTTONS.clear();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.ITEM_BUTTONS.add(new OperationButton(5 * i + j, context -> {
                    int i1 = context.button().getOperation() / 5;
                    int j1 = context.button().getOperation() % 5;
                    int index = ((this.itemList.size() > 25 ? this.getScrollOffset() : 0) + i1) * 5 + j1;
                    if (index >= 0 && index < this.itemList.size()) {
                        EntityType<?> entityType = this.itemList.get(index);
                        double itemX = this.itemBgX + (double)j1 * 31.0;
                        double itemY = this.itemBgY + (double)i1 * 31.0;
                        int bgColor = context.button().isHovered() || entityType.getDescriptionId().equalsIgnoreCase(this.getSelectedEntityId().toString()) ? -293819524 : -294621072;
                        context.button().setX(itemX - 1.0).setY(itemY - 1.0).setWidth(30.0).setHeight(30.0).setId(entityType.getDescriptionId());
                        GuiUtils.fill(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), bgColor);
                        context.button().setCustomPopupFunction(() -> {
                            if (context.button().isHovered()) {
                                ArrayList arrayList = Lists.newArrayList((Object[])new Component[]{entityType.getDescription()});
                            }
                        });
                    } else {
                        context.button().setX(0.0).setY(0.0).setWidth(0.0).setHeight(0.0).setId("");
                    }
                }));
            }
        }
    }

    private void updateSearchResults() {
        String s = this.inputField == null ? null : this.inputField.getValue();
        this.itemList.clear();
        if (!StringUtils.isNotNullOrEmpty(s)) {
            this.itemList.addAll(new ArrayList(this.getAllItemList()));
        }
        this.setScrollOffset(0.0);
    }

    private void setScrollOffset(double offset) {
        this.scrollOffset = (int)Math.max(Math.min(offset, (double)((int)Math.ceil((double)(this.itemList.size() - 25) / 5.0))), 0.0);
    }

    private void renderButton(GuiGraphics graphics, int mouseX, int mouseY) {
        for (OperationButton button : this.OP_BUTTONS.values()) {
            button.render(graphics, mouseX, mouseY);
        }
        for (OperationButton button : this.ITEM_BUTTONS) {
            button.render(graphics, mouseX, mouseY);
        }
        for (OperationButton button : this.OP_BUTTONS.values()) {
            button.renderPopup(graphics, this.font, mouseX, mouseY);
        }
        for (OperationButton button : this.ITEM_BUTTONS) {
            button.renderPopup(graphics, this.font, mouseX, mouseY);
        }
    }

    private void handleItem(OperationButton bt, int button, AtomicBoolean flag) {
        if (button == 0) {
            this.selectedEntityId = bt.getId();
            if (StringUtils.isNotNullOrEmpty(this.selectedEntityId)) {
                flag.set(true);
            }
        }
    }

    @Generated
    public String getSelectedEntityId() {
        return this.selectedEntityId;
    }

    @Generated
    public int getScrollOffset() {
        return this.scrollOffset;
    }
}

