/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.screen;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.client.screen.StringInputScreen;
import committee.nova.mods.avaritia.api.client.screen.component.OperationButton;
import committee.nova.mods.avaritia.api.client.screen.component.OperationButtonType;
import committee.nova.mods.avaritia.api.client.screen.component.Text;
import committee.nova.mods.avaritia.api.client.util.GuiUtils;
import committee.nova.mods.avaritia.api.utils.ItemUtils;
import committee.nova.mods.avaritia.api.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemSelectScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int itemPerLine = 9;
    private final int maxLine = 5;
    private final Screen previousScreen;
    private final Consumer<ItemStack> onDataReceived1;
    private final Supplier<Boolean> shouldClose;
    private final ResourceKey<CreativeModeTab> tabs;
    private final boolean useInventoryMode;
    private boolean inventoryMode = false;
    private EditBox inputField;
    private String inputFieldText = "";
    private final List<ItemStack> itemList = new ArrayList<ItemStack>();
    private final Map<Integer, OperationButton> OP_BUTTONS = new HashMap<Integer, OperationButton>();
    private final List<OperationButton> ITEM_BUTTONS = new ArrayList<OperationButton>();
    private final Set<TagKey<Item>> visibleTags = new HashSet<TagKey<Item>>();
    private String selectedItemId;
    private ItemStack currentItem;
    private int bgX;
    private int bgY;
    private final double margin = 3.0;
    private double itemBgX = (double)this.bgX + 3.0;
    private double itemBgY = this.bgY + 20;
    private int scrollOffset = 0;
    private double mouseDownX = -1.0;
    private double mouseDownY = -1.0;
    private double scrollOffsetOld;
    private double outScrollX;
    private double outScrollY;
    private int outScrollWidth = 5;
    private int outScrollHeight;
    private double inScrollHeight;
    private double inScrollY;

    public ItemSelectScreen(@NonNull Screen callbackScreen, @NonNull Consumer<ItemStack> onDataReceived, @NonNull ItemStack defaultItem) {
        this(callbackScreen, onDataReceived, defaultItem, null, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INVENTORY, true);
        if (callbackScreen == null) {
            throw new NullPointerException("callbackScreen is marked non-null but is null");
        }
        if (onDataReceived == null) {
            throw new NullPointerException("onDataReceived is marked non-null but is null");
        }
        if (defaultItem == null) {
            throw new NullPointerException("defaultItem is marked non-null but is null");
        }
    }

    public ItemSelectScreen(@NonNull Screen callbackScreen, @NonNull Consumer<ItemStack> onDataReceived, @NonNull ItemStack defaultItem, Supplier<Boolean> shouldClose, ResourceKey<CreativeModeTab> tabs, boolean useInventoryMode) {
        super((Component)Component.literal((String)"SelectScreen"));
        if (callbackScreen == null) {
            throw new NullPointerException("callbackScreen is marked non-null but is null");
        }
        if (onDataReceived == null) {
            throw new NullPointerException("onDataReceived is marked non-null but is null");
        }
        if (defaultItem == null) {
            throw new NullPointerException("defaultItem is marked non-null but is null");
        }
        this.previousScreen = callbackScreen;
        this.onDataReceived1 = onDataReceived;
        this.currentItem = defaultItem;
        this.selectedItemId = ItemUtils.getId(defaultItem);
        this.shouldClose = shouldClose;
        this.tabs = tabs;
        this.useInventoryMode = useInventoryMode;
    }

    protected void init() {
        if (this.shouldClose != null && Boolean.TRUE.equals(this.shouldClose.get())) {
            Minecraft.getInstance().setScreen(this.previousScreen);
        }
        this.updateSearchResults();
        this.updateLayout();
        this.inputField = GuiUtils.newTextFieldWidget(this.font, this.bgX, this.bgY, 180, 15, (Component)Component.literal((String)""));
        this.inputField.setValue(this.inputFieldText);
        this.addRenderableWidget((GuiEventListener)this.inputField);
        this.addRenderableWidget((GuiEventListener)GuiUtils.newButton((int)((double)(this.bgX + 90) + this.margin), (int)((double)this.bgY + 118.0), (int)(90.0 - this.margin * 2.0), 20, (Component)GuiUtils.textToComponent(Text.i18n("\u63d0\u4ea4", new Object[0])), button -> {
            if (this.currentItem == null) {
                Minecraft.getInstance().setScreen(this.previousScreen);
            } else if (this.onDataReceived1 != null) {
                this.onDataReceived1.accept(this.currentItem);
                Minecraft.getInstance().setScreen(this.previousScreen);
            }
        }));
        this.addRenderableWidget((GuiEventListener)GuiUtils.newButton((int)((double)this.bgX + this.margin), (int)((double)this.bgY + 118.0), (int)(90.0 - this.margin * 2.0), 20, (Component)GuiUtils.textToComponent(Text.i18n("\u53d6\u6d88", new Object[0])), button -> Minecraft.getInstance().setScreen(this.previousScreen)));
    }

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        GuiUtils.fill(graphics, (int)((double)this.bgX - this.margin), (int)((double)this.bgY - this.margin), (int)(180.0 + this.margin * 2.0), 146, -859388218, 2);
        GuiUtils.fillOutLine(graphics, (int)(this.itemBgX - this.margin), (int)(this.itemBgY - this.margin), (int)((16.0 + this.margin) * (double)this.itemPerLine + this.margin), (int)((16.0 + this.margin) * (double)this.maxLine + this.margin), 1, -16777216, 1);
        super.render(graphics, mouseX, mouseY, delta);
        this.inputFieldText = this.inputField.getValue();
        this.renderButton(graphics, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setScrollOffset((double)this.getScrollOffset() - deltaY);
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AtomicBoolean flag = new AtomicBoolean(false);
        if (button == 3) {
            Minecraft.getInstance().setScreen(this.previousScreen);
            flag.set(true);
        } else if (button == 0 || button == 1) {
            this.OP_BUTTONS.forEach((key, value) -> {
                if (value.isHovered()) {
                    value.setPressed(true);
                    if (key.intValue() == OperationButtonType.SLIDER.getCode()) {
                        this.scrollOffsetOld = this.getScrollOffset();
                        this.mouseDownX = mouseX;
                        this.mouseDownY = mouseY;
                    }
                }
            });
            this.ITEM_BUTTONS.forEach(bt -> bt.setPressed(bt.isHovered()));
        }
        return flag.get() ? flag.get() : super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        AtomicBoolean flag = new AtomicBoolean(false);
        AtomicBoolean updateSearchResults = new AtomicBoolean(false);
        if (button == 0 || button == 1) {
            this.OP_BUTTONS.forEach((key, value) -> {
                if (value.isHovered() && value.isPressed()) {
                    this.handleOperation((OperationButton)value, button, flag, updateSearchResults);
                }
                value.setPressed(false);
            });
            this.ITEM_BUTTONS.forEach(bt -> {
                if (bt.isHovered() && bt.isPressed()) {
                    this.handleItem((OperationButton)bt, button, flag);
                }
                bt.setPressed(false);
            });
            this.mouseDownX = -1.0;
            this.mouseDownY = -1.0;
            if (updateSearchResults.get()) {
                this.updateSearchResults();
            }
        }
        return flag.get() ? flag.get() : super.mouseReleased(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.OP_BUTTONS.forEach((key, value) -> {
            value.setHovered(value.isMouseOverEx(mouseX, mouseY));
            if (key.intValue() == OperationButtonType.SLIDER.getCode() && value.isPressed() && this.mouseDownX != -1.0 && this.mouseDownY != -1.0) {
                double scale = Math.ceil((double)(this.itemList.size() - 45) / 9.0) / (double)(this.outScrollHeight - 2);
                this.setScrollOffset(this.scrollOffsetOld + (mouseY - this.mouseDownY) * scale);
            }
        });
        this.ITEM_BUTTONS.forEach(bt -> bt.setHovered(bt.isMouseOverEx(mouseX, mouseY)));
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || keyCode == 259 && !this.inputField.isFocused()) {
            Minecraft.getInstance().setScreen(this.previousScreen);
            return true;
        }
        if ((keyCode == 257 || keyCode == 335) && this.inputField.isFocused()) {
            this.updateSearchResults();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private NonNullList<ItemStack> getAllItemList() {
        NonNullList list = NonNullList.create();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)player.connection.enabledFeatures(), (boolean)true, (HolderLookup.Provider)player.level().registryAccess());
        }
        list.addAll(((CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.getOrThrow(this.tabs)).getDisplayItems());
        return list;
    }

    private List<ItemStack> getPlayerItemList() {
        List<Object> result = new ArrayList<ItemStack>();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            result.addAll((Collection<ItemStack>)player.getInventory().items);
            result.addAll((Collection<ItemStack>)player.getInventory().armor);
            result.addAll((Collection<ItemStack>)player.getInventory().offhand);
            result = result.stream().filter(itemStack -> !itemStack.isEmpty() && itemStack.getItem() != Items.AIR).collect(Collectors.toList());
        }
        return result;
    }

    private void updateLayout() {
        this.bgX = this.width / 2 - 92;
        this.bgY = this.height / 2 - 65;
        this.itemBgX = (double)this.bgX + 3.0;
        this.itemBgY = this.bgY + 20;
        this.OP_BUTTONS.put(OperationButtonType.TYPE.getCode(), new OperationButton(OperationButtonType.TYPE.getCode(), context -> {
            int lineColor = context.button().isHovered() ? -285212673 : -301989888;
            GuiUtils.fill(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), -294621072, 2);
            GuiUtils.fillOutLine(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), 1, lineColor, 2);
            ItemStack itemStack = new ItemStack((ItemLike)(this.inventoryMode ? Items.CHEST : Items.COMPASS));
            context.graphics().renderItem(itemStack, (int)context.button().getX() + 2, (int)context.button().getY() + 2);
            Text text = this.inventoryMode ? Text.i18n("\u5217\u51fa\u6a21\u5f0f\n\u7269\u54c1\u680f (%s)", this.getPlayerItemList().size()) : Text.i18n("\u5217\u51fa\u6a21\u5f0f\n\u6240\u6709\u7269\u54c1 (%s)", this.getAllItemList().size());
            context.button().setTooltip(text);
        }).setX((double)(this.bgX - 16 - 2) - 3.0 - 3.0).setY((double)this.bgY + 3.0).setWidth(20.0).setHeight(20.0));
        this.OP_BUTTONS.put(OperationButtonType.ITEM.getCode(), new OperationButton(OperationButtonType.ITEM.getCode(), context -> {
            int lineColor = context.button().isHovered() ? -285212673 : -301989888;
            GuiUtils.fill(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), -294621072, 2);
            GuiUtils.fillOutLine(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), 1, lineColor, 2);
            context.graphics().renderItem(this.currentItem, (int)context.button().getX() + 2, (int)context.button().getY() + 2);
            context.button().setTooltip(GuiUtils.componentToText(this.currentItem.getHoverName().copy()));
        }).setX((double)(this.bgX - 16 - 2) - 3.0 - 3.0).setY((double)this.bgY + 3.0 + 16.0 + 4.0 + 1.0).setWidth(20.0).setHeight(20.0));
        this.OP_BUTTONS.put(OperationButtonType.COUNT.getCode(), new OperationButton(OperationButtonType.COUNT.getCode(), context -> {
            int lineColor = context.button().isHovered() ? -285212673 : -301989888;
            GuiUtils.fill(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), -294621072, 2);
            GuiUtils.fillOutLine(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), 1, lineColor, 2);
            ItemStack itemStack = new ItemStack((ItemLike)Items.WRITABLE_BOOK);
            context.graphics().renderItem(itemStack, (int)context.button().getX() + 2, (int)context.button().getY() + 2);
            Text text = Text.i18n("\u8bbe\u7f6e\u6570\u91cf\n\u5f53\u524d %s", this.currentItem.getCount());
            context.button().setTooltip(text);
        }).setX((double)(this.bgX - 16 - 2) - 3.0 - 3.0).setY((double)this.bgY + 3.0 + 42.0).setWidth(20.0).setHeight(20.0));
        this.OP_BUTTONS.put(OperationButtonType.NBT.getCode(), new OperationButton(OperationButtonType.NBT.getCode(), context -> {
            int lineColor = context.button().isHovered() ? -285212673 : -301989888;
            GuiUtils.fill(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), -294621072, 2);
            GuiUtils.fillOutLine(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), 1, lineColor, 2);
            ItemStack itemStack = new ItemStack((ItemLike)Items.NAME_TAG);
            context.graphics().renderItem(itemStack, (int)context.button().getX() + 2, (int)context.button().getY() + 2);
            Text text = Text.i18n("\u7f16\u8f91NBT", new Object[0]);
            context.button().setTooltip(text);
        }).setX((double)(this.bgX - 16 - 2) - 3.0 - 3.0).setY((double)this.bgY + 3.0 + 63.0).setWidth(20.0).setHeight(20.0));
        this.OP_BUTTONS.put(OperationButtonType.SLIDER.getCode(), new OperationButton(OperationButtonType.SLIDER.getCode(), context -> {
            double bgWidth = 171.0;
            double bgHeight = 92.0;
            this.outScrollX = this.itemBgX + bgWidth + 2.0;
            this.outScrollY = this.itemBgY - this.margin + 1.0;
            this.outScrollWidth = 5;
            this.outScrollHeight = (int)(bgHeight + this.margin + 1.0);
            double inScrollWidthScale = this.itemList.size() > 45 ? 45.0 / (double)this.itemList.size() : 1.0;
            double outLine = Math.max((int)Math.ceil((double)(this.itemList.size() - 45) / 9.0), 0);
            double outCellHeight = outLine == 0.0 ? 0.0 : (1.0 - inScrollWidthScale) * (double)(this.outScrollHeight - 2) / outLine;
            double inScrollTopHeight = (double)this.getScrollOffset() * outCellHeight;
            this.inScrollHeight = Math.max(2.0, (double)(this.outScrollHeight - 2) * inScrollWidthScale);
            this.inScrollY = this.outScrollY + inScrollTopHeight + 1.0;
            GuiUtils.fill(context.graphics(), (int)this.outScrollX, (int)this.outScrollY, this.outScrollWidth, this.outScrollHeight, -870112477);
            int color = context.button().isHovered() ? -855638017 : -863270005;
            GuiUtils.fill(context.graphics(), (int)this.outScrollX, (int)Math.ceil(this.inScrollY), this.outScrollWidth, (int)this.inScrollHeight, color);
            context.button().setX(this.outScrollX).setY(this.outScrollY).setWidth(this.outScrollWidth).setHeight(this.outScrollHeight);
        }));
        this.ITEM_BUTTONS.clear();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.ITEM_BUTTONS.add(new OperationButton(9 * i + j, context -> {
                    int i1 = context.button().getOperation() / 9;
                    int j1 = context.button().getOperation() % 9;
                    int index = ((this.itemList.size() > 45 ? this.getScrollOffset() : 0) + i1) * 9 + j1;
                    if (index >= 0 && index < this.itemList.size()) {
                        ItemStack itemStack = this.itemList.get(index);
                        double itemX = this.itemBgX + (double)j1 * 19.0;
                        double itemY = this.itemBgY + (double)i1 * 19.0;
                        int bgColor = context.button().isHovered() || ItemUtils.getId(itemStack).equalsIgnoreCase(this.getSelectedItemId()) ? -293819524 : -294621072;
                        context.button().setX(itemX - 1.0).setY(itemY - 1.0).setWidth(18.0).setHeight(18.0).setId(ItemUtils.getId(itemStack));
                        GuiUtils.fill(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), bgColor);
                        context.graphics().renderItem(itemStack, (int)context.button().getX() + 1, (int)context.button().getY() + 1);
                        context.button().setCustomPopupFunction(() -> {
                            if (context.button().isHovered()) {
                                List list = itemStack.getTooltipLines(Item.TooltipContext.of((HolderLookup.Provider)this.minecraft.level.registryAccess()), (Player)Minecraft.getInstance().player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                                ArrayList list1 = Lists.newArrayList((Iterable)list);
                                Item item = itemStack.getItem();
                                this.visibleTags.forEach(itemITag -> {
                                    if (itemStack.is(itemITag)) {
                                        list1.add(1, Component.literal((String)("#" + String.valueOf(itemITag.location()))).withStyle(ChatFormatting.DARK_PURPLE));
                                    }
                                });
                                for (CreativeModeTab modeTab : CreativeModeTabs.allTabs()) {
                                    if (!modeTab.contains(itemStack)) continue;
                                    list1.add(1, modeTab.getDisplayName().copy().withStyle(ChatFormatting.BLUE));
                                }
                                context.graphics().renderTooltip(this.font, (List)list1, itemStack.getTooltipImage(), itemStack, (int)context.mouseX(), (int)context.mouseY());
                            }
                        });
                    } else {
                        context.button().setX(0.0).setY(0.0).setWidth(0.0).setHeight(0.0).setId("");
                    }
                }));
            }
        }
    }

    private void updateSearchResults() {
        String s = this.inputField == null ? null : this.inputField.getValue();
        this.itemList.clear();
        this.visibleTags.clear();
        if (StringUtils.isNotNullOrEmpty(s)) {
            ClientPacketListener clientpacketlistener = this.minecraft.getConnection();
            if (clientpacketlistener != null) {
                SearchTree isearchtree;
                SessionSearchTrees sessionsearchtrees = clientpacketlistener.searchTrees();
                if (s.startsWith("#")) {
                    s = s.substring(1);
                    isearchtree = sessionsearchtrees.creativeTagSearch();
                    this.updateVisibleTags(s);
                } else {
                    isearchtree = sessionsearchtrees.creativeNameSearch();
                }
                this.itemList.addAll(isearchtree.search(s.toLowerCase(Locale.ROOT)));
            }
        } else {
            this.itemList.addAll(new ArrayList<ItemStack>(this.inventoryMode ? this.getPlayerItemList() : this.getAllItemList()));
        }
        this.setScrollOffset(0.0);
    }

    private void updateVisibleTags(String string) {
        Predicate<ResourceLocation> predicate;
        int i = string.indexOf(58);
        if (i == -1) {
            predicate = resourceLocation -> resourceLocation.getPath().contains(string);
        } else {
            String s = string.substring(0, i).trim();
            String s1 = string.substring(i + 1).trim();
            predicate = resourceLocation -> resourceLocation.getNamespace().contains(s) && resourceLocation.getPath().contains(s1);
        }
        BuiltInRegistries.ITEM.getTagNames().filter(tagKey -> predicate.test(tagKey.location())).forEach(this.visibleTags::add);
    }

    private void setScrollOffset(double offset) {
        this.scrollOffset = (int)Math.max(Math.min(offset, (double)((int)Math.ceil((double)(this.itemList.size() - 45) / 9.0))), 0.0);
    }

    private void renderButton(GuiGraphics graphics, int mouseX, int mouseY) {
        for (OperationButton button : this.OP_BUTTONS.values()) {
            button.render(graphics, mouseX, mouseY);
        }
        for (OperationButton button : this.ITEM_BUTTONS) {
            button.render(graphics, mouseX, mouseY);
        }
        for (OperationButton button : this.OP_BUTTONS.values()) {
            button.renderPopup(graphics, this.font, mouseX, mouseY);
        }
        for (OperationButton button : this.ITEM_BUTTONS) {
            button.renderPopup(graphics, this.font, mouseX, mouseY);
        }
    }

    private void handleItem(OperationButton bt, int button, AtomicBoolean flag) {
        if (button == 0) {
            this.selectedItemId = bt.getId();
            if (StringUtils.isNotNullOrEmpty(this.selectedItemId)) {
                this.currentItem = ItemUtils.getItemStack(this.selectedItemId);
                this.currentItem.setCount(1);
                flag.set(true);
            }
        }
    }

    private void handleOperation(OperationButton bt, int button, AtomicBoolean flag, AtomicBoolean updateSearchResults) {
        if (this.useInventoryMode && bt.getOperation() == OperationButtonType.TYPE.getCode()) {
            this.inventoryMode = !this.inventoryMode;
            updateSearchResults.set(true);
            flag.set(true);
        } else if (bt.getOperation() == OperationButtonType.ITEM.getCode()) {
            String itemRewardJsonString = ItemUtils.serialize(this.currentItem).toString();
            Minecraft.getInstance().setScreen((Screen)new StringInputScreen((Screen)this, Text.i18n("\u8bf7\u8f93\u5165\u7269\u54c1Json", new Object[0]).setShadow(true), Text.i18n("\u8bf7\u8f93\u5165", new Object[0]), "", itemRewardJsonString, input -> {
                String result = "";
                if (StringUtils.isNotNullOrEmpty(input)) {
                    ItemStack itemStack;
                    try {
                        JsonObject jsonObject = (JsonObject)Const.GSON.fromJson(input, JsonObject.class);
                        itemStack = ItemUtils.deserialize(jsonObject);
                    }
                    catch (Exception e) {
                        LOGGER.error("Invalid Json: {}", input);
                        itemStack = null;
                    }
                    if (itemStack != null && itemStack.getItem() != Items.AIR) {
                        this.currentItem = itemStack;
                        this.selectedItemId = ItemUtils.getId(this.currentItem);
                    } else {
                        result = String.format("\u7269\u54c1Json[%s]\u8f93\u5165\u6709\u8bef", input);
                    }
                }
                return result;
            }));
        } else if (bt.getOperation() == OperationButtonType.COUNT.getCode()) {
            Minecraft.getInstance().setScreen((Screen)new StringInputScreen((Screen)this, Text.i18n("\u8bf7\u8f93\u5165\u7269\u54c1\u6570\u91cf", new Object[0]).setShadow(true), Text.i18n("\u8bf7\u8f93\u5165", new Object[0]), "\\d{0,4}", String.valueOf(this.currentItem.getCount()), input -> {
                String result = "";
                if (StringUtils.isNotNullOrEmpty(input)) {
                    int count = StringUtils.toInt(input);
                    if (count > 0 && count <= 2880) {
                        this.currentItem.setCount(count);
                    } else {
                        result = String.format("\u7269\u54c1\u6570\u91cf[%s]\u8f93\u5165\u6709\u8bef", input);
                    }
                }
                return result;
            }));
        } else if (bt.getOperation() == OperationButtonType.NBT.getCode()) {
            String itemNbtJsonString = ItemUtils.getNbtString(this.currentItem);
            Minecraft.getInstance().setScreen((Screen)new StringInputScreen((Screen)this, Text.i18n("\u8bf7\u8f93\u5165\u7269\u54c1NBT", new Object[0]).setShadow(true), Text.i18n("\u8bf7\u8f93\u5165", new Object[0]), "", itemNbtJsonString, input -> {
                String result = "";
                if (StringUtils.isNotNullOrEmpty(input)) {
                    ItemStack itemStack;
                    try {
                        itemStack = ItemUtils.getItemStack(ItemUtils.getId(this.currentItem.getItem()) + input, true);
                        itemStack.setCount(this.currentItem.getCount());
                    }
                    catch (Exception e) {
                        LOGGER.error("Invalid NBT: {}", input);
                        itemStack = null;
                    }
                    if (itemStack != null) {
                        this.currentItem = itemStack;
                        this.selectedItemId = ItemUtils.getId(this.currentItem);
                    } else {
                        result = String.format("\u7269\u54c1NBT[%s]\u8f93\u5165\u6709\u8bef", input);
                    }
                }
                return result;
            }));
        }
    }

    @Generated
    public String getSelectedItemId() {
        return this.selectedItemId;
    }

    @Generated
    public int getScrollOffset() {
        return this.scrollOffset;
    }
}

