/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;

public class ResourceUtils {
    public static InputStream getResourceAsStream(ResourceLocation resource) throws IOException {
        return ResourceUtils.getResource(resource).open();
    }

    public static ReloadableResourceManager getResourceManager() {
        return (ReloadableResourceManager)Minecraft.getInstance().getResourceManager();
    }

    public static Resource getResource(String location) throws IOException {
        return ResourceUtils.getResource(ResourceLocation.tryParse((String)location));
    }

    public static Resource getResource(ResourceLocation location) throws IOException {
        return ResourceUtils.getResourceManager().getResourceOrThrow(location);
    }

    public static void registerReloadListener(ResourceManagerReloadListener reloadListener) {
        ResourceUtils.getResourceManager().registerReloadListener((PreparableReloadListener)reloadListener);
    }

    public static List<String> loadResource(ResourceProvider resourceProvider, ResourceLocation loc) {
        List<String> list;
        block8: {
            Resource resource = resourceProvider.getResourceOrThrow(loc);
            BufferedReader reader = resource.openAsReader();
            try {
                list = reader.lines().toList();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to load MTL file: " + String.valueOf(loc), ex);
                }
            }
            reader.close();
        }
        return list;
    }
}

