/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.client.util.ResourceUtils;
import committee.nova.mods.avaritia.api.client.util.colour.Colour;
import committee.nova.mods.avaritia.api.client.util.colour.ColourARGB;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    public static final String DEFAULT_EFFECT_DIR = "textures/mob_effect/";
    private static final Map<ResourceLocation, NativeImage> CACHE = new HashMap<ResourceLocation, NativeImage>();
    private static final Map<ResourceLocation, BufferedImage> BUFFER_CACHE = new HashMap<ResourceLocation, BufferedImage>();

    public static int[] loadTextureData(ResourceLocation resource) {
        BufferedImage img = TextureUtils.getBufferedImage(resource);
        if (img == null) {
            return new int[0];
        }
        int w = img.getWidth();
        int h = img.getHeight();
        int[] data = new int[w * h];
        img.getRGB(0, 0, w, h, data, 0, w);
        return data;
    }

    public static Colour[] loadTextureColours(ResourceLocation resource) {
        int[] idata = TextureUtils.loadTextureData(resource);
        Colour[] data = new Colour[idata.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new ColourARGB(idata[i]);
        }
        return data;
    }

    public static BufferedImage getBufferedImage(ResourceLocation texture) {
        BufferedImage bufferedImage;
        block9: {
            if (BUFFER_CACHE.containsKey(texture)) {
                return BUFFER_CACHE.get(texture);
            }
            InputStream inputStream = ResourceUtils.getResourceAsStream(texture);
            try {
                BufferedImage nativeImage = TextureUtils.getBufferedImage(inputStream);
                BUFFER_CACHE.put(texture, nativeImage);
                bufferedImage = nativeImage;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Const.LOGGER.error("Failed to load texture: {}", (Object)texture);
                    return null;
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    public static NativeImage getTextureImage(ResourceLocation texture) {
        NativeImage nativeImage;
        block9: {
            if (CACHE.containsKey(texture)) {
                return CACHE.get(texture);
            }
            InputStream inputStream = ResourceUtils.getResourceAsStream(texture);
            try {
                NativeImage nativeImage2 = NativeImage.read((InputStream)inputStream);
                CACHE.put(texture, nativeImage2);
                nativeImage = nativeImage2;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Const.LOGGER.error("Failed to load texture: {}", (Object)texture);
                    return null;
                }
            }
            inputStream.close();
        }
        return nativeImage;
    }

    public static BufferedImage getBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static void copySubImg(int[] fromTex, int fromWidth, int fromX, int fromY, int width, int height, int[] toTex, int toWidth, int toX, int toY) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fp = (y + fromY) * fromWidth + x + fromX;
                int tp = (y + toX) * toWidth + x + toX;
                toTex[tp] = fromTex[fp];
            }
        }
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GlStateManager._texParameter((int)target, (int)10241, (int)min_mag_filter);
        GlStateManager._texParameter((int)target, (int)10240, (int)min_mag_filter);
        if (target == 3553) {
            GlStateManager._bindTexture((int)target);
        } else {
            GL11.glBindTexture((int)target, (int)texture);
        }
        switch (target) {
            case 32879: {
                GlStateManager._texParameter((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GlStateManager._texParameter((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GlStateManager._texParameter((int)target, (int)10242, (int)wrap);
            }
        }
    }

    public static TextureManager getTextureManager() {
        return Minecraft.getInstance().getTextureManager();
    }

    public static TextureAtlas getTextureMap() {
        return Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
    }

    public static TextureAtlasSprite getMissingSprite() {
        return TextureUtils.getTextureMap().getSprite(MissingTextureAtlasSprite.getLocation());
    }

    public static TextureAtlasSprite getTexture(String location) {
        return TextureUtils.getTextureMap().getSprite(ResourceLocation.tryParse((String)location));
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return TextureUtils.getTextureMap().getSprite(location);
    }

    public static TextureAtlasSprite getBlockTexture(String string) {
        return TextureUtils.getBlockTexture(ResourceLocation.tryParse((String)string));
    }

    public static TextureAtlasSprite getBlockTexture(ResourceLocation location) {
        return TextureUtils.getTexture(ResourceLocation.tryBuild((String)location.getNamespace(), (String)("block/" + location.getPath())));
    }

    public static TextureAtlasSprite getItemTexture(String string) {
        return TextureUtils.getItemTexture(ResourceLocation.tryParse((String)string));
    }

    public static TextureAtlasSprite getItemTexture(ResourceLocation location) {
        return TextureUtils.getTexture(ResourceLocation.tryBuild((String)location.getNamespace(), (String)("items/" + location.getPath())));
    }

    @Deprecated
    public static TextureAtlasSprite[] getSideIconsForBlock(BlockState state) {
        TextureAtlasSprite[] sideSprites = new TextureAtlasSprite[6];
        TextureAtlasSprite missingSprite = TextureUtils.getMissingSprite();
        for (int i = 0; i < 6; ++i) {
            TextureAtlasSprite[] sprites = TextureUtils.getIconsForBlock(state, i);
            TextureAtlasSprite sideSprite = missingSprite;
            if (sprites.length != 0) {
                sideSprite = sprites[0];
            }
            sideSprites[i] = sideSprite;
        }
        return sideSprites;
    }

    @Deprecated
    public static TextureAtlasSprite[] getIconsForBlock(BlockState state, int side) {
        return TextureUtils.getIconsForBlock(state, Direction.values()[side]);
    }

    @Deprecated
    public static TextureAtlasSprite[] getIconsForBlock(BlockState state, Direction side) {
        List quads;
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        if (model != null && (quads = model.getQuads(state, side, RandomSource.create((long)0L))) != null && quads.size() > 0) {
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[quads.size()];
            for (int i = 0; i < quads.size(); ++i) {
                sprites[i] = ((BakedQuad)quads.get(i)).getSprite();
            }
            return sprites;
        }
        return new TextureAtlasSprite[0];
    }

    @Deprecated
    public static TextureAtlasSprite getParticleIconForBlock(BlockState state) {
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        return model.getParticleIcon();
    }

    public static ResourceLocation getEffectTexture(MobEffectInstance mobEffectInstance) {
        ResourceLocation registryName = BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)mobEffectInstance.getEffect().value()));
        ResourceLocation effectIcon = registryName != null ? ResourceLocation.tryBuild((String)registryName.getNamespace(), (String)(DEFAULT_EFFECT_DIR + registryName.getPath() + ".png")) : null;
        return effectIcon;
    }
}

