/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.util.colour;

import committee.nova.mods.avaritia.api.client.util.colour.Colour;

public class ColourRGBA
extends Colour {
    public ColourRGBA(int colour) {
        super(colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
    }

    public ColourRGBA(double r, double g, double b, double a) {
        super((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b), (int)(255.0 * a));
    }

    public ColourRGBA(int r, int g, int b, int a) {
        super(r, g, b, a);
    }

    public ColourRGBA(float[] data) {
        this(data[0], data[1], data[2], data[3]);
    }

    public ColourRGBA(ColourRGBA colour) {
        super(colour);
    }

    public static int pack(Colour colour) {
        return (colour.r & 0xFF) << 24 | (colour.g & 0xFF) << 16 | (colour.b & 0xFF) << 8 | colour.a & 0xFF;
    }

    public static int multiply(int c1, int c2) {
        if (c1 == -1) {
            return c2;
        }
        if (c2 == -1) {
            return c1;
        }
        int r = ((c1 >>> 24) * (c2 >>> 24) & 0xFF00) << 16;
        int g = ((c1 >> 16 & 0xFF) * (c2 >> 16 & 0xFF) & 0xFF00) << 8;
        int b = (c1 >> 8 & 0xFF) * (c2 >> 8 & 0xFF) & 0xFF00;
        int a = (c1 & 0xFF) * (c2 & 0xFF) >> 8;
        return r | g | b | a;
    }

    public static int multiplyC(int c, float f) {
        int r = (int)((float)(c >>> 24) * f);
        int g = (int)((float)(c >> 16 & 0xFF) * f);
        int b = (int)((float)(c >> 8 & 0xFF) * f);
        return r << 24 | g << 16 | b << 8 | c & 0xFF;
    }

    @Override
    public int pack() {
        return ColourRGBA.pack(this);
    }

    @Override
    public float[] packArray() {
        return new float[]{(float)(this.r & 0xFF) / 255.0f, (float)(this.g & 0xFF) / 255.0f, (float)(this.b & 0xFF) / 255.0f, (float)(this.a & 0xFF) / 255.0f};
    }

    @Override
    public Colour copy() {
        return new ColourRGBA(this);
    }

    @Override
    public Colour set(int colour) {
        return this.set(new ColourRGBA(colour));
    }
}

