/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.block;

import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class BaseBlock
extends Block {
    public BaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BaseBlock(Function<BlockBehaviour.Properties, BlockBehaviour.Properties> properties) {
        super(properties.apply(BlockBehaviour.Properties.of()));
    }

    public BaseBlock(MapColor color, SoundType sound, float hardness, float resistance, int lightLevel) {
        super(BlockBehaviour.Properties.of().sound(sound).strength(hardness, resistance).mapColor(color).lightLevel(e -> lightLevel));
    }

    public BaseBlock(MapColor color, SoundType sound, float hardness, float resistance) {
        super(BlockBehaviour.Properties.of().sound(sound).strength(hardness, resistance).mapColor(color));
    }

    public BaseBlock(SoundType sound, float hardness, float resistance) {
        super(BlockBehaviour.Properties.of().sound(sound).strength(hardness, resistance));
    }

    public BaseBlock(SoundType sound, float hardness, float resistance, boolean tool) {
        super(tool ? BlockBehaviour.Properties.of().sound(sound).strength(hardness, resistance).requiresCorrectToolForDrops() : BlockBehaviour.Properties.of().sound(sound).strength(hardness, resistance));
    }

    public BaseBlock(MapColor color, SoundType sound, float hardness, float resistance, boolean tool) {
        super(tool ? BlockBehaviour.Properties.of().sound(sound).strength(hardness, resistance).mapColor(color).requiresCorrectToolForDrops() : BlockBehaviour.Properties.of().sound(sound).strength(hardness, resistance).mapColor(color));
    }
}

