/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.container;

import committee.nova.mods.avaritia.api.utils.ContainerUtils;
import committee.nova.mods.avaritia.api.utils.java.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NoMenuContainer
implements Container {
    public ItemStack[] items;
    public int limit;
    public String name;

    public NoMenuContainer(ItemStack[] items, int limit, String name) {
        this.items = items;
        ArrayUtils.fillArray(items, ItemStack.EMPTY, Objects::isNull);
        this.limit = limit;
        this.name = name;
    }

    public NoMenuContainer(ItemStack[] items, String name) {
        this(items, 64, name);
    }

    public NoMenuContainer(ItemStack[] items, int limit) {
        this(items, limit, "inv");
    }

    public NoMenuContainer(ItemStack[] items) {
        this(items, 64, "inv");
    }

    public NoMenuContainer(int size, int limit, String name) {
        this(new ItemStack[size], limit, name);
    }

    public NoMenuContainer(int size, int limit) {
        this(size, limit, "inv");
    }

    public NoMenuContainer(int size, String name) {
        this(size, 64, name);
    }

    public NoMenuContainer(int size) {
        this(size, 64, "inv");
    }

    public int getContainerSize() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return ArrayUtils.count(this.items, stack -> !stack.isEmpty()) <= 0;
    }

    @Nonnull
    public ItemStack getItem(int slot) {
        return this.items[slot];
    }

    @Nonnull
    public ItemStack removeItem(int slot, int amount) {
        return ContainerUtils.decrStackSize(this, slot, amount);
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerUtils.removeStackFromSlot(this, slot);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.items[slot] = stack;
        this.setChanged();
    }

    public int getMaxStackSize() {
        return this.limit;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public boolean canPlaceItem(int i, @NotNull ItemStack itemstack) {
        return true;
    }

    public void setChanged() {
    }

    public void startOpen(@NotNull Player player) {
    }

    public void stopOpen(@NotNull Player player) {
    }

    public void clearContent() {
        Arrays.fill(this.items, ItemStack.EMPTY);
    }
}

