/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.container;

import committee.nova.mods.avaritia.api.common.wrapper.OffsetItemStackWrapper;
import committee.nova.mods.avaritia.common.wrappers.StorageItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface OffsetContainer
extends Container {
    public static OffsetContainer dummy(int length) {
        final OffsetItemStackWrapper itemHandler = OffsetItemStackWrapper.dummy(length);
        return new OffsetContainer(){

            @Override
            public OffsetItemStackWrapper getItemHandler() {
                return itemHandler;
            }

            public void setChanged() {
            }

            @Override
            public boolean stillValid(@NotNull Player pPlayer) {
                return OffsetContainer.super.stillValid(pPlayer);
            }
        };
    }

    public static OffsetContainer create(Int2ObjectMap<StorageItem> containers, int offset, int length) {
        final OffsetItemStackWrapper itemHandler = OffsetItemStackWrapper.create(containers, offset, length);
        return new OffsetContainer(){

            @Override
            public OffsetItemStackWrapper getItemHandler() {
                return itemHandler;
            }

            public void setChanged() {
            }

            @Override
            public boolean stillValid(@NotNull Player pPlayer) {
                return OffsetContainer.super.stillValid(pPlayer);
            }
        };
    }

    public OffsetItemStackWrapper getItemHandler();

    default public StorageItem getItemInSlot(int index) {
        return this.getItemHandler().getContainerInSlot(index);
    }

    default public ContainerData getItemCount() {
        return new ContainerData(){

            public int get(int index) {
                return index >= 0 && index < OffsetContainer.this.getContainerSize() ? (int)OffsetContainer.this.getItemInSlot(index).getCount() : 0;
            }

            public void set(int index, int value) {
                if (index >= 0 && index < OffsetContainer.this.getContainerSize()) {
                    OffsetContainer.this.getItemInSlot(index).setCount(Integer.toUnsignedLong(value));
                }
            }

            public int getCount() {
                return OffsetContainer.this.getContainerSize();
            }
        };
    }

    default public int getContainerSize() {
        return this.getItemHandler().getSlots();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItemInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public ItemStack getItem(int index) {
        return this.getItemInSlot(index).getStack().copy();
    }

    @NotNull
    default public ItemStack removeItem(int index, int count) {
        return this.getItemHandler().extractItem(index, count, false);
    }

    @NotNull
    default public ItemStack removeItemNoUpdate(int index) {
        StorageItem container = this.getItemHandler().removeContainerInSlot(index);
        if (container.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = container.getStack();
        stack.setCount((int)container.getCount());
        return stack;
    }

    default public void setItem(int index, @NotNull ItemStack stack) {
        this.getItemHandler().setStackInSlot(index, stack);
    }

    default public int getMaxStackSize() {
        return (int)Math.min(Integer.MAX_VALUE, (Long)ModConfig.slotStackLimit.get());
    }

    default public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.getItemHandler().removeContainerInSlot(i);
        }
    }

    default public boolean stillValid(@NotNull Player pPlayer) {
        return true;
    }
}

