/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public final class ShapedRecipePatternCodecs {
    private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(pattern -> {
        if (pattern.isEmpty()) {
            return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
        }
        int length = ((String)pattern.getFirst()).length();
        for (String line : pattern) {
            if (length == line.length()) continue;
            return DataResult.error(() -> "Invalid pattern: each row must be the same width");
        }
        return DataResult.success((Object)pattern);
    }, Function.identity());
    public static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(symbol -> {
        if (symbol.length() != 1) {
            return DataResult.error(() -> "Invalid key entry: '" + symbol + "' is an invalid symbol (must be 1 character only).");
        }
        return " ".equals(symbol) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(symbol.charAt(0)));
    }, String::valueOf);
    private static final MapCodec<ShapedRecipePattern.Data> DATA_MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ExtraCodecs.strictUnboundedMap(SYMBOL_CODEC, (Codec)Ingredient.CODEC_NONEMPTY).fieldOf("key").forGetter(ShapedRecipePattern.Data::key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(ShapedRecipePattern.Data::pattern)).apply((Applicative)builder, ShapedRecipePattern.Data::new));
    public static final MapCodec<ShapedRecipePattern> MAP_CODEC = DATA_MAP_CODEC.flatXmap(ShapedRecipePattern::unpack, pattern -> pattern.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
}

