/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.iface;

import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public interface ISwitchable {
    public static CompoundTag getOrCreateModeTag(ItemStack stack) {
        CompoundTag modeTag;
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag root = data == null ? new CompoundTag() : data.copyTag();
        if (!root.contains("mode", 10)) {
            modeTag = new CompoundTag();
            root.put("mode", (Tag)modeTag);
        } else {
            modeTag = root.getCompound("mode");
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
        return modeTag;
    }

    public static void updateModeTag(ItemStack stack, CompoundTag modeTag) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag root = data == null ? new CompoundTag() : data.copyTag();
        root.put("mode", (Tag)modeTag);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
    }

    public static boolean isMode(ItemStack stack, String funcName) {
        CompoundTag modeTag = ISwitchable.getOrCreateModeTag(stack);
        return modeTag.contains(funcName) && modeTag.getBoolean(funcName);
    }

    default public boolean isActive(ItemStack stack, String funcName) {
        return ISwitchable.isMode(stack, funcName);
    }

    public static int getCurrentMode(ItemStack stack, List<String> modeList) {
        CompoundTag modeTag = ISwitchable.getOrCreateModeTag(stack);
        for (int i = 0; i < modeList.size(); ++i) {
            String mode = modeList.get(i);
            if (!modeTag.contains(mode) || !modeTag.getBoolean(mode)) continue;
            return i;
        }
        return -1;
    }

    default public int getCurrentModeIndex(ItemStack stack, List<String> modeList) {
        return ISwitchable.getCurrentMode(stack, modeList);
    }

    default public void setMode(ItemStack stack, List<String> modeList, int modeIndex) {
        CompoundTag root;
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag compoundTag = root = data != null ? data.copyTag() : new CompoundTag();
        if (!root.contains("mode", 10)) {
            root.put("mode", (Tag)new CompoundTag());
        }
        CompoundTag modeTag = root.getCompound("mode");
        for (String mode : modeList) {
            modeTag.putBoolean(mode, false);
        }
        if (modeIndex >= 0 && modeIndex < modeList.size()) {
            modeTag.putBoolean(modeList.get(modeIndex), true);
        }
        root.put("mode", (Tag)modeTag);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
    }

    default public void cycleMode(@NotNull Level world, Player player, @NotNull InteractionHand hand, List<String> modeList) {
        if (modeList.isEmpty()) {
            return;
        }
        ItemStack stack = player.getItemInHand(hand);
        int currentIndex = this.getCurrentModeIndex(stack, modeList);
        int nextIndex = (currentIndex + 1) % modeList.size();
        this.setMode(stack, modeList, nextIndex);
        if (!world.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String nextMode = modeList.get(nextIndex);
            MutableComponent modeTooltip = Component.translatable((String)("tooltip.avaritia.tool." + nextMode));
            serverPlayer.sendSystemMessage((Component)ModTooltips.ACTIVE.args(modeTooltip).build(), true);
        }
        player.swing(hand);
    }

    default public void switchToMode(@NotNull Level world, Player player, @NotNull InteractionHand hand, List<String> modeList, String modeName) {
        if (!modeList.contains(modeName)) {
            return;
        }
        ItemStack stack = player.getItemInHand(hand);
        CompoundTag modeTag = ISwitchable.getOrCreateModeTag(stack);
        for (String mode : modeList) {
            modeTag.putBoolean(mode, false);
        }
        modeTag.putBoolean(modeName, true);
        if (!world.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent modeTooltip = Component.translatable((String)("tooltip.avaritia.tool." + modeName));
            serverPlayer.sendSystemMessage((Component)ModTooltips.ACTIVE.args(modeTooltip).build(), true);
        }
        player.swing(hand);
    }

    default public void switchMode(@NotNull Level world, Player player, @NotNull InteractionHand hand, String funcName) {
        CompoundTag root;
        ItemStack stack = player.getItemInHand(hand);
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag compoundTag = root = data != null ? data.copyTag() : new CompoundTag();
        if (!root.contains("mode", 10)) {
            root.put("mode", (Tag)new CompoundTag());
        }
        CompoundTag modeTag = root.getCompound("mode");
        MutableComponent funcTooltip = Component.translatable((String)("tooltip.avaritia.tool." + funcName));
        modeTag.putBoolean(funcName, !modeTag.getBoolean(funcName));
        root.put("mode", (Tag)modeTag);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
        if (!world.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.sendSystemMessage((Component)(modeTag.getBoolean(funcName) ? ModTooltips.ACTIVE.args(funcTooltip).build() : ModTooltips.INACTIVE.args(funcTooltip).build()), true);
        }
        player.swing(hand);
    }
}

