/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.utils;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PlayerUtils {
    public static boolean isPlayingMode(Player player) {
        return !player.isCreative() && !player.isSpectator();
    }

    public static boolean hasEditPermission(ServerPlayer player, BlockPos pos) {
        return !ServerLifecycleHooks.getCurrentServer().isUnderSpawnProtection((ServerLevel)player.level(), pos, (Player)player) && Arrays.stream(Direction.values()).allMatch(e -> player.mayUseItemAt(pos, e, ItemStack.EMPTY));
    }

    public static boolean checkedPlaceBlock(ServerPlayer player, BlockPos pos, BlockState state) {
        if (!PlayerUtils.hasEditPermission(player, pos)) {
            return false;
        }
        Level level = player.level();
        BlockSnapshot before = BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)pos);
        level.setBlockAndUpdate(pos, state);
        BlockEvent.EntityPlaceEvent evt = new BlockEvent.EntityPlaceEvent(before, Blocks.AIR.defaultBlockState(), (Entity)player);
        NeoForge.EVENT_BUS.post((Event)evt);
        if (evt.isCanceled()) {
            level.restoringBlockSnapshots = true;
            before.restore();
            level.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }
}

