/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.utils;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import committee.nova.mods.avaritia.api.Lib;
import committee.nova.mods.avaritia.api.init.event.RegisterRecipesEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class RecipeUtils {
    @Nullable
    private static WeakReference<RecipeManager> recipeManager;

    public static RecipeManager getRecipeManager() throws IllegalStateException {
        if (recipeManager != null && recipeManager.get() != null) {
            return (RecipeManager)recipeManager.get();
        }
        throw new IllegalStateException("Recipe Manager is not available");
    }

    @ApiStatus.Internal
    public static void setRecipeManager(RecipeManager manager) {
        recipeManager = new WeakReference<RecipeManager>(manager);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> byType(RecipeType<T> type) {
        return RecipeUtils.byType(RecipeUtils.getRecipeManager(), type);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> byType(RecipeManager manager, RecipeType<T> type) {
        return manager.byType(type);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<T> byTypeValues(RecipeType<T> type) {
        return RecipeUtils.byTypeValues(RecipeUtils.getRecipeManager(), type);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<T> byTypeValues(RecipeManager manager, RecipeType<T> type) {
        return RecipeUtils.byType(manager, type).stream().map(RecipeHolder::value).toList();
    }

    public static Collection<RecipeHolder<?>> getAllRecipes() {
        return RecipeUtils.getRecipeManager().getRecipes();
    }

    @ApiStatus.Internal
    public static void fireRecipeManagerLoadingEvent(RecipeManager manager, ImmutableMultimap.Builder<RecipeType<?>, RecipeHolder<?>> map, ImmutableMap.Builder<ResourceLocation, RecipeHolder<?>> builder) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList recipes = new ArrayList();
        try {
            NeoForge.EVENT_BUS.post((Event)new RegisterRecipesEvent(manager, recipes));
        }
        catch (Exception e) {
            Lib.LOGGER.error("An error occurred while firing RecipeManagerLoadingEvent", (Throwable)e);
        }
        for (RecipeHolder<?> recipe : recipes) {
            map.put((Object)recipe.value().getType(), recipe);
            builder.put((Object)recipe.id(), recipe);
        }
        Lib.LOGGER.info("Registered {} recipes in {} ms", (Object)recipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }
}

