/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.utils.java;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import committee.nova.mods.avaritia.api.utils.SneakyUtils;
import committee.nova.mods.avaritia.api.utils.java.ColUtils;
import committee.nova.mods.avaritia.api.utils.java.ForEachAbort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface FastStream<T>
extends Iterable<T> {
    public static final FastStream<?> EMPTY = new Internal.Empty();

    public static <T> FastStream<T> empty() {
        return (FastStream)SneakyUtils.unsafeCast(EMPTY);
    }

    public static <T> FastStream<T> of() {
        return FastStream.empty();
    }

    public static <T> FastStream<T> of(Iterable<? extends T> itr) {
        if (itr instanceof FastStream) {
            return (FastStream)itr;
        }
        int knownLength = Internal.knownLength(itr, false);
        if (knownLength == 0) {
            return FastStream.empty();
        }
        return new Wrapped<T>(itr, knownLength);
    }

    public static <T> FastStream<T> of(Spliterator<? extends T> itr) {
        long exactSize = itr.getExactSizeIfKnown();
        if (exactSize == 0L) {
            return FastStream.empty();
        }
        if (exactSize > Integer.MAX_VALUE) {
            exactSize = -1L;
        }
        return new WrappedSpl<T>(itr, (int)exactSize);
    }

    public static <T> FastStream<T> of(Stream<? extends T> stream) {
        return FastStream.of(stream.spliterator());
    }

    public static <T> FastStream<T> of(T thing) {
        return new OfSingle<T>(thing);
    }

    public static <T> FastStream<T> ofNullable(@Nullable T thing) {
        return thing != null ? FastStream.of(thing) : FastStream.empty();
    }

    public static <T> FastStream<T> of(Optional<? extends T> opt) {
        return FastStream.ofNullable(opt.orElse(null));
    }

    @SafeVarargs
    public static <T> FastStream<T> of(T ... things) {
        if (things.length == 0) {
            return FastStream.empty();
        }
        return new OfN<T>(things);
    }

    @SafeVarargs
    public static <T> FastStream<T> concat(Iterable<? extends T> ... iterables) {
        if (iterables.length == 0) {
            return FastStream.empty();
        }
        if (iterables.length == 1) {
            return FastStream.of(iterables[0]);
        }
        int nonEmptyCount = 0;
        Iterable<? extends T> lastNonEmpty = null;
        for (Iterable<? extends T> iterable : iterables) {
            if (Internal.knownLength(iterable, false) == 0) continue;
            ++nonEmptyCount;
            lastNonEmpty = iterable;
        }
        if (nonEmptyCount == 0) {
            return FastStream.empty();
        }
        if (nonEmptyCount == 1) {
            return FastStream.of(lastNonEmpty);
        }
        return new ConcatenatedN<T>(iterables);
    }

    public static <T> FastStream<T> concatMany(Iterable<? extends Iterable<? extends T>> iterables) {
        return new Concatenated(iterables);
    }

    public static <T> TypeCheck<T, T> infer() {
        return null;
    }

    default public FastStream<T> concat(Iterable<? extends T> other) {
        if (other == EMPTY) {
            return this;
        }
        return FastStream.concat(this, other);
    }

    default public FastStream<T> filter(Predicate<? super T> pred) {
        return new Filtered<T>(this, pred);
    }

    default public FastStream<T> filterNot(Predicate<? super T> pred) {
        return new Filtered<T>(this, pred.negate());
    }

    default public <R> FastStream<R> map(Function<? super T, ? extends R> func) {
        return new Mapped<T, R>(this, func);
    }

    default public <R> FastStream<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> func) {
        return new FlatMapped(this, func);
    }

    default public FastStream<T> distinct() {
        return new Distinct(this);
    }

    default public <K> FastStream<Group<K, T>> groupBy(Function<? super T, ? extends K> keyFunc) {
        return new Grouped(this, keyFunc, Function.identity());
    }

    default public <K, V> FastStream<Group<K, V>> groupBy(Function<? super T, ? extends K> keyFunc, Function<? super T, ? extends V> valueFunc) {
        return new Grouped<T, K, V>(this, keyFunc, valueFunc);
    }

    default public FastStream<T> sorted() {
        return new Sorted(this, (Comparator)SneakyUtils.unsafeCast(Comparator.naturalOrder()));
    }

    default public FastStream<T> sorted(Comparator<? super T> comparator) {
        return new Sorted<T>(this, comparator);
    }

    default public FastStream<T> reversed() {
        return new Reversed(this);
    }

    default public FastStream<T> peek(Consumer<? super T> cons) {
        return new Peeked<T>(this, cons);
    }

    default public FastStream<T> limit(@Range(from=-1L, to=0x7FFFFFFFL) int max) {
        if (max == -1) {
            return this;
        }
        if (max <= 0) {
            return FastStream.empty();
        }
        return new Sliced(this, 0, max);
    }

    default public FastStream<T> skip(@Range(from=0L, to=0x7FFFFFFFL) int n) {
        if (n == 0) {
            return this;
        }
        return new Sliced(this, n, Integer.MAX_VALUE);
    }

    default public boolean anyMatch(Predicate<? super T> pred) {
        try {
            this.forEach(e -> {
                if (pred.test(e)) {
                    throw new ForEachAbort();
                }
            });
        }
        catch (ForEachAbort ignored) {
            return true;
        }
        return false;
    }

    default public boolean allMatch(Predicate<? super T> pred) {
        return !this.anyMatch(pred.negate());
    }

    default public boolean noneMatch(Predicate<? super T> pred) {
        return this.allMatch(pred.negate());
    }

    default public boolean isEmpty() {
        return this.knownLength() == 0 || !this.iterator().hasNext();
    }

    default public int knownLength() {
        return this.knownLength(false);
    }

    default public int knownLength(boolean consumeToCalculate) {
        return -1;
    }

    default public int count() {
        int len = this.knownLength(true);
        if (len >= 0) {
            return len;
        }
        final class Cons
        implements Consumer<T> {
            private int count;

            Cons(FastStream this$0) {
            }

            @Override
            public void accept(T t) {
                ++this.count;
            }
        }
        Cons cons = new Cons(this);
        this.forEach(cons);
        return cons.count;
    }

    @Nullable
    @Contract(value="!null,_ -> !null")
    default public <U> U fold(final @Nullable U identity, final BiFunction<? super @Nullable U, ? super T, ? extends U> accumulator) {
        final class Cons
        implements Consumer<T> {
            @Nullable
            U ret;

            Cons() {
                this.ret = identity;
            }

            @Override
            public void accept(T t) {
                this.ret = accumulator.apply(this.ret, t);
            }
        }
        Cons cons = new Cons();
        this.forEach(cons);
        return cons.ret;
    }

    default public Optional<T> fold(final BinaryOperator<T> accumulator) {
        final class Cons
        implements Consumer<T> {
            @Nullable
            T ret = null;
            boolean found = false;

            Cons() {
            }

            @Override
            public void accept(T t) {
                this.ret = !this.found ? t : accumulator.apply(this.ret, t);
                this.found = true;
            }
        }
        Cons cons = new Cons();
        this.forEach(cons);
        return cons.found ? Optional.ofNullable(cons.ret) : Optional.empty();
    }

    default public int intSum(final ToIntFunction<? super T> func) {
        final class Cons
        implements Consumer<T> {
            private int sum;

            Cons() {
            }

            @Override
            public void accept(T t) {
                this.sum += func.applyAsInt(t);
            }
        }
        Cons cons = new Cons();
        this.forEach(cons);
        return cons.sum;
    }

    default public long longSum(final ToLongFunction<? super T> func) {
        final class Cons
        implements Consumer<T> {
            private long sum;

            Cons() {
            }

            @Override
            public void accept(T t) {
                this.sum += func.applyAsLong(t);
            }
        }
        Cons cons = new Cons();
        this.forEach(cons);
        return cons.sum;
    }

    default public double doubleSum(final ToDoubleFunction<? super T> func) {
        final class Cons
        implements Consumer<T> {
            private double sum;

            Cons() {
            }

            @Override
            public void accept(T t) {
                this.sum += func.applyAsDouble(t);
            }
        }
        Cons cons = new Cons();
        this.forEach(cons);
        return cons.sum;
    }

    default public Optional<T> findFirst() {
        return ColUtils.headOption(this);
    }

    default public T first() {
        return ColUtils.head(this);
    }

    @Nullable
    default public T firstOrDefault() {
        return ColUtils.headOrDefault(this);
    }

    @Nullable
    @Contract(value="!null -> !null")
    default public T firstOrDefault(@Nullable T _default) {
        return ColUtils.headOrDefault(this, _default);
    }

    default public Optional<T> findLast() {
        return ColUtils.tailOption(this);
    }

    default public T last() {
        return ColUtils.tail(this);
    }

    @Nullable
    default public T lastOrDefault() {
        return ColUtils.tailOrDefault(this);
    }

    @Nullable
    @Contract(value="!null -> !null")
    default public T lastOrDefault(@Nullable T _default) {
        return ColUtils.tailOrDefault(this, _default);
    }

    default public T only() {
        return ColUtils.only(this);
    }

    @Nullable
    default public T onlyOrDefault() {
        return this.onlyOrDefault(null);
    }

    @Nullable
    @Contract(value="!null->!null")
    default public T onlyOrDefault(@Nullable T _default) {
        return ColUtils.onlyOrDefault(this, _default);
    }

    default public T maxBy(ToIntFunction<T> func) {
        T t = this.maxByOrDefault(func);
        if (t == null) {
            throw new IllegalArgumentException("Not found.");
        }
        return t;
    }

    @Nullable
    default public T maxByOrDefault(ToIntFunction<T> func) {
        return this.maxByOrDefault(func, null);
    }

    @Nullable
    @Contract(value="_,!null->!null")
    default public T maxByOrDefault(final ToIntFunction<T> func, final @Nullable T _default) {
        final class Cons
        implements Consumer<T> {
            int max = Integer.MIN_VALUE;
            @Nullable
            T maxT = _default;

            Cons() {
            }

            @Override
            public void accept(T t) {
                int x = func.applyAsInt(t);
                if (x > this.max) {
                    this.maxT = t;
                    this.max = x;
                }
            }
        }
        Cons cons = new Cons();
        this.forEach(cons);
        return cons.maxT;
    }

    default public ArrayList<T> toList() {
        int len = this.knownLength(true);
        ArrayList list = len < 0 ? new ArrayList() : new ArrayList(len);
        this.forEach(list::add);
        return list;
    }

    default public <R> List<R> toList(TypeCheck<R, ? super T> check) {
        return this.toList();
    }

    default public LinkedList<T> toLinkedList() {
        LinkedList list = new LinkedList();
        this.forEach(list::add);
        return list;
    }

    default public <R> LinkedList<R> toLinkedList(TypeCheck<R, ? super T> check) {
        return this.toLinkedList();
    }

    default public ImmutableList<T> toImmutableList() {
        int len = this.knownLength(true);
        ImmutableList.Builder builder = len < 0 ? ImmutableList.builder() : ImmutableList.builderWithExpectedSize((int)len);
        this.forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    default public <R> ImmutableList<R> toImmutableList(TypeCheck<R, ? super T> check) {
        return this.toImmutableList();
    }

    default public HashSet<T> toSet() {
        HashSet list = new HashSet();
        this.forEach(list::add);
        return list;
    }

    default public <R> HashSet<R> toSet(TypeCheck<R, ? super T> check) {
        return this.toSet();
    }

    default public LinkedHashSet<T> toLinkedHashSet() {
        LinkedHashSet list = new LinkedHashSet();
        this.forEach(list::add);
        return list;
    }

    default public <R> LinkedHashSet<R> toLinkedHashSet(TypeCheck<R, ? super T> check) {
        return this.toLinkedHashSet();
    }

    default public ImmutableSet<T> toImmutableSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    default public <R> ImmutableSet<R> toImmutableSet(TypeCheck<R, ? super T> check) {
        return this.toImmutableSet();
    }

    default public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    default public T[] toArray(T[] arr) {
        int len = this.knownLength(true);
        if (len < 0) {
            return this.toList().toArray(arr);
        }
        final Object[] array = len > arr.length ? Arrays.copyOf(arr, len) : arr;
        this.forEach(new Consumer<T>(){
            int i = 0;

            @Override
            public void accept(T t) {
                array[this.i++] = t;
            }
        });
        if (len < arr.length) {
            array[len] = null;
        }
        return array;
    }

    default public <K, V> HashMap<K, V> toMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc) {
        return this.toMap(new HashMap(), kFunc, vFunc);
    }

    default public <K, V> HashMap<K, V> toMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc, BinaryOperator<V> mergeFunc) {
        return this.toMap(new HashMap(), kFunc, vFunc, mergeFunc);
    }

    default public <K, V> LinkedHashMap<K, V> toLinkedHashMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc) {
        return this.toMap(new LinkedHashMap(), kFunc, vFunc);
    }

    default public <K, V> LinkedHashMap<K, V> toLinkedHashMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc, BinaryOperator<V> mergeFunc) {
        return this.toMap(new LinkedHashMap(), kFunc, vFunc, mergeFunc);
    }

    default public <K, V> ImmutableMap<K, V> toImmutableMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc) {
        return ImmutableMap.copyOf(this.toLinkedHashMap(kFunc, vFunc));
    }

    default public <K, V> ImmutableMap<K, V> toImmutableMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc, BinaryOperator<V> mergeFunc) {
        return ImmutableMap.copyOf(this.toLinkedHashMap(kFunc, vFunc, mergeFunc));
    }

    default public <K, V, M extends Map<K, V>> M toMap(M map, Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc) {
        return this.toMap(map, kFunc, vFunc, SneakyUtils.first());
    }

    default public <K, V, M extends Map<K, V>> M toMap(M map, Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc, BinaryOperator<V> mergeFunc) {
        this.forEach(t -> {
            Object key = kFunc.apply(t);
            Object value = vFunc.apply(t);
            Object existing = map.get(key);
            if (existing == null) {
                map.put(key, value);
            } else {
                map.put(key, mergeFunc.apply(existing, value));
            }
        });
        return map;
    }

    default public String join(final String sep) {
        class Cons
        implements Consumer<T> {
            private final StringBuilder builder = new StringBuilder();
            private boolean first = true;

            Cons() {
            }

            @Override
            public void accept(T t) {
                if (!this.first) {
                    this.builder.append(sep);
                } else {
                    this.first = false;
                }
                this.builder.append(t);
            }
        }
        Cons cons = new Cons();
        this.forEach(cons);
        return cons.builder.toString();
    }

    public static class Internal {
        private Internal() {
        }

        private static <T> int knownLength(Iterable<? extends T> itr, boolean consumeToCalculate) {
            if (itr instanceof Collection) {
                return ((Collection)itr).size();
            }
            if (itr instanceof FastStream) {
                return ((FastStream)itr).knownLength(consumeToCalculate);
            }
            return -1;
        }

        private static class Empty<T>
        implements FastStream<T> {
            private Empty() {
            }

            @Override
            public Iterator<T> iterator() {
                return Collections.emptyIterator();
            }

            @Override
            public void forEach(Consumer<? super T> action) {
            }

            @Override
            public FastStream<T> concat(Iterable<? extends T> other) {
                return FastStream.of(other);
            }

            @Override
            public FastStream<T> filter(Predicate<? super T> pred) {
                return this;
            }

            @Override
            public FastStream<T> filterNot(Predicate<? super T> pred) {
                return this;
            }

            @Override
            public <R> FastStream<R> map(Function<? super T, ? extends R> func) {
                return FastStream.empty();
            }

            @Override
            public <R> FastStream<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> func) {
                return FastStream.empty();
            }

            @Override
            public FastStream<T> distinct() {
                return this;
            }

            @Override
            public <K> FastStream<Group<K, T>> groupBy(Function<? super T, ? extends K> keyFunc) {
                return FastStream.empty();
            }

            @Override
            public <K, V> FastStream<Group<K, V>> groupBy(Function<? super T, ? extends K> keyFunc, Function<? super T, ? extends V> valueFunc) {
                return FastStream.empty();
            }

            @Override
            public FastStream<T> sorted() {
                return this;
            }

            @Override
            public FastStream<T> sorted(Comparator<? super T> comparator) {
                return this;
            }

            @Override
            public FastStream<T> peek(Consumer<? super T> cons) {
                return this;
            }

            @Override
            public FastStream<T> limit(int max) {
                return this;
            }

            @Override
            public FastStream<T> skip(int n) {
                return this;
            }

            @Override
            @Nullable
            public <U> U fold(@Nullable U identity, BiFunction<? super @Nullable U, ? super T, ? extends U> accumulator) {
                return identity;
            }

            @Override
            public Optional<T> fold(BinaryOperator<T> accumulator) {
                return Optional.empty();
            }

            @Override
            public boolean anyMatch(Predicate<? super T> pred) {
                return false;
            }

            @Override
            public boolean allMatch(Predicate<? super T> pred) {
                return true;
            }

            @Override
            public boolean noneMatch(Predicate<? super T> pred) {
                return true;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public int knownLength() {
                return 0;
            }

            @Override
            public int knownLength(boolean consumeToCalculate) {
                return 0;
            }

            @Override
            public int count() {
                return 0;
            }

            @Override
            public int intSum(ToIntFunction<? super T> func) {
                return 0;
            }

            @Override
            public long longSum(ToLongFunction<? super T> func) {
                return 0L;
            }

            @Override
            public double doubleSum(ToDoubleFunction<? super T> func) {
                return 0.0;
            }

            @Override
            public Optional<T> findFirst() {
                return Optional.empty();
            }

            @Override
            public T first() {
                throw new IllegalArgumentException("Not found.");
            }

            @Override
            @Nullable
            public T firstOrDefault() {
                return null;
            }

            @Override
            @Nullable
            public T firstOrDefault(@Nullable T _default) {
                return _default;
            }

            @Override
            public Optional<T> findLast() {
                return Optional.empty();
            }

            @Override
            public T last() {
                throw new IllegalArgumentException("Not found.");
            }

            @Override
            @Nullable
            public T lastOrDefault() {
                return null;
            }

            @Override
            @Nullable
            public T lastOrDefault(@Nullable T _default) {
                return _default;
            }

            @Override
            public T only() {
                throw new IllegalArgumentException("Not found.");
            }

            @Override
            @Nullable
            public T onlyOrDefault() {
                return null;
            }

            @Override
            @Nullable
            public T onlyOrDefault(@Nullable T _default) {
                return _default;
            }

            @Override
            public T maxBy(ToIntFunction<T> func) {
                throw new IllegalArgumentException("Not found.");
            }

            @Override
            @Nullable
            public T maxByOrDefault(ToIntFunction<T> func) {
                return null;
            }

            @Override
            @Nullable
            public T maxByOrDefault(ToIntFunction<T> func, @Nullable T _default) {
                return _default;
            }

            @Override
            public ArrayList<T> toList() {
                return new ArrayList();
            }

            @Override
            public LinkedList<T> toLinkedList() {
                return new LinkedList();
            }

            @Override
            public ImmutableList<T> toImmutableList() {
                return ImmutableList.of();
            }

            @Override
            public HashSet<T> toSet() {
                return new HashSet();
            }

            @Override
            public LinkedHashSet<T> toLinkedHashSet() {
                return new LinkedHashSet();
            }

            @Override
            public ImmutableSet<T> toImmutableSet() {
                return ImmutableSet.of();
            }

            @Override
            public Object[] toArray() {
                return new Object[0];
            }

            @Override
            public T[] toArray(T[] arr) {
                return ColUtils.fill(arr, null);
            }

            @Override
            public <K, V> HashMap<K, V> toMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc) {
                return new HashMap();
            }

            @Override
            public <K, V> HashMap<K, V> toMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc, BinaryOperator<V> mergeFunc) {
                return new HashMap();
            }

            @Override
            public <K, V> LinkedHashMap<K, V> toLinkedHashMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc) {
                return new LinkedHashMap();
            }

            @Override
            public <K, V> LinkedHashMap<K, V> toLinkedHashMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc, BinaryOperator<V> mergeFunc) {
                return new LinkedHashMap();
            }

            @Override
            public <K, V> ImmutableMap<K, V> toImmutableMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc) {
                return ImmutableMap.of();
            }

            @Override
            public <K, V> ImmutableMap<K, V> toImmutableMap(Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc, BinaryOperator<V> mergeFunc) {
                return ImmutableMap.of();
            }

            @Override
            public <K, V, M extends Map<K, V>> M toMap(M map, Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc) {
                return map;
            }

            @Override
            public <K, V, M extends Map<K, V>> M toMap(M map, Function<? super T, ? extends K> kFunc, Function<? super T, ? extends V> vFunc, BinaryOperator<V> mergeFunc) {
                return map;
            }

            @Override
            public String join(String sep) {
                return "";
            }
        }
    }

    public static final class Wrapped<T>
    implements FastStream<T> {
        private final Iterable<T> _itr;
        private final int knownLength;

        private Wrapped(Iterable<T> itr, int knownLength) {
            this._itr = itr;
            this.knownLength = knownLength;
        }

        @Override
        public Iterator<T> iterator() {
            return this._itr.iterator();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this._itr.forEach(action);
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return this.knownLength;
        }
    }

    public static final class WrappedSpl<T>
    implements FastStream<T> {
        private final Spliterator<T> _itr;
        private final int knownLength;

        private WrappedSpl(Spliterator<T> itr, int knownLength) {
            this._itr = itr;
            this.knownLength = knownLength;
        }

        @Override
        public Iterator<T> iterator() {
            return new AbstractIterator<T>(){
                @Nullable
                private T t;
                private final Consumer<T> cons = e -> {
                    this.t = e;
                };

                @Nullable
                protected T computeNext() {
                    if (_itr.tryAdvance(this.cons)) {
                        return this.t;
                    }
                    return this.endOfData();
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this._itr.forEachRemaining(action);
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return this.knownLength;
        }
    }

    public static final class OfSingle<T>
    implements FastStream<T> {
        private final T thing;

        private OfSingle(T thing) {
            this.thing = thing;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public T next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    this.hasNext = false;
                    return thing;
                }

                @Override
                public void forEachRemaining(Consumer<? super T> action) {
                    if (this.hasNext) {
                        action.accept(thing);
                    }
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            action.accept(this.thing);
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return 1;
        }
    }

    public static final class OfN<T>
    implements FastStream<T> {
        private final T[] things;

        private OfN(T[] things) {
            this.things = things;
        }

        @Override
        public Iterator<T> iterator() {
            return ColUtils.iterator(this.things);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            for (T t : this.things) {
                action.accept(t);
            }
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return this.things.length;
        }
    }

    public static final class ConcatenatedN<T>
    implements FastStream<T> {
        private final Iterable<? extends T>[] iterables;

        private ConcatenatedN(Iterable<? extends T>[] iterables) {
            this.iterables = iterables;
        }

        @Override
        public Iterator<T> iterator() {
            return new AbstractIterator<T>(){
                private int i = 0;
                @Nullable
                private Iterator<? extends T> working;

                protected T computeNext() {
                    while (true) {
                        if (this.working == null) {
                            if (this.i >= iterables.length) break;
                            this.working = iterables[this.i++].iterator();
                        }
                        if (this.working.hasNext()) {
                            return this.working.next();
                        }
                        this.working = null;
                    }
                    return this.endOfData();
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            for (Iterable<? super T> iterable : this.iterables) {
                iterable.forEach(action);
            }
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            int len = 0;
            for (Iterable<? extends T> iterable : this.iterables) {
                int ilen = Internal.knownLength(iterable, consumeToCalculate);
                if (ilen < 0) {
                    return -1;
                }
                len += ilen;
            }
            return len;
        }
    }

    public static final class Concatenated<T>
    implements FastStream<T> {
        private final Iterable<? extends Iterable<? extends T>> iterables;

        private Concatenated(Iterable<? extends Iterable<? extends T>> iterables) {
            this.iterables = iterables;
        }

        @Override
        public Iterator<T> iterator() {
            return new AbstractIterator<T>(){
                private final Iterator<? extends Iterable<? extends T>> itr;
                @Nullable
                private Iterator<? extends T> working;
                {
                    this.itr = iterables.iterator();
                }

                protected T computeNext() {
                    while (true) {
                        if (this.working == null) {
                            if (!this.itr.hasNext()) break;
                            this.working = this.itr.next().iterator();
                        }
                        if (this.working.hasNext()) {
                            return this.working.next();
                        }
                        this.working = null;
                    }
                    return this.endOfData();
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this.iterables.forEach(e -> e.forEach(action));
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            int len = 0;
            for (Iterable<? extends T> iterable : this.iterables) {
                int ilen = Internal.knownLength(iterable, consumeToCalculate);
                if (ilen < 0) {
                    return -1;
                }
                len += ilen;
            }
            return len;
        }
    }

    public static final class Filtered<T>
    implements FastStream<T> {
        private final FastStream<T> parent;
        private final Predicate<? super T> pred;

        private Filtered(FastStream<T> parent, Predicate<? super T> pred) {
            this.parent = parent;
            this.pred = pred;
        }

        @Override
        public Iterator<T> iterator() {
            return new AbstractIterator<T>(){
                private final Iterator<T> itr;
                {
                    this.itr = parent.iterator();
                }

                protected T computeNext() {
                    while (this.itr.hasNext()) {
                        Object e = this.itr.next();
                        if (!pred.test(e)) continue;
                        return e;
                    }
                    return this.endOfData();
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this.parent.forEach(e -> {
                if (this.pred.test(e)) {
                    action.accept(e);
                }
            });
        }
    }

    public static final class Mapped<T, R>
    implements FastStream<R> {
        private final FastStream<T> parent;
        private final Function<? super T, ? extends R> func;

        private Mapped(FastStream<T> parent, Function<? super T, ? extends R> func) {
            this.parent = parent;
            this.func = func;
        }

        @Override
        public Iterator<R> iterator() {
            return new Iterator<R>(){
                private final Iterator<T> itr;
                {
                    this.itr = parent.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.itr.hasNext();
                }

                @Override
                public R next() {
                    return func.apply(this.itr.next());
                }
            };
        }

        @Override
        public void forEach(Consumer<? super R> action) {
            this.parent.forEach((? super T e) -> action.accept((R)this.func.apply(e)));
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return this.parent.knownLength(consumeToCalculate);
        }
    }

    public static final class FlatMapped<T, R>
    implements FastStream<R> {
        private final FastStream<T> parent;
        private final Function<? super T, ? extends Iterable<? extends R>> func;

        private FlatMapped(FastStream<T> parent, Function<? super T, ? extends Iterable<? extends R>> func) {
            this.parent = parent;
            this.func = func;
        }

        @Override
        public Iterator<R> iterator() {
            return new AbstractIterator<R>(){
                private final Iterator<T> itr;
                @Nullable
                private Iterator<? extends R> working;
                {
                    this.itr = parent.iterator();
                }

                protected R computeNext() {
                    while (true) {
                        if (this.working == null) {
                            if (!this.itr.hasNext()) break;
                            this.working = func.apply(this.itr.next()).iterator();
                        }
                        if (this.working.hasNext()) {
                            return this.working.next();
                        }
                        this.working = null;
                    }
                    return this.endOfData();
                }
            };
        }

        @Override
        public void forEach(Consumer<? super R> action) {
            this.parent.forEach((? super T e) -> this.func.apply(e).forEach(action));
        }
    }

    public static final class Distinct<T>
    implements FastStream<T> {
        private final FastStream<T> parent;
        private int knownLength = -1;

        private Distinct(FastStream<T> parent) {
            this.parent = parent;
        }

        @Override
        public Iterator<T> iterator() {
            return new AbstractIterator<T>(){
                private final Set<T> set = new HashSet();
                private final Iterator<T> itr;
                {
                    this.itr = parent.iterator();
                }

                protected T computeNext() {
                    while (this.itr.hasNext()) {
                        Object e = this.itr.next();
                        if (!this.set.add(e)) continue;
                        return e;
                    }
                    knownLength = this.set.size();
                    return this.endOfData();
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            HashSet set = new HashSet();
            this.parent.forEach(e -> {
                if (set.add(e)) {
                    action.accept(e);
                }
            });
            this.knownLength = set.size();
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return this.knownLength;
        }

        @Override
        public HashSet<T> toSet() {
            return this.parent.toSet();
        }

        @Override
        public LinkedHashSet<T> toLinkedHashSet() {
            return this.parent.toLinkedHashSet();
        }

        @Override
        public ImmutableSet<T> toImmutableSet() {
            return this.parent.toImmutableSet();
        }
    }

    public static final class Grouped<T, K, V>
    implements FastStream<Group<K, V>> {
        private final FastStream<T> parent;
        private final Function<? super T, ? extends K> keyFunc;
        private final Function<? super T, ? extends V> valueFunc;
        @Nullable
        private Map<K, Group<K, V>> groups = null;

        public Grouped(FastStream<T> parent, Function<? super T, ? extends K> keyFunc, Function<? super T, ? extends V> valueFunc) {
            this.parent = parent;
            this.keyFunc = keyFunc;
            this.valueFunc = valueFunc;
        }

        @Override
        @NotNull
        public Iterator<Group<K, V>> iterator() {
            return this.getGroups().values().iterator();
        }

        @Override
        public void forEach(Consumer<? super Group<K, V>> action) {
            this.getGroups().values().forEach(action);
        }

        private Map<K, Group<K, V>> getGroups() {
            if (this.groups == null) {
                this.groups = new HashMap<K, Group<K, V>>();
                this.parent.forEach((? super T e) -> this.groups.computeIfAbsent(this.keyFunc.apply(e), Group::new).add(this.valueFunc.apply(e)));
            }
            return this.groups;
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return consumeToCalculate ? this.getGroups().size() : -1;
        }
    }

    public static final class Sorted<T>
    implements FastStream<T> {
        private final FastStream<T> parent;
        private final Comparator<? super T> comparator;
        T @Nullable [] sorted = null;

        private Sorted(FastStream<T> parent, Comparator<? super T> comparator) {
            this.parent = parent;
            this.comparator = comparator;
        }

        @Override
        public Iterator<T> iterator() {
            return ColUtils.iterator(this.getSorted());
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            for (T t : this.getSorted()) {
                action.accept(t);
            }
        }

        private T[] getSorted() {
            if (this.sorted == null) {
                this.sorted = (Object[])SneakyUtils.unsafeCast(this.parent.toArray());
                Arrays.sort(this.sorted, this.comparator);
            }
            return this.sorted;
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return consumeToCalculate ? this.getSorted().length : this.parent.knownLength(false);
        }

        @Override
        public T[] toArray(T[] arr) {
            T[] sorted = this.getSorted();
            if (arr.getClass() == sorted.getClass()) {
                this.sorted = null;
                return sorted;
            }
            return Arrays.copyOf(sorted, sorted.length, arr.getClass());
        }

        @Override
        public ArrayList<T> toList() {
            return new ArrayList<T>(Arrays.asList(this.getSorted()));
        }

        @Override
        public ImmutableList<T> toImmutableList() {
            return ImmutableList.copyOf((Object[])this.getSorted());
        }
    }

    public static final class Reversed<T>
    implements FastStream<T> {
        private final FastStream<T> parent;
        T @Nullable [] reversed = null;

        private Reversed(FastStream<T> parent) {
            this.parent = parent;
        }

        @Override
        public Iterator<T> iterator() {
            return ColUtils.iterator(this.getReversed());
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            for (T t : this.getReversed()) {
                action.accept(t);
            }
        }

        private T[] getReversed() {
            if (this.reversed == null) {
                this.reversed = (Object[])SneakyUtils.unsafeCast(this.parent.toArray());
                ColUtils.reverse(this.reversed);
            }
            return this.reversed;
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return consumeToCalculate ? this.getReversed().length : this.parent.knownLength(false);
        }

        @Override
        public T[] toArray(T[] arr) {
            T[] reversed = this.getReversed();
            if (arr.getClass() == reversed.getClass()) {
                this.reversed = null;
                return reversed;
            }
            return Arrays.copyOf(reversed, reversed.length, arr.getClass());
        }
    }

    public static final class Peeked<T>
    implements FastStream<T> {
        private final FastStream<T> parent;
        private final Consumer<? super T> cons;

        private Peeked(FastStream<T> parent, Consumer<? super T> cons) {
            this.parent = parent;
            this.cons = cons;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private final Iterator<T> itr;
                {
                    this.itr = parent.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.itr.hasNext();
                }

                @Override
                public T next() {
                    Object n = this.itr.next();
                    cons.accept(n);
                    return n;
                }
            };
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this.parent.forEach(e -> {
                this.cons.accept(e);
                action.accept(e);
            });
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return this.parent.knownLength(consumeToCalculate);
        }
    }

    public static final class Sliced<T>
    implements FastStream<T> {
        private final FastStream<T> parent;
        private final int min;
        private final int max;

        private Sliced(FastStream<T> parent, int min, int max) {
            this.parent = parent;
            this.min = min;
            this.max = max;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new AbstractIterator<T>(){
                private final Iterator<T> itr;
                private int i;
                {
                    this.itr = parent.iterator();
                }

                @Nullable
                protected T computeNext() {
                    while (this.i < min && this.itr.hasNext()) {
                        this.itr.next();
                        ++this.i;
                    }
                    if (this.i++ >= max || !this.itr.hasNext()) {
                        return this.endOfData();
                    }
                    return this.itr.next();
                }
            };
        }

        @Override
        public void forEach(final Consumer<? super T> action) {
            block2: {
                final ForEachAbort abort = new ForEachAbort();
                try {
                    this.parent.forEach(new Consumer<T>(){
                        int i = 0;

                        @Override
                        public void accept(T t) {
                            int n;
                            if ((n = this.i++) < min) {
                                return;
                            }
                            if (n >= max) {
                                throw abort;
                            }
                            action.accept(t);
                        }
                    });
                }
                catch (ForEachAbort ex) {
                    if (ex == abort) break block2;
                    throw ex;
                }
            }
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            int pLen = this.parent.knownLength(consumeToCalculate);
            if (pLen == -1) {
                return -1;
            }
            return Math.min(Math.max(pLen - this.min, 0), this.max);
        }
    }

    public static final class TypeCheck<T, S> {
        private TypeCheck() {
        }
    }

    public static final class Group<K, V>
    implements FastStream<V> {
        private final K key;
        private int size;
        private Object[] values = new Object[1];

        public Group(K key) {
            this.key = key;
        }

        @Override
        public Iterator<V> iterator() {
            return ColUtils.iterator(this.values, 0, this.size);
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            for (int i = 0; i < this.size; ++i) {
                action.accept(this.values[i]);
            }
        }

        @Override
        public int knownLength(boolean consumeToCalculate) {
            return this.size;
        }

        public K getKey() {
            return this.key;
        }

        private void add(V value) {
            this.resize();
            this.values[this.size++] = value;
        }

        private void resize() {
            if (this.size < this.values.length) {
                return;
            }
            this.values = Arrays.copyOf(this.values, this.size > 1024 ? this.size * 2 : this.size * 4);
        }

        @Override
        public V[] toArray(V[] arr) {
            if (arr.length >= this.size) {
                System.arraycopy(this.values, 0, arr, 0, this.size);
                if (arr.length >= this.size + 1) {
                    arr[this.size + 1] = null;
                }
                return arr;
            }
            return Arrays.copyOf(this.values, this.size, arr.getClass());
        }
    }
}

