/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.utils.text;

import committee.nova.mods.avaritia.api.utils.text.IHasTextComponent;
import committee.nova.mods.avaritia.api.utils.text.IHasTranslationKey;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class TextComponentUtils {
    private static final Component TEXT_NULL = TextComponentUtils.getString("null");

    private TextComponentUtils() {
    }

    public static MutableComponent build(Object ... components) {
        MutableComponent result = null;
        Style cachedStyle = Style.EMPTY;
        for (Object component : components) {
            Object object;
            if (component == null) continue;
            MutableComponent current = null;
            Objects.requireNonNull(component);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IHasTextComponent.class, moze_intel.projecte.utils.text.IHasTranslationKey.class, TextColor.class, Component.class, ChatFormatting.class, ClickEvent.class, HoverEvent.class, Block.class, Item.class, ItemStack.class, FluidStack.class, Fluid.class, EntityType.class, Level.class}, (Object)object, n)) {
                case 0: {
                    IHasTextComponent hasTextComponent = (IHasTextComponent)object;
                    current = hasTextComponent.getTextComponent().copy();
                    break;
                }
                case 1: {
                    moze_intel.projecte.utils.text.IHasTranslationKey hasTranslationKey = (moze_intel.projecte.utils.text.IHasTranslationKey)object;
                    current = TextComponentUtils.translate(hasTranslationKey.getTranslationKey());
                    break;
                }
                case 2: {
                    TextColor color = (TextColor)object;
                    cachedStyle = cachedStyle.withColor(color);
                    break;
                }
                case 3: {
                    Component c = (Component)object;
                    current = c.copy();
                    break;
                }
                case 4: {
                    ChatFormatting formatting = (ChatFormatting)object;
                    cachedStyle = cachedStyle.applyFormat(formatting);
                    break;
                }
                case 5: {
                    ClickEvent event = (ClickEvent)object;
                    cachedStyle = cachedStyle.withClickEvent(event);
                    break;
                }
                case 6: {
                    HoverEvent event = (HoverEvent)object;
                    cachedStyle = cachedStyle.withHoverEvent(event);
                    break;
                }
                case 7: {
                    Block block = (Block)object;
                    current = block.getName().copy();
                    break;
                }
                case 8: {
                    Item item = (Item)object;
                    current = item.getDescription().copy();
                    break;
                }
                case 9: {
                    ItemStack stack = (ItemStack)object;
                    current = stack.getHoverName().copy();
                    break;
                }
                case 10: {
                    FluidStack stack = (FluidStack)object;
                    current = stack.getHoverName().copy();
                    break;
                }
                case 11: {
                    Fluid fluid = (Fluid)object;
                    current = fluid.getFluidType().getDescription().copy();
                    break;
                }
                case 12: {
                    EntityType entityType = (EntityType)object;
                    current = entityType.getDescription().copy();
                    break;
                }
                case 13: {
                    Level level = (Level)object;
                    current = level.getDescription().copy();
                    break;
                }
                default: {
                    current = TextComponentUtils.getString(component.toString());
                }
            }
            if (current == null) continue;
            if (!cachedStyle.isEmpty()) {
                current.setStyle(cachedStyle);
                cachedStyle = Style.EMPTY;
            }
            if (result == null) {
                result = current;
                continue;
            }
            result.append((Component)current);
        }
        return result;
    }

    public static MutableComponent getString(String component) {
        return Component.literal((String)TextComponentUtils.cleanString(component));
    }

    private static String cleanString(String component) {
        return component.replace("\u00a0", " ");
    }

    public static MutableComponent translate(String key) {
        return Component.translatable((String)key);
    }

    public static MutableComponent translate(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])args);
    }

    public static MutableComponent smartTranslate(String key, Object ... components) {
        if (components.length == 0) {
            return TextComponentUtils.translate(key);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Style cachedStyle = Style.EMPTY;
        for (Object component : components) {
            if (component == null) {
                args.add(TEXT_NULL);
                cachedStyle = Style.EMPTY;
                continue;
            }
            MutableComponent current = null;
            if (component instanceof Component) {
                Component c = (Component)component;
                current = c.copy();
            } else if (component instanceof IHasTextComponent) {
                IHasTextComponent hasTextComponent = (IHasTextComponent)component;
                current = hasTextComponent.getTextComponent().copy();
            } else if (component instanceof IHasTranslationKey) {
                IHasTranslationKey hasTranslationKey = (IHasTranslationKey)component;
                current = TextComponentUtils.translate(hasTranslationKey.getTranslationKey());
            } else if (component instanceof Block) {
                Block block = (Block)component;
                current = block.getName().copy();
            } else if (component instanceof Item) {
                Item item = (Item)component;
                current = item.getDescription().copy();
            } else if (component instanceof ItemStack) {
                ItemStack stack = (ItemStack)component;
                current = stack.getHoverName().copy();
            } else if (component instanceof FluidStack) {
                FluidStack stack = (FluidStack)component;
                current = stack.getHoverName().copy();
            } else if (component instanceof Fluid) {
                Fluid fluid = (Fluid)component;
                current = fluid.getFluidType().getDescription().copy();
            } else if (component instanceof EntityType) {
                EntityType entityType = (EntityType)component;
                current = entityType.getDescription().copy();
            } else if (component instanceof Level) {
                Level level = (Level)component;
                current = level.getDescription().copy();
            } else {
                ChatFormatting formatting;
                if (component instanceof TextColor) {
                    TextColor color = (TextColor)component;
                    if (cachedStyle.getColor() == null) {
                        cachedStyle = cachedStyle.withColor(color);
                        continue;
                    }
                }
                if (component instanceof ChatFormatting && !TextComponentUtils.hasStyleType(cachedStyle, formatting = (ChatFormatting)component)) {
                    cachedStyle = cachedStyle.applyFormat(formatting);
                    continue;
                }
                if (component instanceof ClickEvent) {
                    ClickEvent event = (ClickEvent)component;
                    if (cachedStyle.getClickEvent() == null) {
                        cachedStyle = cachedStyle.withClickEvent(event);
                        continue;
                    }
                }
                if (component instanceof HoverEvent) {
                    HoverEvent event = (HoverEvent)component;
                    if (cachedStyle.getHoverEvent() == null) {
                        cachedStyle = cachedStyle.withHoverEvent(event);
                        continue;
                    }
                }
                if (!cachedStyle.isEmpty()) {
                    current = TextComponentUtils.getString(component.toString());
                } else if (component instanceof String) {
                    String str = (String)component;
                    component = TextComponentUtils.cleanString(str);
                } else if (!TranslatableContents.isAllowedPrimitiveArgument((Object)component)) {
                    component = TextComponentUtils.cleanString(component.toString());
                }
            }
            if (!cachedStyle.isEmpty()) {
                if (current == null) {
                    current = TextComponentUtils.getString(component.toString());
                }
                args.add(current.setStyle(cachedStyle));
                cachedStyle = Style.EMPTY;
                continue;
            }
            args.add(Objects.requireNonNullElse(current, component));
        }
        if (!cachedStyle.isEmpty()) {
            Object lastComponent = components[components.length - 1];
            if (lastComponent == null) {
                args.add(TEXT_NULL);
            } else if (lastComponent instanceof Component || TranslatableContents.isAllowedPrimitiveArgument((Object)lastComponent)) {
                args.add(lastComponent);
            } else {
                args.add(TextComponentUtils.cleanString(lastComponent.toString()));
            }
        }
        return TextComponentUtils.translate(key, args.toArray());
    }

    private static boolean hasStyleType(Style current, ChatFormatting formatting) {
        return switch (formatting) {
            case ChatFormatting.OBFUSCATED -> current.isObfuscated();
            case ChatFormatting.BOLD -> current.isBold();
            case ChatFormatting.STRIKETHROUGH -> current.isStrikethrough();
            case ChatFormatting.UNDERLINE -> current.isUnderlined();
            case ChatFormatting.ITALIC -> current.isItalic();
            case ChatFormatting.RESET -> current.isEmpty();
            default -> current.getColor() != null;
        };
    }
}

