/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client;

import com.mojang.blaze3d.platform.Window;
import committee.nova.mods.avaritia.api.iface.IFilterItem;
import committee.nova.mods.avaritia.client.screen.ItemFilterScreen;
import committee.nova.mods.avaritia.common.entity.GapingVoidEntity;
import committee.nova.mods.avaritia.common.net.C2SOpenRingPack;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="avaritia", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class AvaritiaForgeClient {
    private static final String CATEGORIES = "key.avaritia.categories";
    private static boolean keepFlying = false;
    public static final KeyMapping FILTER_KEY = new KeyMapping("key.avaritia.filter", 72, "key.avaritia.categories");
    public static final KeyMapping RING_KEY = new KeyMapping("key.avaritia.neutron_ring", 78, "key.avaritia.categories");
    public static final KeyMapping SORT_0 = new KeyMapping("key.avaritia.infinity_chest.sort0", 48, "key.avaritia.categories");
    public static final KeyMapping SORT_1 = new KeyMapping("key.avaritia.infinity_chest.sort1", 49, "key.avaritia.categories");
    public static final KeyMapping SORT_2 = new KeyMapping("key.avaritia.infinity_chest.sort2", 50, "key.avaritia.categories");
    public static final KeyMapping SORT_3 = new KeyMapping("key.avaritia.infinity_chest.sort3", 51, "key.avaritia.categories");
    public static final KeyMapping SORT_4 = new KeyMapping("key.avaritia.infinity_chest.sort4", 52, "key.avaritia.categories");
    public static final KeyMapping SORT_5 = new KeyMapping("key.avaritia.infinity_chest.sort5", 53, "key.avaritia.categories");
    public static final KeyMapping SORT_6 = new KeyMapping("key.avaritia.infinity_chest.sort6", 54, "key.avaritia.categories");
    public static final KeyMapping SORT_7 = new KeyMapping("key.avaritia.infinity_chest.sort7", 55, "key.avaritia.categories");
    public static final KeyMapping SORT_8 = new KeyMapping("key.avaritia.infinity_chest.sort8", 56, "key.avaritia.categories");
    public static final KeyMapping SORT_9 = new KeyMapping("key.avaritia.infinity_chest.sort9", 57, "key.avaritia.categories");
    private static int infinityElytraCooldown = 0;
    private static Component[] tooltipExt = new Component[0];

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = Minecraft.getInstance().player;
        while (FILTER_KEY.consumeClick() && player != null) {
            if (player.getMainHandItem().isEmpty() || !(player.getMainHandItem().getItem() instanceof IFilterItem)) continue;
            Minecraft.getInstance().setScreen((Screen)new ItemFilterScreen());
        }
        while (RING_KEY.consumeClick() && player != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new C2SOpenRingPack(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        AvaritiaForgeClient.handleInfinityElytraFallFlying(mc, (Player)player);
    }

    public static void handleInfinityElytraFallFlying(Minecraft mc, Player player) {
        if (player == null) {
            return;
        }
        if (!player.getItemBySlot(EquipmentSlot.CHEST).is((Item)ModItems.infinity_elytra.get())) {
            keepFlying = false;
            return;
        }
        boolean isFlying = player.isFallFlying();
        if (mc.options.keyJump.isDown()) {
            keepFlying = false;
            return;
        }
        if (isFlying && !keepFlying) {
            keepFlying = true;
        }
        if (keepFlying && player.onGround()) {
            keepFlying = false;
            double radius = 2.5;
            List nearby = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(radius), e -> e != player && !e.isInvulnerable());
            for (LivingEntity target : nearby) {
                target.hurt(player.damageSources().fellOutOfWorld(), 6.0f);
            }
            return;
        }
        if (keepFlying && player.isFallFlying()) {
            Vec3 look = player.getLookAngle().normalize();
            double FLY_SPEED = (Double)ModConfig.infinityElytraFlyingSpeed.get();
            player.setDeltaMovement(look.x * FLY_SPEED, look.y * FLY_SPEED, look.z * FLY_SPEED);
        }
    }

    public static void setTooltip(Component ... string) {
        tooltipExt = string;
    }

    @SubscribeEvent
    public static void getTooltip(ItemTooltipEvent evt) {
        Collections.addAll(evt.getToolTip(), tooltipExt);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent e) {
        if (!FMLLoader.isProduction() || ((Boolean)ModConfig.useAdvanceTooltips.get()).booleanValue()) {
            ItemStack stack = e.getItemStack();
            List tooltips = e.getToolTip();
            if (Screen.hasAltDown()) {
                for (TypedDataComponent c : stack.getComponents()) {
                    Object object = c.value();
                    if (!(object instanceof CompoundTag)) continue;
                    CompoundTag tag = (CompoundTag)object;
                    AvaritiaForgeClient.addTagCompound("  ", tooltips, tag);
                }
            }
        }
    }

    private static void addTagCompound(String prefix, List<Component> list, CompoundTag tag) {
        TreeSet sortedKeys = new TreeSet(tag.getAllKeys());
        block9: for (String key : sortedKeys) {
            Tag elem = tag.get(key);
            switch (elem.getId()) {
                case 2: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u00a72" + tag.getShort(key))));
                    break;
                }
                case 3: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u00a73" + tag.getInt(key))));
                    break;
                }
                case 6: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u00a76" + tag.getDouble(key))));
                    break;
                }
                case 8: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u00a78" + tag.getString(key))));
                    break;
                }
                case 1: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u00a79" + tag.getByte(key))));
                    break;
                }
                case 9: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u00a79List, " + ((ListTag)elem).size() + " items")));
                    if (!Screen.hasShiftDown()) continue block9;
                    for (Tag key1 : (ListTag)elem) {
                        AvaritiaForgeClient.addTagCompound(prefix + "    ", list, (CompoundTag)key1);
                    }
                    continue block9;
                }
                case 10: {
                    list.add((Component)Component.literal((String)(prefix + key + ": \u00a7aCompound")));
                    if (!Screen.hasShiftDown()) continue block9;
                    AvaritiaForgeClient.addTagCompound(prefix + "    ", list, (CompoundTag)elem);
                    break;
                }
                default: {
                    list.add((Component)Component.literal((String)(prefix + key + ": Type " + String.valueOf(elem.getType()))));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.level == null) {
            return;
        }
        double START_DISTANCE = 6.0;
        double FULL_DISTANCE = 4.0;
        List voids = mc.level.getEntitiesOfClass(GapingVoidEntity.class, player.getBoundingBox().inflate(16.0));
        float maxDarkness = 0.0f;
        for (GapingVoidEntity gap : voids) {
            double distance = player.distanceTo((Entity)gap);
            if (!(distance <= 6.0)) continue;
            float darkness = (float)((6.0 - distance) / 2.0);
            darkness = Math.max(0.0f, Math.min(1.0f, darkness));
            maxDarkness = Math.max(maxDarkness, darkness);
        }
        if (maxDarkness > 0.0f) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Window window = mc.getWindow();
            int screenWidth = window.getGuiScaledWidth();
            int screenHeight = window.getGuiScaledHeight();
            int alpha = (int)(maxDarkness * 255.0f);
            if (alpha > 255) {
                alpha = 255;
            }
            guiGraphics.fill(0, 0, screenWidth, screenHeight, alpha << 24);
        }
    }
}

