/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.common.entity.FireBallEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class FireBallRender
extends EntityRenderer<FireBallEntity> {
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)Res.DRAGON_FIREBALL);

    public FireBallRender(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v) {
        consumer.addVertex(pose, x - 0.5f, (float)y - 0.25f, 0.0f).setColor(-1).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    protected int getBlockLightLevel(@NotNull FireBallEntity pEntity, @NotNull BlockPos pPos) {
        return 15;
    }

    public void render(@NotNull FireBallEntity pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.pushPose();
        pPoseStack.scale(2.0f, 2.0f, 2.0f);
        pPoseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose posestack$pose = pPoseStack.last();
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RENDER_TYPE);
        FireBallRender.vertex(vertexconsumer, posestack$pose, pPackedLight, 0.0f, 0, 0, 1);
        FireBallRender.vertex(vertexconsumer, posestack$pose, pPackedLight, 1.0f, 0, 1, 1);
        FireBallRender.vertex(vertexconsumer, posestack$pose, pPackedLight, 1.0f, 1, 1, 0);
        FireBallRender.vertex(vertexconsumer, posestack$pose, pPackedLight, 0.0f, 1, 0, 0);
        pPoseStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull FireBallEntity pEntity) {
        return Res.DRAGON_FIREBALL;
    }
}

