/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.render.CCRenderState;
import committee.nova.mods.avaritia.api.client.render.buffer.TransformingVertexConsumer;
import committee.nova.mods.avaritia.api.client.render.model.OBJParser;
import committee.nova.mods.avaritia.api.client.render.pipeline.IVertexOperation;
import committee.nova.mods.avaritia.api.client.util.colour.Colour;
import committee.nova.mods.avaritia.api.client.util.colour.ColourRGBA;
import committee.nova.mods.avaritia.client.shader.AvaritiaRenderTypes;
import committee.nova.mods.avaritia.common.entity.GapingVoidEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GapingVoidRender
extends EntityRenderer<GapingVoidEntity> {
    public GapingVoidRender(EntityRendererProvider.Context context) {
        super(context);
    }

    public static Colour getColour(double age, double a) {
        double l = age / 186.0;
        double f = Math.max(0.0, (l - 0.95) / 0.050000000000000044);
        f = Math.max(f, 1.0 - l * 30.0);
        return new ColourRGBA(f, f, f, a);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GapingVoidEntity p_114482_) {
        return Res.VOID;
    }

    public void render(@NotNull GapingVoidEntity ent, float entityYaw, float ticks, @NotNull PoseStack stack, @NotNull MultiBufferSource buf, int packedLightIn) {
        double dz;
        double dy;
        float age = (float)ent.getAge() + ticks;
        Colour colour = GapingVoidRender.getColour(age, 1.0);
        double scale = GapingVoidEntity.getVoidScale(age);
        double halocoord = 0.58 * scale;
        double haloScaleDist = 2.2 * scale;
        Vec3 cam = this.entityRenderDispatcher.camera.getPosition();
        double dx = ent.getX() - cam.x();
        double len = Math.sqrt(dx * dx + (dy = ent.getY() - cam.y()) * dy + (dz = ent.getZ() - cam.z()) * dz);
        if (len <= haloScaleDist) {
            double close = (haloScaleDist - len) / haloScaleDist;
            halocoord *= 1.0 + close * close * close * close * 1.5;
        }
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees((float)(Math.atan2(dx, dz) * 57.29577951308232)));
        stack.mulPose(Axis.XP.rotationDegrees((float)(Math.atan2(Math.sqrt(dx * dx + dz * dz), dy) * 57.29577951308232 + 90.0)));
        stack.pushPose();
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        TransformingVertexConsumer cons = new TransformingVertexConsumer(buf.getBuffer(AvaritiaRenderTypes.VOID_HALO), stack);
        cons.addVertex((float)(-halocoord), 0.0f, (float)(-halocoord)).setColor((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).setUv(0.0f, 0.0f);
        cons.addVertex((float)(-halocoord), 0.0f, (float)halocoord).setColor((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).setUv(0.0f, 1.0f);
        cons.addVertex((float)halocoord, 0.0f, (float)halocoord).setColor((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).setUv(1.0f, 1.0f);
        cons.addVertex((float)halocoord, 0.0f, (float)(-halocoord)).setColor((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).setUv(1.0f, 0.0f);
        stack.popPose();
        stack.scale((float)scale, (float)scale, (float)scale);
        CCRenderState cc = CCRenderState.instance();
        cc.reset();
        cc.bind(AvaritiaRenderTypes.VOID, buf, stack);
        cc.baseColour = colour.rgba();
        new OBJParser(Const.rl("models/hemisphere.obj")).parse().get("model").render(cc, new IVertexOperation[0]);
        stack.popPose();
    }
}

